/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class Alarm
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(Alarm.class);
    private volatile boolean myDisposed;
    private final List<Request> myRequests;
    private final List<Request> myPendingRequests;
    private final ScheduledExecutorService myExecutorService;
    private final Object LOCK;
    private final ThreadToUse myThreadToUse;
    private JComponent myActivationComponent;

    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.cancelAllRequests();
            if (this.myExecutorService != EdtExecutorService.getScheduledExecutorInstance()) {
                this.myExecutorService.shutdownNow();
            }
        }
    }

    private void checkDisposed() {
        LOG.assertTrue(!this.myDisposed, (Object)"Already disposed");
    }

    public Alarm() {
        this(ThreadToUse.SWING_THREAD);
    }

    public Alarm(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            Alarm.$$$reportNull$$$0(0);
        }
        this(ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public Alarm(@NotNull ThreadToUse threadToUse) {
        if (threadToUse == null) {
            Alarm.$$$reportNull$$$0(1);
        }
        this(threadToUse, null);
    }

    public Alarm(@NotNull ThreadToUse threadToUse, @Nullable Disposable parentDisposable) {
        if (threadToUse == null) {
            Alarm.$$$reportNull$$$0(2);
        }
        this.myRequests = new SmartList();
        this.myPendingRequests = new SmartList();
        this.LOCK = new Object();
        this.myThreadToUse = threadToUse;
        if (threadToUse == ThreadToUse.SHARED_THREAD) {
            DeprecatedMethodException.report((String)"Please use POOLED_THREAD instead");
        }
        ScheduledExecutorService scheduledExecutorService = this.myExecutorService = threadToUse == ThreadToUse.SWING_THREAD ? EdtExecutorService.getScheduledExecutorInstance() : AppExecutorUtil.createBoundedScheduledExecutorService((String)"Alarm Pool", (int)1);
        if (parentDisposable == null) {
            if (threadToUse != ThreadToUse.SWING_THREAD) {
                LOG.error((Throwable)new IllegalArgumentException("You must provide parent Disposable for non-swing thread Alarm"));
            }
        } else {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public void addRequest(final @NotNull Runnable request, final int delayMillis, boolean runWithActiveFrameOnly) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(3);
        }
        if (runWithActiveFrameOnly && !ApplicationManager.getApplication().isActive()) {
            MessageBus bus = ApplicationManager.getApplication().getMessageBus();
            final MessageBusConnection connection = bus.connect((Disposable)this);
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                @Override
                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    connection.disconnect();
                    Alarm.this.addRequest(request, delayMillis);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/util/Alarm$1", "applicationActivated"));
                }
            });
        } else {
            this.addRequest(request, delayMillis);
        }
    }

    private ModalityState getModalityState() {
        if (this.myThreadToUse != ThreadToUse.SWING_THREAD) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return null;
        }
        return application.getDefaultModalityState();
    }

    public void addRequest(@NotNull Runnable request, long delayMillis) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(4);
        }
        this._addRequest(request, delayMillis, this.getModalityState());
    }

    public void addRequest(@NotNull Runnable request, int delayMillis) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(5);
        }
        this._addRequest(request, delayMillis, this.getModalityState());
    }

    public void addComponentRequest(@NotNull Runnable request, int delayMillis) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(6);
        }
        assert (this.myActivationComponent != null);
        this._addRequest(request, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addComponentRequest(@NotNull Runnable request, long delayMillis) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(7);
        }
        assert (this.myActivationComponent != null);
        this._addRequest(request, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addRequest(@NotNull Runnable request, int delayMillis, @Nullable ModalityState modalityState) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, modalityState);
    }

    /*
     * WARNING - void declaration
     */
    public void addRequest(@NotNull Runnable request, long delayMillis, @Nullable ModalityState modalityState) {
        void modalityState2;
        if (request == null) {
            Alarm.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, (ModalityState)modalityState2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllAndAddRequest(@NotNull Runnable request, int delayMillis, @Nullable ModalityState modalityState) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(10);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelAllRequests();
            this._addRequest(request, delayMillis, modalityState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void _addRequest(@NotNull Runnable request, long delayMillis, @Nullable ModalityState modalityState) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(11);
        }
        Object object = this.LOCK;
        synchronized (object) {
            void modalityState2;
            this.checkDisposed();
            Request requestToSchedule = new Request(request, (ModalityState)modalityState2, delayMillis);
            if (this.myActivationComponent == null || this.myActivationComponent.isShowing()) {
                this.add(requestToSchedule);
            } else if (!this.myPendingRequests.contains(requestToSchedule)) {
                this.myPendingRequests.add(requestToSchedule);
            }
        }
    }

    private void add(@NotNull Request requestToSchedule) {
        if (requestToSchedule == null) {
            Alarm.$$$reportNull$$$0(12);
        }
        requestToSchedule.schedule();
        this.myRequests.add(requestToSchedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPending() {
        Object object = this.LOCK;
        synchronized (object) {
            for (Request each : this.myPendingRequests) {
                this.add(each);
            }
            this.myPendingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(@NotNull Runnable request) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(13);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelAndRemoveRequestFrom(request, this.myRequests);
            this.cancelAndRemoveRequestFrom(request, this.myPendingRequests);
            return true;
        }
    }

    private void cancelAndRemoveRequestFrom(@NotNull Runnable request, @NotNull List<Request> list) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(14);
        }
        if (list == null) {
            Alarm.$$$reportNull$$$0(15);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Request r = list.get(i);
            if (r.myTask != request) continue;
            r.cancel();
            list.remove(i);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAllRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.cancelAllRequests(this.myRequests) + this.cancelAllRequests(this.myPendingRequests);
        }
    }

    private int cancelAllRequests(@NotNull List<Request> list) {
        if (list == null) {
            Alarm.$$$reportNull$$$0(16);
        }
        int count = list.size();
        for (Request request : list) {
            request.cancel();
        }
        list.clear();
        return count;
    }

    @TestOnly
    public void drainRequestsInTest() {
        for (Runnable task : this.getUnfinishedRequests()) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected List<Runnable> getUnfinishedRequests() {
        ArrayList<Runnable> unfinishedTasks;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myRequests.isEmpty()) {
                List<Runnable> list = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl5 : MonitorExitStatement: MONITOREXIT : var2_1
                if (list == null) {
                    Alarm.$$$reportNull$$$0(17);
                }
                return list;
            }
            unfinishedTasks = new ArrayList<Runnable>(this.myRequests.size());
            for (Request request : this.myRequests) {
                Runnable existingTask = request.cancel();
                if (existingTask == null) continue;
                unfinishedTasks.add(existingTask);
            }
            this.myRequests.clear();
        }
        ArrayList<Runnable> arrayList = unfinishedTasks;
        if (arrayList == null) {
            Alarm.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TestOnly
    public void waitForAllExecuted(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Request> requests;
        if (timeUnit == null) {
            Alarm.$$$reportNull$$$0(19);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            requests = new ArrayList<Request>(this.myRequests);
        }
        for (Request request : requests) {
            Future<?> future;
            Object object = this.LOCK;
            synchronized (object) {
                future = request.myFuture;
            }
            if (future == null) continue;
            try {
                void unit;
                future.get(timeout, (TimeUnit)unit);
            }
            catch (CancellationException cancellationException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.isEmpty();
        }
    }

    @NotNull
    public Alarm setActivationComponent(@NotNull JComponent component) {
        if (component == null) {
            Alarm.$$$reportNull$$$0(20);
        }
        this.myActivationComponent = component;
        new UiNotifyConnector(component, new Activatable(){

            @Override
            public void showNotify() {
                Alarm.this.flushPending();
            }
        });
        Alarm alarm = this;
        if (alarm == null) {
            Alarm.$$$reportNull$$$0(21);
        }
        return alarm;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadToUse";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestToSchedule";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/Alarm";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/Alarm";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnfinishedRequests";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setActivationComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRequest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addComponentRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cancelAllAndAddRequest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "_addRequest";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cancelRequest";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveRequestFrom";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cancelAllRequests";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllExecuted";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setActivationComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Request
    implements Runnable {
        private Runnable myTask;
        private final ModalityState myModalityState;
        private Future<?> myFuture;
        private final long myDelayMillis;
        private final ClientId myClientId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Async.Schedule
        private Request(@Nullable Runnable task, ModalityState modalityState, long delayMillis) {
            if (task == null) {
                Request.$$$reportNull$$$0(0);
            }
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                this.myTask = task;
                this.myModalityState = modalityState;
                this.myDelayMillis = delayMillis;
                this.myClientId = ClientId.getCurrent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable task;
                if (Alarm.this.myDisposed) {
                    return;
                }
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    task = this.myTask;
                    this.myTask = null;
                }
                if (task != null) {
                    this.runSafely(task);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Async.Execute
        private void runSafely(@Nullable Runnable task) {
            try {
                if (!Alarm.this.myDisposed && task != null) {
                    if (ClientId.Companion.getPropagateAcrossThreads()) {
                        ClientId.withClientId(this.myClientId, () -> QueueProcessor.runSafely(task));
                    } else {
                        QueueProcessor.runSafely(task);
                    }
                }
            }
            finally {
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    Alarm.this.myRequests.remove(this);
                    this.myFuture = null;
                }
            }
        }

        private void schedule() {
            this.myFuture = this.myModalityState == null ? Alarm.this.myExecutorService.schedule(this, this.myDelayMillis, TimeUnit.MILLISECONDS) : EdtScheduledExecutorService.getInstance().schedule(this, this.myModalityState, this.myDelayMillis, TimeUnit.MILLISECONDS);
        }

        @Nullable
        private Runnable cancel() {
            Future<?> future = this.myFuture;
            if (future != null) {
                future.cancel(false);
                this.myFuture = null;
            }
            Runnable task = this.myTask;
            this.myTask = null;
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Runnable task;
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                task = this.myTask;
            }
            return super.toString() + (String)(task != null ? ": " + task : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/Alarm$Request", "<init>"));
        }
    }

    public static enum ThreadToUse {
        SWING_THREAD,
        SHARED_THREAD,
        POOLED_THREAD;

    }
}

