/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.table;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.ui.tabs.impl.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableLayout
extends TabLayout {
    private final JBTabsImpl myTabs;
    public TablePassInfo myLastTableLayout;

    public TableLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
    }

    private TablePassInfo computeLayoutTable(List<TabInfo> visibleInfos) {
        int width;
        TabLabel eachLabel;
        TablePassInfo data = new TablePassInfo(this.myTabs, visibleInfos);
        int eachXPinned = data.toFitRec.x;
        int eachXUnpinned = data.toFitRec.x;
        TableRow eachTableRow = new TableRow(data);
        data.table.add(eachTableRow);
        int requiredRowsPinned = 0;
        int requiredRowsUnpinned = 0;
        int maxX = data.toFitRec.x + data.toFitRec.width;
        int hGap = this.myTabs.getTabHGap();
        boolean showPinnedTabsSeparately = UISettings.getInstance().getState().getShowPinnedTabsInASeparateRow();
        for (TabInfo eachInfo : data.myVisibleInfos) {
            eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            boolean pinned = eachLabel.isPinned();
            Dimension size = eachLabel.getNotStrictPreferredSize();
            width = size.width + hGap;
            if (pinned && showPinnedTabsSeparately) {
                if (eachXPinned + width >= maxX) {
                    ++requiredRowsPinned;
                    eachXPinned = data.toFitRec.x;
                } else if (requiredRowsPinned == 0) {
                    requiredRowsPinned = 1;
                }
                this.myTabs.layout(eachLabel, eachXPinned, 0, size.width, 1);
                eachXPinned += width;
                continue;
            }
            if (eachXUnpinned + size.width + hGap >= maxX) {
                ++requiredRowsUnpinned;
                eachXUnpinned = data.toFitRec.x;
            } else if (requiredRowsUnpinned == 0) {
                requiredRowsUnpinned = 1;
            }
            this.myTabs.layout(eachLabel, eachXUnpinned, 0, size.width, 1);
            eachXUnpinned += width;
        }
        eachXPinned = data.toFitRec.x;
        eachXUnpinned = data.toFitRec.x;
        for (TabInfo eachInfo : data.myVisibleInfos) {
            eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getNotStrictPreferredSize();
            boolean pinned = eachLabel.isPinned();
            width = size.width + hGap;
            if (pinned && showPinnedTabsSeparately) {
                if (eachXPinned + width <= maxX) {
                    eachTableRow.add(eachInfo, width);
                    eachXPinned += width;
                    continue;
                }
                eachTableRow = new TableRow(data);
                data.table.add(eachTableRow);
                eachXPinned = data.toFitRec.x + width;
                eachTableRow.add(eachInfo, width);
                continue;
            }
            if (!(eachXUnpinned + size.width + hGap > maxX || showPinnedTabsSeparately && eachLabel.isNextToLastPinned())) {
                eachTableRow.add(eachInfo, width);
                eachXUnpinned += width;
                continue;
            }
            eachTableRow = new TableRow(data);
            data.table.add(eachTableRow);
            eachXUnpinned = data.toFitRec.x + width;
            eachTableRow.add(eachInfo, width);
        }
        return data;
    }

    public boolean isLastRow(TabInfo info) {
        if (info == null) {
            return false;
        }
        List<TableRow> rows = this.myLastTableLayout.table;
        if (rows.size() > 0) {
            for (TabInfo tabInfo : rows.get((int)(rows.size() - 1)).myColumns) {
                if (tabInfo != info) continue;
                return true;
            }
        }
        return false;
    }

    public LayoutPassInfo layoutTable(List<TabInfo> visibleInfos) {
        this.myTabs.resetLayout(true);
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        TablePassInfo data = new TablePassInfo(this.myTabs, visibleInfos);
        boolean showPinnedTabsSeparately = UISettings.getInstance().getState().getShowPinnedTabsInASeparateRow();
        if (!this.myTabs.isHideTabs()) {
            data = this.computeLayoutTable(visibleInfos);
            insets = this.myTabs.getLayoutInsets();
            eachY = insets.top;
            for (TableRow eachRow : data.table) {
                int eachX = insets.left;
                for (int i = 0; i < eachRow.myColumns.size(); ++i) {
                    TabInfo tabInfo = eachRow.myColumns.get(i);
                    TabLabel label = this.myTabs.myInfo2Label.get(tabInfo);
                    int width = label.isPinned() && showPinnedTabsSeparately ? label.getNotStrictPreferredSize().width : label.getPreferredSize().width;
                    this.myTabs.layout(label, eachX, eachY, width, this.myTabs.myHeaderFitSize.height);
                    label.setAlignmentToCenter(false);
                    boolean lastCell = i == eachRow.myColumns.size() - 1;
                    eachX += width + (lastCell ? 0 : this.myTabs.getTabHGap());
                }
                eachY += this.myTabs.myHeaderFitSize.height;
            }
        }
        if (this.myTabs.getSelectedInfo() != null) {
            JBTabsImpl.Toolbar selectedToolbar = this.myTabs.myInfo2Toolbar.get(this.myTabs.getSelectedInfo());
            int componentY = eachY + (this.myTabs.isEditorTabs() ? 0 : 2) - this.myTabs.getLayoutInsets().top;
            if (!this.myTabs.myHorizontalSide && selectedToolbar != null && !selectedToolbar.isEmpty()) {
                int vSeparatorWidth;
                int toolbarWidth = selectedToolbar.getPreferredSize().width;
                int n = vSeparatorWidth = toolbarWidth > 0 ? this.myTabs.getSeparatorWidth() : 0;
                if (this.myTabs.isSideComponentBefore()) {
                    Rectangle compRect = this.myTabs.layoutComp(toolbarWidth + vSeparatorWidth, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                } else {
                    int width = this.myTabs.getWidth() - toolbarWidth - vSeparatorWidth;
                    Rectangle compRect = this.myTabs.layoutComp(new Rectangle(0, componentY, width, this.myTabs.getHeight()), this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                }
            } else {
                this.myTabs.layoutComp(0, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
            }
        }
        this.myLastTableLayout = data;
        return data;
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            TableLayout.$$$reportNull$$$0(0);
        }
        if (this.myLastTableLayout == null) {
            return super.isDragOut(tabLabel, deltaX, deltaY);
        }
        Rectangle area = new Rectangle(this.myLastTableLayout.toFitRec.width, tabLabel.getBounds().height);
        for (int i = 0; i < this.myLastTableLayout.myVisibleInfos.size(); ++i) {
            area = area.union(this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i)).getBounds());
        }
        return (double)Math.abs(deltaY) > (double)area.height * TableLayout.getDragOutMultiplier();
    }

    @Override
    public int getDropIndexFor(Point point) {
        if (this.myLastTableLayout == null) {
            return -1;
        }
        int result = -1;
        Component c = this.myTabs.getComponentAt(point);
        if (c instanceof JBTabsImpl) {
            for (int i = 0; i < this.myLastTableLayout.myVisibleInfos.size() - 1; ++i) {
                boolean between;
                TabLabel first = this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i));
                TabLabel second = this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i + 1));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean bl = between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.myLastTableLayout.myVisibleInfos.indexOf(info);
            boolean isDropTarget = this.myTabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i = 0; i <= index; ++i) {
                    if (!this.myTabs.isDropTarget((TabInfo)this.myLastTableLayout.myVisibleInfos.get(i))) continue;
                    --index;
                    break;
                }
                result = index;
            } else if (index < this.myLastTableLayout.myVisibleInfos.size()) {
                result = index;
            }
        }
        return result;
    }

    @Override
    public int getDropSideFor(@NotNull Point point) {
        if (point == null) {
            TableLayout.$$$reportNull$$$0(1);
        }
        return TabsUtil.getDropSideFor(point, this.myTabs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabLabel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/impl/table/TableLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropSideFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

