/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.tabs.TabInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class LayoutPassInfo {
    public final List<TabInfo> myVisibleInfos;

    protected LayoutPassInfo(List<TabInfo> visibleInfos) {
        this.myVisibleInfos = visibleInfos;
    }

    @Nullable
    public static TabInfo getPrevious(List<TabInfo> list, int i) {
        return i > 0 ? list.get(i - 1) : null;
    }

    @Nullable
    public static TabInfo getNext(List<TabInfo> list, int i) {
        return i < list.size() - 1 ? list.get(i + 1) : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public abstract int getRowCount();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public abstract int getColumnCount(int var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public abstract TabInfo getTabAt(int var1, int var2);

    public abstract Rectangle getHeaderRectangle();

    @ApiStatus.Experimental
    public List<LineCoordinates> getExtraBorderLines() {
        return null;
    }

    @ApiStatus.Experimental
    public static class LineCoordinates {
        public int x1;
        public int y1;
        public int x2;
        public int y2;

        public LineCoordinates(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Point from() {
            return new Point(this.x1, this.y1);
        }

        public Point to() {
            return new Point(this.x2, this.y2);
        }

        public boolean equals(Object another) {
            if (another instanceof LineCoordinates) {
                LineCoordinates anotherLine = (LineCoordinates)another;
                return this.x1 == anotherLine.x1 && this.y1 == anotherLine.y1 && this.x2 == anotherLine.x2 && this.y2 == anotherLine.y2;
            }
            return false;
        }
    }
}

