/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public class FilteringListModel<T>
extends AbstractListModel<T> {
    private final ListModel<T> myOriginalModel;
    private final List<T> myData = new ArrayList<T>();
    private Condition<? super T> myCondition = null;
    private final ListDataListener myListDataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }
    };

    public FilteringListModel(ListModel<T> originalModel) {
        this.myOriginalModel = originalModel;
        this.myOriginalModel.addListDataListener(this.myListDataListener);
    }

    public void dispose() {
        this.myOriginalModel.removeListDataListener(this.myListDataListener);
    }

    public void setFilter(Condition<? super T> condition) {
        this.myCondition = condition;
        this.refilter();
    }

    private void removeAllElements() {
        int index1 = this.myData.size() - 1;
        if (index1 >= 0) {
            this.myData.clear();
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void refilter() {
        this.removeAllElements();
        int count = 0;
        Collection<T> elements = this.getElementsToFilter();
        for (T elt : elements) {
            if (!this.passElement(elt)) continue;
            this.addToFiltered(elt);
            ++count;
        }
        if (count > 0) {
            this.fireIntervalAdded(this, 0, count - 1);
        }
    }

    @NotNull
    protected Collection<T> getElementsToFilter() {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.myOriginalModel.getSize(); ++i) {
            result.add(this.myOriginalModel.getElementAt(i));
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            FilteringListModel.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    protected void addToFiltered(T elt) {
        this.myData.add(elt);
    }

    @Override
    public int getSize() {
        return this.myData.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.myData.get(index);
    }

    public int getElementIndex(T element) {
        return this.myData.indexOf(element);
    }

    private boolean passElement(T element) {
        return this.myCondition == null || this.myCondition.value(element);
    }

    public boolean contains(T value) {
        return this.myData.contains(value);
    }

    @NotNull
    public ListModel<T> getOriginalModel() {
        ListModel<T> listModel = this.myOriginalModel;
        if (listModel == null) {
            FilteringListModel.$$$reportNull$$$0(1);
        }
        return listModel;
    }

    public void addAll(List<? extends T> elements) {
        ListUtil.addAllItems(this.myOriginalModel, elements);
    }

    public void replaceAll(List<? extends T> elements) {
        ListUtil.removeAllItems(this.myOriginalModel);
        ListUtil.addAllItems(this.myOriginalModel, elements);
    }

    public void remove(int index) {
        ListUtil.removeItem(this.myOriginalModel, index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/speedSearch/FilteringListModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalModel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

