/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.credentialStore.Credentials;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefProxySettings;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JBCefProxyAuthenticator {
    JBCefProxyAuthenticator() {
    }

    @Nullable
    static Credentials getCredentials(@NotNull JBCefBrowserBase browser, @NotNull String proxyServer, int proxyPort) {
        if (browser == null) {
            JBCefProxyAuthenticator.$$$reportNull$$$0(0);
        }
        if (proxyServer == null) {
            JBCefProxyAuthenticator.$$$reportNull$$$0(1);
        }
        Ref credentials = new Ref();
        JBCefProxySettings proxySettings = JBCefProxySettings.getInstance();
        String proxyHost = StringUtil.trimTrailing((String)((String)ObjectUtils.notNull((Object)proxySettings.PROXY_HOST, (Object)"")), (char)'/');
        proxyServer = StringUtil.trimTrailing((String)proxyServer, (char)'/');
        if (proxySettings.PROXY_AUTHENTICATION && proxyServer.equals(proxyHost) && proxySettings.PROXY_PORT == proxyPort) {
            credentials.set((Object)new Credentials(proxySettings.getProxyLogin(), proxySettings.getPlainProxyPassword()));
            if (((Credentials)credentials.get()).getUserName() != null && ((Credentials)credentials.get()).getPassword() != null) {
                return (Credentials)credentials.get();
            }
        }
        if (!GraphicsEnvironment.isHeadless() && !JBCefApp.isOffScreenRenderingMode()) {
            String proxy = proxyServer + ":" + proxyPort;
            Runnable runnable = () -> {
                DataContext dataContext = DataManager.getInstance().getDataContext(browser.getCefBrowser().getUIComponent());
                MyLoginDialog dialog = new MyLoginDialog((Project)CommonDataKeys.PROJECT.getData(dataContext), proxy, proxySettings.getProxyLogin());
                dialog.show();
                credentials.set((Object)dialog.getCredentials());
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (Throwable e) {
                    Logger.getInstance(JBCefProxyAuthenticator.class).error(e);
                }
            }
        }
        return (Credentials)credentials.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "browser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "proxyServer";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/jcef/JBCefProxyAuthenticator";
        objectArray[2] = "getCredentials";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    private static interface GridHelper {
        public void add(int var1, int var2, int var3, Component var4);
    }

    private static class MyLoginDialog
    extends DialogWrapper {
        @NotNull
        private final JBTextField myLoginField;
        @NotNull
        private final JBPasswordField myPasswordField;
        @NotNull
        private final String myProxy;
        @Nullable
        private final String myLogin;
        private volatile Credentials myCredentials;

        MyLoginDialog(@Nullable Project project, @NotNull String proxy, @Nullable String login) {
            if (proxy == null) {
                MyLoginDialog.$$$reportNull$$$0(0);
            }
            super(project, false, DialogWrapper.IdeModalityType.PROJECT);
            this.myLoginField = new JBTextField();
            this.myPasswordField = new JBPasswordField();
            this.myProxy = proxy;
            this.myLogin = login;
            this.setResizable(false);
            this.setTitle(IdeBundle.message("dialog.title.jcef.proxyAuthentication", new Object[0]));
            this.setOKButtonText(IdeBundle.message("dialog.button.ok.jcef.signIn", new Object[0]));
        }

        @Override
        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            GridHelper gh = (gridx, gridy, gridwidth, comp) -> {
                gc.gridx = gridx;
                gc.gridy = gridy;
                gc.gridwidth = gridwidth;
                panel2.add(comp, gc);
            };
            gh.add(0, 0, 3, new JBLabel(IdeBundle.message("dialog.content.jcef.proxyServer", this.myProxy)));
            gh.add(0, 1, 3, new Box.Filler(new Dimension(1, JBUIScale.scale((int)20)), new Dimension(1, JBUIScale.scale((int)20)), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE)));
            gh.add(0, 2, 1, new JBLabel(IdeBundle.message("dialog.content.label.jcef.login", new Object[0]), 4));
            gh.add(1, 2, 2, this.myLoginField);
            gh.add(0, 3, 1, new JBLabel(IdeBundle.message("dialog.content.label.jcef.password", new Object[0]), 4));
            gh.add(1, 3, 2, this.myPasswordField);
            if (this.myLogin != null) {
                this.myLoginField.setText(this.myLogin);
            }
            return panel2;
        }

        @Nullable
        public Credentials getCredentials() {
            return this.myCredentials;
        }

        @Override
        @NotNull
        protected Action getOKAction() {
            return new DialogWrapper.OkAction(){

                @Override
                protected void doAction(ActionEvent e) {
                    myCredentials = new Credentials(myLoginField.getText(), String.valueOf(myPasswordField.getPassword()));
                    super.doAction(e);
                }
            };
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myLogin == null ? this.myLoginField : this.myPasswordField;
        }

        @Override
        public void show() {
            this.init();
            super.show();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxy", "com/intellij/ui/jcef/JBCefProxyAuthenticator$MyLoginDialog", "<init>"));
        }
    }
}

