/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.ui.jcef.JBCefCookie;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import org.cef.callback.CefCookieVisitor;
import org.cef.misc.BoolRef;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBCefCookieManager {
    private static final int DEFAULT_TIMEOUT_FOR_SYNCHRONOUS_FUNCTION = 200;
    private static final Logger LOG = Logger.getInstance(JBCefCookieManager.class);
    private final ReentrantLock myLock;
    private final ExecutorService myExecutorService;
    @NotNull
    private final CefCookieManager myCefCookieManager;

    public JBCefCookieManager() {
        this(CefCookieManager.getGlobalManager());
    }

    private JBCefCookieManager(@NotNull CefCookieManager cefCookieManager) {
        if (cefCookieManager == null) {
            JBCefCookieManager.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantLock();
        this.myExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
        this.myCefCookieManager = cefCookieManager;
    }

    @NotNull
    public CefCookieManager getCefCookieManager() {
        CefCookieManager cefCookieManager = this.myCefCookieManager;
        if (cefCookieManager == null) {
            JBCefCookieManager.$$$reportNull$$$0(1);
        }
        return cefCookieManager;
    }

    @Nullable
    public List<JBCefCookie> getCookies() {
        return this.getCookies(null, false, null);
    }

    @Nullable
    public List<JBCefCookie> getCookies(@NotNull String url) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(2);
        }
        return this.getCookies(url, false, null);
    }

    @Nullable
    public List<JBCefCookie> getCookies(@Nullable String url, @Nullable Boolean includeHttpOnly, @Nullable Integer maxTimeToWait) {
        long startTime = Clock.getTime();
        boolean httpOnly = includeHttpOnly != null ? includeHttpOnly : false;
        int timeout = maxTimeToWait != null ? maxTimeToWait : 200;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        JBCookieVisitor cookieVisitor = new JBCookieVisitor(countDownLatch);
        boolean result = url != null ? this.myCefCookieManager.visitUrlCookies(url, httpOnly, (CefCookieVisitor)cookieVisitor) : this.myCefCookieManager.visitAllCookies((CefCookieVisitor)cookieVisitor);
        if (!result) {
            LOG.debug("Cookies cannot be accessed");
            countDownLatch.countDown();
            return null;
        }
        try {
            result = countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Cookie visiting is interrupted");
        }
        long timeSpent = Clock.getTime() - startTime;
        if (!result) {
            LOG.debug("Timeout for cookie visiting is reached, " + timeSpent + " ms time spent");
        } else {
            LOG.debug("Cookie getting took " + timeSpent + " ms");
        }
        return cookieVisitor.getCookies();
    }

    public boolean setCookie(@NotNull String url, @NotNull JBCefCookie jbCefCookie, boolean doSync) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(3);
        }
        if (jbCefCookie == null) {
            JBCefCookieManager.$$$reportNull$$$0(4);
        }
        if (doSync) {
            return this.setCookie(url, jbCefCookie, null);
        }
        return this.myCefCookieManager.setCookie(url, jbCefCookie.getCefCookie());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean setCookie(@NotNull String url, @NotNull JBCefCookie jbCefCookie, @Nullable Integer maxTimeToWait) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(5);
        }
        if (jbCefCookie == null) {
            JBCefCookieManager.$$$reportNull$$$0(6);
        }
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            Object domain = uri.getHost();
            Object object = domain = ((String)domain).startsWith("www") ? domain : "." + (String)domain;
            if (scheme.equals("http") && jbCefCookie.isSecure()) {
                LOG.warn("Cannot set cookie without secure flag for HTTPS web-site");
                return false;
            }
            if (!((String)domain).contains(jbCefCookie.getDomain())) {
                LOG.warn("Cookie domain `" + jbCefCookie.getDomain() + "` doesn't match URL host `" + (String)domain + "`");
                return false;
            }
        }
        catch (URISyntaxException e) {
            LOG.error((Throwable)e);
            return false;
        }
        int timeout = maxTimeToWait != null ? maxTimeToWait : 200;
        IntFunction<Boolean> checkFunction = timeoutForCheck -> {
            List<JBCefCookie> cookies = this.getCookies(url, null, timeoutForCheck);
            if (cookies == null) {
                return false;
            }
            return cookies.contains(jbCefCookie);
        };
        this.myLock.lock();
        try {
            Future<@NotNull Boolean> future = this.myExecutorService.submit(() -> {
                if (((Boolean)checkFunction.apply(timeout / 2)).booleanValue()) {
                    LOG.debug("Cookie is already set");
                    return true;
                }
                if (!this.myCefCookieManager.setCookie(url, jbCefCookie.getCefCookie())) {
                    LOG.error("Posting task to set cookie is failed");
                    return false;
                }
                while (this.myLock.isLocked()) {
                    boolean result = (Boolean)checkFunction.apply(timeout / 2);
                    if (!result) continue;
                    return true;
                }
                return false;
            });
            try {
                boolean bl = future.get(timeout, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (TimeoutException e) {
                LOG.error("Cookie setting took more than " + timeout + " ms");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
            }
            catch (InterruptedException e) {
                LOG.error("Cookie setting is interrupted");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
                {
                    catch (Exception e2) {
                        LOG.error((Throwable)e2);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    public boolean deleteCookies(boolean doSync) {
        if (doSync) {
            return this.deleteCookies("", "", timeout -> {
                List<JBCefCookie> cookies = this.getCookies(null, false, timeout);
                if (cookies == null) {
                    return false;
                }
                return cookies.isEmpty();
            }, null);
        }
        return this.myCefCookieManager.deleteCookies("", "");
    }

    public boolean deleteCookies(@NotNull String url, boolean doSync) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(7);
        }
        if (doSync) {
            return this.deleteCookies(url, "", timeout -> {
                List<JBCefCookie> cookies = this.getCookies(url, false, timeout);
                if (cookies == null) {
                    return false;
                }
                return cookies.isEmpty();
            }, null);
        }
        return this.myCefCookieManager.deleteCookies(url, "");
    }

    public boolean deleteCookies(@NotNull String url, @NotNull String cookieName, boolean doSync) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(8);
        }
        if (cookieName == null) {
            JBCefCookieManager.$$$reportNull$$$0(9);
        }
        if (doSync) {
            return this.deleteCookies(url, cookieName, null);
        }
        return this.myCefCookieManager.deleteCookies(url, cookieName);
    }

    public boolean deleteCookies(@NotNull String url, @NotNull String cookieName, @Nullable Integer maxTimeToWait) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(10);
        }
        if (cookieName == null) {
            JBCefCookieManager.$$$reportNull$$$0(11);
        }
        IntFunction<Boolean> checkFunction = timeout -> {
            List<JBCefCookie> cookies = this.getCookies(url, false, timeout);
            if (cookies == null) {
                return false;
            }
            return cookies.stream().noneMatch(cefCookie -> cefCookie.getName().equals(cookieName));
        };
        return this.deleteCookies(url, cookieName, checkFunction, maxTimeToWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean deleteCookies(@NotNull String url, @NotNull String cookieName, @NotNull IntFunction<Boolean> checkFunction, @Nullable Integer maxTimeToWait) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(12);
        }
        if (cookieName == null) {
            JBCefCookieManager.$$$reportNull$$$0(13);
        }
        if (checkFunction == null) {
            JBCefCookieManager.$$$reportNull$$$0(14);
        }
        int timeout = maxTimeToWait != null ? maxTimeToWait : 200;
        this.myLock.lock();
        try {
            Future<@NotNull Boolean> future = this.myExecutorService.submit(() -> {
                if (((Boolean)checkFunction.apply(timeout / 2)).booleanValue()) {
                    LOG.debug("No cookies to be deleted");
                    return true;
                }
                if (!this.myCefCookieManager.deleteCookies(url, cookieName)) {
                    LOG.error("Posting task to delete cookies is failed");
                    return false;
                }
                while (this.myLock.isLocked()) {
                    boolean result = (Boolean)checkFunction.apply(timeout / 2);
                    if (!result) continue;
                    return true;
                }
                return false;
            });
            try {
                boolean bl = future.get(timeout, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (TimeoutException e) {
                LOG.error("Cookie deleting took more than " + timeout + " ms");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
            }
            catch (InterruptedException e) {
                LOG.error("Cookie deleting is interrupted");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
                {
                    catch (Exception e2) {
                        LOG.error((Throwable)e2);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefCookieManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefCookieManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jbCefCookie";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefCookieManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefCookieManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCookies";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCookie";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteCookies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JBCookieVisitor
    implements CefCookieVisitor {
        final List<JBCefCookie> myCefCookies = new ArrayList<JBCefCookie>();
        final CountDownLatch myCountDownLatch;

        JBCookieVisitor(CountDownLatch countDownLatch) {
            this.myCountDownLatch = countDownLatch;
        }

        public boolean visit(CefCookie cookie, int count, int total, BoolRef delete) {
            this.myCefCookies.add(new JBCefCookie(cookie));
            if (count >= total - 1) {
                this.myCountDownLatch.countDown();
            }
            return true;
        }

        public List<JBCefCookie> getCookies() {
            return this.myCefCookies;
        }
    }
}

