/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.credentialStore.Credentials;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefCookieManager;
import com.intellij.ui.jcef.JBCefDisposable;
import com.intellij.ui.jcef.JBCefFileSchemeHandlerFactory;
import com.intellij.ui.jcef.JBCefProxyAuthenticator;
import com.intellij.ui.jcef.PropertiesHelper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefNativeAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBCefBrowserBase
implements JBCefDisposable {
    @NotNull
    protected static final String BLANK_URI = "about:blank";
    @NotNull
    private static final Icon ERROR_PAGE_ICON = AllIcons.General.ErrorDialog;
    protected static final String JBCEFBROWSER_INSTANCE_PROP = "JBCefBrowser.instance";
    @NotNull
    private final DisposeHelper myDisposeHelper;
    @Nullable
    private volatile LoadDeferrer myLoadDeferrer;
    @NotNull
    private String myLastRequestedUrl;
    @NotNull
    private final Object myLastRequestedUrlLock;
    @Nullable
    private volatile ErrorPage myErrorPage;
    @NotNull
    protected final PropertiesHelper myPropertiesHelper;
    private static final LazyInitializer.NotNullValue<String> ERROR_PAGE_READER = new LazyInitializer.NotNullValue<String>(){

        @NotNull
        public String initialize() {
            try {
                return new String(FileUtil.loadBytes((InputStream)Objects.requireNonNull(JBCefApp.class.getResourceAsStream("resources/load_error.html"))), StandardCharsets.UTF_8);
            }
            catch (IOException | NullPointerException e) {
                Logger.getInstance(JBCefBrowser.class).error("couldn't find load_error.html", (Throwable)e);
                return "";
            }
        }
    };
    private static final LazyInitializer.NotNullValue<ScaleContext.Cache<String>> BASE64_ERROR_PAGE_ICON = new LazyInitializer.NotNullValue<ScaleContext.Cache<String>>(){

        @NotNull
        public ScaleContext.Cache<String> initialize() {
            return new ScaleContext.Cache(ctx -> {
                String string;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    BufferedImage image = IconUtil.toBufferedImage((Icon)IconUtil.scale((Icon)ERROR_PAGE_ICON, (ScaleContext)ctx), (boolean)false);
                    ImageIO.write((RenderedImage)image, "png", out);
                    string = Base64.getEncoder().encodeToString(out.toByteArray());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        Logger.getInstance(JBCefBrowser.class).error("couldn't write an error image", (Throwable)ex);
                        return "";
                    }
                }
                out.close();
                return string;
            });
        }
    };
    private static final double ZOOM_COMMON_RATIO = 1.2;
    private static final double LOG_ZOOM = Math.log(1.2);
    @NotNull
    protected final JBCefClient myCefClient;
    @NotNull
    protected final CefBrowser myCefBrowser;
    @Nullable
    private final CefLifeSpanHandler myLifeSpanHandler;
    @Nullable
    private final CefLoadHandler myLoadHandler;
    @Nullable
    private final CefRequestHandler myRequestHandler;
    private final ReentrantLock myCookieManagerLock;
    protected volatile boolean myIsCefBrowserCreated;
    @Nullable
    private volatile JBCefCookieManager myJBCefCookieManager;
    private final boolean myIsDefaultClient;
    @Nullable
    private volatile String myCssBgColor;

    JBCefBrowserBase(@NotNull JBCefClient cefClient, @NotNull CefBrowser cefBrowser, boolean isNewBrowserCreated, boolean isDefaultClient) {
        if (cefClient == null) {
            JBCefBrowserBase.$$$reportNull$$$0(0);
        }
        if (cefBrowser == null) {
            JBCefBrowserBase.$$$reportNull$$$0(1);
        }
        this.myDisposeHelper = new DisposeHelper();
        this.myLastRequestedUrl = "";
        this.myLastRequestedUrlLock = new Object();
        this.myPropertiesHelper = new PropertiesHelper();
        this.myCookieManagerLock = new ReentrantLock();
        this.myCefClient = cefClient;
        this.myCefBrowser = cefBrowser;
        this.myIsDefaultClient = isDefaultClient;
        if (isNewBrowserCreated) {
            this.myLifeSpanHandler = new CefLifeSpanHandlerAdapter(){

                public void onAfterCreated(CefBrowser browser) {
                    JBCefBrowserBase.this.myIsCefBrowserCreated = true;
                    LoadDeferrer loader = JBCefBrowserBase.this.myLoadDeferrer;
                    if (loader != null) {
                        loader.load();
                        JBCefBrowserBase.this.myLoadDeferrer = null;
                    }
                }
            };
            cefClient.addLifeSpanHandler(this.myLifeSpanHandler, this.getCefBrowser());
            if (cefBrowser instanceof CefNativeAdapter && ((CefNativeAdapter)cefBrowser).getNativeRef("CefBrowser") != 0L) {
                this.myIsCefBrowserCreated = true;
            }
            this.myLoadHandler = new CefLoadHandlerAdapter(){

                public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                    JBCefBrowserBase.this.setPageBackgroundColor();
                }

                public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                    String html;
                    ErrorPage errorPage = JBCefBrowserBase.this.myErrorPage;
                    String lastRequestedUrl = JBCefBrowserBase.this.getLastRequestedUrl();
                    if (errorPage != null && lastRequestedUrl.equals(failedUrl) && (html = errorPage.create(errorCode, errorText, failedUrl)) != null) {
                        UIUtil.invokeLaterIfNeeded(() -> JBCefBrowserBase.this.compareLastRequestedUrlAndPerform(failedUrl, () -> JBCefBrowserBase.this.loadHTML(html)));
                    }
                }
            };
            cefClient.addLoadHandler(this.myLoadHandler, this.getCefBrowser());
            this.myRequestHandler = new CefRequestHandlerAdapter(){

                public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                    JBCefBrowserBase.this.setLastRequestedUrl((String)ObjectUtils.notNull((Object)request.getURL(), (Object)""));
                    return super.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect);
                }

                public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
                    if (isProxy && !JBCefBrowserBase.this.myPropertiesHelper.is("JBCefBrowserBase.noDefaultAuthCredentials")) {
                        Credentials credentials = JBCefProxyAuthenticator.getCredentials(JBCefBrowserBase.this, host, port);
                        if (credentials != null) {
                            callback.Continue(credentials.getUserName(), credentials.getPasswordAsString());
                            return true;
                        }
                        Logger.getInstance(JBCefBrowserBase.class).error("missing credentials to sign in to proxy");
                    }
                    return super.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback);
                }
            };
            cefClient.addRequestHandler(this.myRequestHandler, this.getCefBrowser());
        } else {
            this.myLifeSpanHandler = null;
            this.myLoadHandler = null;
            this.myRequestHandler = null;
            this.myIsCefBrowserCreated = true;
        }
    }

    public final void loadURL(@NotNull String url) {
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(2);
        }
        if (this.myIsCefBrowserCreated) {
            this.loadUrlImpl(url);
        } else {
            this.myLoadDeferrer = new LoadDeferrer(null, url);
        }
    }

    public final void loadHTML(@NotNull String html, @NotNull String url) {
        if (html == null) {
            JBCefBrowserBase.$$$reportNull$$$0(3);
        }
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(4);
        }
        if (this.myIsCefBrowserCreated) {
            this.loadHtmlImpl(html, url);
        } else {
            this.myLoadDeferrer = new LoadDeferrer(html, url);
        }
    }

    public final void loadHTML(@NotNull String html) {
        if (html == null) {
            JBCefBrowserBase.$$$reportNull$$$0(5);
        }
        this.loadHTML(html, BLANK_URI);
    }

    @NotNull
    public final CefBrowser getCefBrowser() {
        CefBrowser cefBrowser = this.myCefBrowser;
        if (cefBrowser == null) {
            JBCefBrowserBase.$$$reportNull$$$0(6);
        }
        return cefBrowser;
    }

    public final void setZoomLevel(double zoomLevel) {
        this.myCefBrowser.setZoomLevel(Math.log(zoomLevel) / LOG_ZOOM);
    }

    public final double getZoomLevel() {
        return Math.pow(1.2, this.myCefBrowser.getZoomLevel());
    }

    @NotNull
    public final JBCefClient getJBCefClient() {
        JBCefClient jBCefClient = this.myCefClient;
        if (jBCefClient == null) {
            JBCefBrowserBase.$$$reportNull$$$0(7);
        }
        return jBCefClient;
    }

    @NotNull
    public final JBCefCookieManager getJBCefCookieManager() {
        this.myCookieManagerLock.lock();
        if (this.myJBCefCookieManager == null) {
            this.myJBCefCookieManager = new JBCefCookieManager();
        }
        JBCefCookieManager jBCefCookieManager = Objects.requireNonNull(this.myJBCefCookieManager);
        JBCefCookieManager jBCefCookieManager2 = jBCefCookieManager;
        if (jBCefCookieManager2 == null) {
            JBCefBrowserBase.$$$reportNull$$$0(8);
        }
        return jBCefCookieManager2;
        finally {
            this.myCookieManagerLock.unlock();
        }
    }

    public final void setJBCefCookieManager(@NotNull JBCefCookieManager jBCefCookieManager) {
        if (jBCefCookieManager == null) {
            JBCefBrowserBase.$$$reportNull$$$0(9);
        }
        this.myCookieManagerLock.lock();
        try {
            this.myJBCefCookieManager = jBCefCookieManager;
        }
        finally {
            this.myCookieManagerLock.unlock();
        }
    }

    final boolean isCefBrowserCreated() {
        return this.myIsCefBrowserCreated;
    }

    public void dispose() {
        this.dispose(null);
    }

    protected void dispose(@Nullable Runnable subDisposer) {
        this.myDisposeHelper.dispose(() -> {
            if (subDisposer != null) {
                subDisposer.run();
            }
            if (this.myLifeSpanHandler != null) {
                this.getJBCefClient().removeLifeSpanHandler(this.myLifeSpanHandler, this.getCefBrowser());
            }
            if (this.myLoadHandler != null) {
                this.getJBCefClient().removeLoadHandler(this.myLoadHandler, this.getCefBrowser());
            }
            if (this.myRequestHandler != null) {
                this.getJBCefClient().removeRequestHandler(this.myRequestHandler, this.getCefBrowser());
            }
            this.myCefBrowser.stopLoad();
            this.myCefBrowser.close(true);
            if (this.myIsDefaultClient) {
                Disposer.dispose((Disposable)this.myCefClient);
            }
        });
    }

    @Override
    public final boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    @Nullable
    public static JBCefBrowser getJBCefBrowser(@NotNull CefBrowser browser) {
        Container parentComp;
        Component uiComp;
        if (browser == null) {
            JBCefBrowserBase.$$$reportNull$$$0(10);
        }
        if ((uiComp = browser.getUIComponent()) != null && (parentComp = uiComp.getParent()) instanceof JComponent) {
            return (JBCefBrowser)((JComponent)parentComp).getClientProperty(JBCEFBROWSER_INSTANCE_PROP);
        }
        return null;
    }

    public void setPageBackgroundColor(@NotNull String cssColor) {
        if (cssColor == null) {
            JBCefBrowserBase.$$$reportNull$$$0(11);
        }
        this.myCssBgColor = cssColor;
        this.setPageBackgroundColor();
    }

    private void setPageBackgroundColor() {
        if (this.myCssBgColor != null) {
            this.getCefBrowser().executeJavaScript("document.body.style.backgroundColor = \"" + this.myCssBgColor + "\";", BLANK_URI, 0);
        }
    }

    private void loadHtmlImpl(@NotNull String html, @NotNull String url) {
        if (html == null) {
            JBCefBrowserBase.$$$reportNull$$$0(12);
        }
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(13);
        }
        this.loadUrlImpl(JBCefFileSchemeHandlerFactory.registerLoadHTMLRequest(this.getCefBrowser(), html, url));
    }

    private void loadUrlImpl(@NotNull String url) {
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(14);
        }
        this.setLastRequestedUrl("");
        this.getCefBrowser().loadURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastRequestedUrl() {
        Object object = this.myLastRequestedUrlLock;
        synchronized (object) {
            return this.myLastRequestedUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastRequestedUrl(@NotNull String url) {
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(15);
        }
        Object object = this.myLastRequestedUrlLock;
        synchronized (object) {
            this.myLastRequestedUrl = url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareLastRequestedUrlAndPerform(@NotNull String url, @NotNull Runnable action) {
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(16);
        }
        if (action == null) {
            JBCefBrowserBase.$$$reportNull$$$0(17);
        }
        Object object = this.myLastRequestedUrlLock;
        synchronized (object) {
            if (this.myLastRequestedUrl.equals(url)) {
                action.run();
            }
        }
    }

    public void setErrorPage(@Nullable ErrorPage errorPage) {
        this.myErrorPage = errorPage;
    }

    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(18);
        }
        this.myPropertiesHelper.setProperty(name, value);
    }

    @Nullable
    public Object getProperty(@NotNull String name) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(19);
        }
        return this.myPropertiesHelper.getProperty(name);
    }

    void addPropertyChangeListener(@NotNull String name, @NotNull PropertyChangeListener listener2) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(20);
        }
        if (listener2 == null) {
            JBCefBrowserBase.$$$reportNull$$$0(21);
        }
        this.myPropertiesHelper.addPropertyChangeListener(name, listener2);
    }

    void removePropertyChangeListener(@NotNull String name, @NotNull PropertyChangeListener listener2) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(22);
        }
        if (listener2 == null) {
            JBCefBrowserBase.$$$reportNull$$$0(23);
        }
        this.myPropertiesHelper.removePropertyChangeListener(name, listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefClient";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefBrowser";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowserBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jBCefCookieManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssColor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowserBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefBrowser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBCefClient";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBCefCookieManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadURL";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadHTML";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setJBCefCookieManager";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJBCefBrowser";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setPageBackgroundColor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadHtmlImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadUrlImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLastRequestedUrl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compareLastRequestedUrlAndPerform";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class LoadDeferrer {
        @Nullable
        private final String myHtml;
        @NotNull
        private final String myUrl;

        private LoadDeferrer(@NotNull String html, String url) {
            if (url == null) {
                LoadDeferrer.$$$reportNull$$$0(0);
            }
            this.myHtml = html;
            this.myUrl = url;
        }

        public void load() {
            SwingUtilities.invokeLater(this.myHtml == null ? () -> JBCefBrowserBase.this.loadUrlImpl(this.myUrl) : () -> JBCefBrowserBase.this.loadHtmlImpl(this.myHtml, this.myUrl));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ui/jcef/JBCefBrowserBase$LoadDeferrer", "<init>"));
        }
    }

    public static interface ErrorPage {
        public static final ErrorPage DEFAULT = new ErrorPage(){

            @Override
            @NotNull
            public String create(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull CefLoadHandler.ErrorCode errorCode, @NotNull String errorText, @NotNull String failedUrl) {
                if (errorText == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (failedUrl == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (errorCode == null) {
                    1.$$$reportNull$$$0(2);
                }
                int fontSize = (int)((double)EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize() * 1.1);
                int headerFontSize = fontSize + JBUIScale.scale((int)3);
                int headerPaddingTop = headerFontSize / 5;
                int lineHeight = headerFontSize * 2;
                int iconPaddingRight = JBUIScale.scale((int)12);
                Color bgColor = JBColor.background();
                String bgWebColor = String.format("#%02x%02x%02x", bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
                Color fgColor = JBColor.foreground();
                String fgWebColor = String.format("#%02x%02x%02x", fgColor.getRed(), fgColor.getGreen(), fgColor.getBlue());
                String html = (String)ERROR_PAGE_READER.get();
                html = html.replace("${lineHeight}", String.valueOf(lineHeight));
                html = html.replace("${iconPaddingRight}", String.valueOf(iconPaddingRight));
                html = html.replace("${fontSize}", String.valueOf(fontSize));
                html = html.replace("${headerFontSize}", String.valueOf(headerFontSize));
                html = html.replace("${headerPaddingTop}", String.valueOf(headerPaddingTop));
                html = html.replace("${bgWebColor}", bgWebColor);
                html = html.replace("${fgWebColor}", fgWebColor);
                html = html.replace("${errorText}", errorText);
                html = html.replace("${failedUrl}", failedUrl);
                ScaleContext ctx = ScaleContext.create();
                ctx.update(ScaleType.OBJ_SCALE.of(1.2 * (double)headerFontSize / (double)ERROR_PAGE_ICON.getIconHeight()));
                ctx.overrideScale(ScaleType.SYS_SCALE.of(1.0));
                String string = html = html.replace("${base64Image}", (CharSequence)ObjectUtils.notNull((Object)((String)((ScaleContext.Cache)BASE64_ERROR_PAGE_ICON.get()).getOrProvide((UserScaleContext)ctx)), (Object)""));
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorText";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "failedUrl";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorCode";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowserBase$ErrorPage$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowserBase$ErrorPage$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        @Nullable
        public String create(@NotNull CefLoadHandler.ErrorCode var1, @NotNull String var2, @NotNull String var3);
    }

    public static class Properties {
        @NotNull
        public static final String NO_DEFAULT_AUTH_CREDENTIALS = "JBCefBrowserBase.noDefaultAuthCredentials";

        static {
            PropertiesHelper.putType(NO_DEFAULT_AUTH_CREDENTIALS, Boolean.class);
        }
    }
}

