/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefEventUtils;
import com.intellij.ui.jcef.PropertiesHelper;
import com.intellij.util.Consumer;
import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JCefVersionDetails;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefBrowser
extends JBCefBrowserBase {
    @NotNull
    private static final List<java.util.function.Consumer<? super JBCefBrowser>> ourOnBrowserMoveResizeCallbacks = Collections.synchronizedList(new ArrayList(1));
    @NotNull
    private static final Dimension DEF_PREF_SIZE = new Dimension(800, 600);
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final CefFocusHandler myCefFocusHandler;
    @NotNull
    private final CefKeyboardHandler myKeyboardHandler;
    private JDialog myDevtoolsFrame;
    protected CefContextMenuHandler myDefaultContextMenuHandler;
    private volatile boolean myFirstShow;

    public JBCefBrowser(@NotNull JBCefClient client, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(0);
        }
        this(client, false, url);
    }

    public JBCefBrowser(@NotNull CefBrowser cefBrowser, @NotNull JBCefClient client) {
        if (cefBrowser == null) {
            JBCefBrowser.$$$reportNull$$$0(1);
        }
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(2);
        }
        this(cefBrowser, client, false, null);
    }

    private JBCefBrowser(@NotNull JBCefClient client, boolean isDefaultClient, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(3);
        }
        this(null, client, isDefaultClient, url);
    }

    private JBCefBrowser(@Nullable CefBrowser cefBrowser, @NotNull JBCefClient client, boolean isDefaultClient, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(4);
        }
        super(client, JBCefBrowser.createBrowser(cefBrowser, client.getCefClient(), url), cefBrowser == null, isDefaultClient);
        this.myDevtoolsFrame = null;
        this.myFirstShow = true;
        if (client.isDisposed()) {
            throw new IllegalArgumentException("JBCefClient is disposed");
        }
        this.myComponent = this.createComponent();
        this.myCefFocusHandler = new CefFocusHandlerAdapter(){

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean componentFocused = focusOwner == JBCefBrowser.this.getComponent() || focusOwner == JBCefBrowser.this.getCefBrowser().getUIComponent();
                boolean focusOnNavigation = JBCefBrowser.this.myFirstShow && JBCefBrowser.this.myPropertiesHelper.is("JBCefBrowser.focusOnShow") || JBCefBrowser.this.myPropertiesHelper.is("JBCefBrowser.focusOnNavigation") || componentFocused;
                JBCefBrowser.this.myFirstShow = false;
                if (source == CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION && !focusOnNavigation) {
                    if (SystemInfoRt.isWindows) {
                        JBCefBrowser.this.myCefBrowser.setFocus(false);
                    }
                    return true;
                }
                if (!browser.getUIComponent().hasFocus()) {
                    if (SystemInfoRt.isLinux) {
                        browser.getUIComponent().requestFocus();
                    } else {
                        browser.getUIComponent().requestFocusInWindow();
                    }
                }
                return false;
            }
        };
        this.myCefClient.addFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
        this.myKeyboardHandler = new CefKeyboardHandlerAdapter(){

            public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
                boolean consume;
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl = consume = focusOwner != browser.getUIComponent();
                if (consume && SystemInfoRt.isMac && JBCefEventUtils.isUpDownKeyEvent(cefKeyEvent)) {
                    return true;
                }
                Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (focusedWindow == null) {
                    return true;
                }
                KeyEvent javaKeyEvent = JBCefEventUtils.convertCefKeyEvent(cefKeyEvent, focusedWindow);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(javaKeyEvent);
                return consume;
            }
        };
        this.myCefClient.addKeyboardHandler(this.myKeyboardHandler, this.myCefBrowser);
        this.myDefaultContextMenuHandler = this.createDefaultContextMenuHandler();
        this.myCefClient.addContextMenuHandler(this.myDefaultContextMenuHandler, this.getCefBrowser());
    }

    @NotNull
    private static CefBrowser createBrowser(@Nullable CefBrowser cefBrowser, @NotNull CefClient client, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(5);
        }
        boolean mode = JBCefApp.isOffScreenRenderingMode();
        CefBrowser cefBrowser2 = cefBrowser != null ? cefBrowser : client.createBrowser(url != null ? url : "about:blank", mode, false, null);
        if (cefBrowser2 == null) {
            JBCefBrowser.$$$reportNull$$$0(6);
        }
        return cefBrowser2;
    }

    protected DefaultCefContextMenuHandler createDefaultContextMenuHandler() {
        boolean isInternal = ApplicationManager.getApplication().isInternal();
        return new DefaultCefContextMenuHandler(isInternal);
    }

    @NotNull
    private JPanel createComponent() {
        final Component uiComp = this.getCefBrowser().getUIComponent();
        JPanel resultPanel = new JPanel(new BorderLayout()){

            @Override
            public void setBackground(Color bg) {
                uiComp.setBackground(bg);
                super.setBackground(bg);
            }

            @Override
            public void removeNotify() {
                if (SystemInfoRt.isWindows && JBCefBrowser.this.myCefBrowser.getUIComponent().hasFocus()) {
                    JBCefBrowser.this.myCefBrowser.setFocus(false);
                }
                JBCefBrowser.this.myFirstShow = true;
                super.removeNotify();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return size.width > 0 && size.height > 0 ? size : DEF_PREF_SIZE;
            }

            @Override
            protected void processFocusEvent(FocusEvent e) {
                super.processFocusEvent(e);
                if (e.getID() == 1004) {
                    uiComp.requestFocusInWindow();
                }
            }
        };
        resultPanel.setBackground(JBColor.background());
        resultPanel.putClientProperty("JBCefBrowser.instance", this);
        if (SystemInfoRt.isMac) {
            ShortcutProvider.registerShortcuts(resultPanel, this);
        }
        resultPanel.add(uiComp, "Center");
        if (SystemInfoRt.isWindows) {
            this.myCefBrowser.getUIComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (JBCefBrowser.this.myCefBrowser.getUIComponent().isFocusable()) {
                        JBCefBrowser.this.getCefBrowser().setFocus(true);
                    }
                }
            });
        }
        resultPanel.setFocusCycleRoot(true);
        resultPanel.setFocusTraversalPolicyProvider(true);
        resultPanel.setFocusTraversalPolicy(new MyFTP());
        resultPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }
        });
        JPanel jPanel = resultPanel;
        if (jPanel == null) {
            JBCefBrowser.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    public static void addOnBrowserMoveResizeCallback(@NotNull java.util.function.Consumer<? super JBCefBrowser> callback) {
        if (callback == null) {
            JBCefBrowser.$$$reportNull$$$0(8);
        }
        ourOnBrowserMoveResizeCallbacks.add(callback);
    }

    public static void removeOnBrowserMoveResizeCallback(@NotNull java.util.function.Consumer<? super JBCefBrowser> callback) {
        if (callback == null) {
            JBCefBrowser.$$$reportNull$$$0(9);
        }
        ourOnBrowserMoveResizeCallbacks.remove(callback);
    }

    public JBCefBrowser() {
        this(JBCefApp.getInstance().createClient(), true, null);
    }

    public JBCefBrowser(@NotNull String url) {
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(10);
        }
        this(JBCefApp.getInstance().createClient(), true, url);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            JBCefBrowser.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    @Override
    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (name == null) {
            JBCefBrowser.$$$reportNull$$$0(12);
        }
        super.setProperty(name, value);
    }

    @Nullable
    private static Window getActiveFrame() {
        for (Frame frame : Frame.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    public void openDevtools() {
        if (this.myDevtoolsFrame != null) {
            this.myDevtoolsFrame.toFront();
            return;
        }
        Window activeFrame = JBCefBrowser.getActiveFrame();
        if (activeFrame == null) {
            return;
        }
        Rectangle bounds = activeFrame.getGraphicsConfiguration().getBounds();
        this.myDevtoolsFrame = new JDialog(activeFrame);
        this.myDevtoolsFrame.setTitle("JCEF DevTools");
        this.myDevtoolsFrame.setDefaultCloseOperation(2);
        this.myDevtoolsFrame.setBounds(bounds.width / 4 + 100, bounds.height / 4 + 100, bounds.width / 2, bounds.height / 2);
        this.myDevtoolsFrame.setLayout(new BorderLayout());
        final JBCefBrowser devTools = new JBCefBrowser(this.myCefBrowser.getDevTools(), this.myCefClient);
        this.myDevtoolsFrame.add((Component)devTools.getComponent(), "Center");
        this.myDevtoolsFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                JBCefBrowser.this.myDevtoolsFrame = null;
                Disposer.dispose((Disposable)devTools);
            }
        });
        this.myDevtoolsFrame.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose(() -> {
            this.myCefClient.removeFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
            this.myCefClient.removeKeyboardHandler(this.myKeyboardHandler, this.myCefBrowser);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefBrowser";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createBrowser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBrowser";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addOnBrowserMoveResizeCallback";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeOnBrowserMoveResizeCallback";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFTP
    extends FocusTraversalPolicy {
        private MyFTP() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }
    }

    protected class DefaultCefContextMenuHandler
    extends CefContextMenuHandlerAdapter {
        protected static final int DEBUG_COMMAND_ID = 28500;
        private final boolean isInternal;

        public DefaultCefContextMenuHandler(boolean isInternal) {
            this.isInternal = isInternal;
        }

        public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
            if (this.isInternal) {
                model.addItem(28500, "Open DevTools");
            }
        }

        public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
            if (commandId == 28500) {
                JBCefBrowser.this.openDevtools();
                return true;
            }
            return false;
        }
    }

    private static final class ShortcutProvider {
        private static final List<Pair<String, AnAction>> ourActions = ShortcutProvider.isSupportedByJCefApi() ? List.of(ShortcutProvider.createAction("$Cut", CefFrame::cut), ShortcutProvider.createAction("$Copy", CefFrame::copy), ShortcutProvider.createAction("$Paste", CefFrame::paste), ShortcutProvider.createAction("$Delete", CefFrame::delete), ShortcutProvider.createAction("$SelectAll", CefFrame::selectAll), ShortcutProvider.createAction("$Undo", CefFrame::undo), ShortcutProvider.createAction("$Redo", CefFrame::redo)) : List.of();

        private ShortcutProvider() {
        }

        private static boolean isSupportedByJCefApi() {
            try {
                JCefAppConfig.getVersionDetails();
                return true;
            }
            catch (JCefVersionDetails.VersionUnavailableException | NoSuchMethodError e) {
                Logger.getInstance(ShortcutProvider.class).warn("JCEF shortcuts are unavailable (incompatible API)", e);
                return false;
            }
        }

        private static Pair<String, AnAction> createAction(String shortcut, java.util.function.Consumer<? super CefFrame> action) {
            return Pair.create((Object)shortcut, (Object)LightEditActionFactory.create((Consumer<? super AnActionEvent>)((Consumer)event -> {
                Component component = event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
                if (component == null) {
                    return;
                }
                Container parentComponent = component.getParent();
                if (!(parentComponent instanceof JComponent)) {
                    return;
                }
                Object browser = ((JComponent)parentComponent).getClientProperty("JBCefBrowser.instance");
                if (!(browser instanceof JBCefBrowser)) {
                    return;
                }
                action.accept(((JBCefBrowser)browser).getCefBrowser().getFocusedFrame());
            })));
        }

        private static void registerShortcuts(JComponent uiComp, JBCefBrowser jbCefBrowser) {
            ActionManager actionManager = ActionManager.getInstance();
            for (Pair<String, AnAction> action : ourActions) {
                ((AnAction)action.second).registerCustomShortcutSet(actionManager.getAction((String)action.first).getShortcutSet(), uiComp, jbCefBrowser);
            }
        }
    }

    public static class Properties
    extends JBCefBrowserBase.Properties {
        @NotNull
        public static final String FOCUS_ON_NAVIGATION = "JBCefBrowser.focusOnNavigation";
        @NotNull
        public static final String FOCUS_ON_SHOW = "JBCefBrowser.focusOnShow";

        static {
            PropertiesHelper.putType(FOCUS_ON_NAVIGATION, Boolean.class);
            PropertiesHelper.putType(FOCUS_ON_SHOW, Boolean.class);
        }
    }
}

