/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.registry.Registry;

enum ScrollSource {
    MOUSE_WHEEL{

        @Override
        boolean isInterpolationEnabled() {
            return ScrollSource.isInterpolationEnabledByRegistry() && Registry.is((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel", (boolean)true);
        }

        @Override
        int getInterpolationDelay(double rotation) {
            if (!this.isInterpolationEnabled()) {
                return 0;
            }
            int min = Registry.intValue((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel.delay.min", (int)60);
            int max = Registry.intValue((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel.delay.max", (int)140);
            return Math.max(min, Math.min(max, (int)Math.round((double)max * Math.abs(rotation))));
        }
    }
    ,
    TOUCHPAD{

        @Override
        boolean isInterpolationEnabled() {
            return ScrollSource.isInterpolationEnabledByRegistry() && Registry.is((String)"idea.true.smooth.scrolling.interpolation.precision.touchpad", (boolean)true);
        }

        @Override
        int getInterpolationDelay(double rotation) {
            return !this.isInterpolationEnabled() ? 0 : Registry.intValue((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel.delay.min", (int)20);
        }
    }
    ,
    SCROLLBAR{

        @Override
        boolean isInterpolationEnabled() {
            return ScrollSource.isInterpolationEnabledByRegistry() && Registry.is((String)"idea.true.smooth.scrolling.interpolation.scrollbar", (boolean)true);
        }

        @Override
        int getInterpolationDelay(double rotation) {
            return !this.isInterpolationEnabled() ? 0 : Registry.intValue((String)"idea.true.smooth.scrolling.interpolation.scrollbar.delay", (int)30);
        }
    }
    ,
    UNKNOWN{

        @Override
        boolean isInterpolationEnabled() {
            return ScrollSource.isInterpolationEnabledByRegistry() && Registry.is((String)"idea.true.smooth.scrolling.interpolation.other", (boolean)true);
        }

        @Override
        int getInterpolationDelay(double rotation) {
            return !this.isInterpolationEnabled() ? 0 : Registry.intValue((String)"idea.true.smooth.scrolling.interpolation.other.delay", (int)120);
        }
    };


    private static boolean isInterpolationEnabledByRegistry() {
        return Registry.is((String)"idea.true.smooth.scrolling.interpolation", (boolean)false);
    }

    abstract boolean isInterpolationEnabled();

    abstract int getInterpolationDelay(double var1);
}

