/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBLoadingPanel
extends JPanel {
    private final JPanel myPanel;
    final LoadingDecorator myDecorator;
    private final Collection<JBLoadingPanelListener> myListeners;

    public JBLoadingPanel(@Nullable LayoutManager manager, @NotNull Disposable parent) {
        if (parent == null) {
            JBLoadingPanel.$$$reportNull$$$0(0);
        }
        this(manager, parent, -1);
    }

    public JBLoadingPanel(@Nullable LayoutManager manager, @NotNull Disposable parent, int startDelayMs) {
        if (parent == null) {
            JBLoadingPanel.$$$reportNull$$$0(1);
        }
        this(manager, (NotNullFunction<? super JPanel, ? extends LoadingDecorator>)((NotNullFunction)panel2 -> new LoadingDecorator((JComponent)panel2, parent, startDelayMs)));
    }

    public JBLoadingPanel(@Nullable LayoutManager manager, @NotNull NotNullFunction<? super JPanel, ? extends LoadingDecorator> createLoadingDecorator) {
        if (createLoadingDecorator == null) {
            JBLoadingPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPanel = manager == null ? new JPanel() : new JPanel(manager);
        this.myPanel.setOpaque(false);
        this.myPanel.setFocusable(false);
        this.myDecorator = (LoadingDecorator)createLoadingDecorator.fun((Object)this.myPanel);
        super.add((Component)this.myDecorator.getComponent(), "Center");
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (!(mgr instanceof BorderLayout)) {
            throw new IllegalArgumentException(String.valueOf(mgr));
        }
        super.setLayout(mgr);
        if (this.myDecorator != null) {
            super.add((Component)this.myDecorator.getComponent(), "Center");
        }
    }

    public void setLoadingText(@Nls String text) {
        this.myDecorator.setLoadingText(text);
    }

    public void stopLoading() {
        this.myDecorator.stopLoading();
        for (JBLoadingPanelListener listener2 : this.myListeners) {
            listener2.onLoadingFinish();
        }
    }

    public boolean isLoading() {
        return this.myDecorator.isLoading();
    }

    public void startLoading() {
        this.myDecorator.startLoading(false);
        for (JBLoadingPanelListener listener2 : this.myListeners) {
            listener2.onLoadingStart();
        }
    }

    public void addListener(@NotNull JBLoadingPanelListener listener2) {
        if (listener2 == null) {
            JBLoadingPanel.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener2);
    }

    public boolean removeListener(@NotNull JBLoadingPanelListener listener2) {
        if (listener2 == null) {
            JBLoadingPanel.$$$reportNull$$$0(4);
        }
        return this.myListeners.remove(listener2);
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    @Override
    public Component add(Component comp) {
        return this.myPanel.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.myPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.myPanel.add(comp, constraints);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getContentPanel().getPreferredSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createLoadingDecorator";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/JBLoadingPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

