/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\b\u0016\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bB\u001d\b\u0017\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eB\u0005\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\nJ\u0016\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/ui/components/ActionLink;", "Ljavax/swing/JButton;", "action", "Ljavax/swing/Action;", "(Ljavax/swing/Action;)V", "text", "", "perform", "Lkotlin/Function1;", "Ljava/awt/event/ActionEvent;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "listener", "Ljava/awt/event/ActionListener;", "(Ljava/lang/String;Ljava/awt/event/ActionListener;)V", "()V", "newValue", "", "autoHideOnDisable", "getAutoHideOnDisable", "()Z", "setAutoHideOnDisable", "(Z)V", "visited", "getVisited", "setVisited", "getUIClassID", "setContextHelpIcon", "setDropDownLinkIcon", "setExternalLinkIcon", "setIcon", "anIcon", "Ljavax/swing/Icon;", "atRight", "setLinkIcon", "withFont", "font", "Ljava/awt/Font;", "intellij.platform.ide"})
public class ActionLink
extends JButton {
    private boolean autoHideOnDisable;
    private boolean visited;

    @Override
    @NotNull
    public String getUIClassID() {
        return "LinkButtonUI";
    }

    public final boolean getAutoHideOnDisable() {
        return this.autoHideOnDisable;
    }

    public final void setAutoHideOnDisable(boolean newValue) {
        boolean oldValue = this.autoHideOnDisable;
        if (oldValue == newValue) {
            return;
        }
        this.autoHideOnDisable = newValue;
        this.firePropertyChange("autoHideOnDisable", oldValue, newValue);
        this.setVisible(!newValue || this.isEnabled());
    }

    public final boolean getVisited() {
        return this.visited;
    }

    public final void setVisited(boolean newValue) {
        boolean oldValue = this.visited;
        if (oldValue == newValue) {
            return;
        }
        this.visited = newValue;
        this.firePropertyChange("visited", oldValue, newValue);
        this.repaint();
    }

    public final void setLinkIcon() {
        Icon icon = AllIcons.Ide.Link;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Ide.Link");
        this.setIcon(icon, false);
    }

    public final void setContextHelpIcon() {
        Icon icon = AllIcons.General.ContextHelp;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.General.ContextHelp");
        this.setIcon(icon, false);
    }

    public final void setExternalLinkIcon() {
        Icon icon = AllIcons.Ide.External_link_arrow;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Ide.External_link_arrow");
        this.setIcon(icon, true);
    }

    public final void setDropDownLinkIcon() {
        Icon icon = AllIcons.General.LinkDropTriangle;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.General.LinkDropTriangle");
        this.setIcon(icon, true);
    }

    public final void setIcon(@NotNull Icon anIcon, boolean atRight) {
        Intrinsics.checkNotNullParameter((Object)anIcon, (String)"anIcon");
        this.setIcon(anIcon);
        this.setIconTextGap(JBUIScale.scale((int)(atRight ? 1 : 4)));
        this.setHorizontalTextPosition(atRight ? 10 : 11);
    }

    @NotNull
    public final ActionLink withFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.setFont(font);
        return this;
    }

    public ActionLink() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public final void propertyChange(PropertyChangeEvent it) {
                if (this.getAutoHideOnDisable()) {
                    this.setVisible(this.isEnabled());
                }
            }
        });
        this.autoHideOnDisable = true;
    }

    public ActionLink(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this();
        this.setAction(action);
    }

    public ActionLink(@Nls @NotNull String text, final @NotNull Function1<? super ActionEvent, Unit> perform) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(perform, (String)"perform");
        this(text, new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                ActionEvent actionEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)actionEvent, (String)"it");
                perform.invoke((Object)actionEvent);
            }
        });
    }

    @JvmOverloads
    public ActionLink(@Nls @NotNull String text, @Nullable ActionListener listener2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this();
            this.setText(text);
            ActionListener actionListener = listener2;
            if (actionListener == null) break block0;
            ActionListener actionListener2 = actionListener;
            boolean bl = false;
            boolean bl2 = false;
            ActionListener it = actionListener2;
            boolean bl3 = false;
            this.addActionListener(it);
        }
    }

    public /* synthetic */ ActionLink(String string, ActionListener actionListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            actionListener = null;
        }
        this(string, actionListener);
    }

    @JvmOverloads
    public ActionLink(@Nls @NotNull String text) {
        this(text, null, 2, null);
    }
}

