/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxTreeHelper {
    private static final Key<Runnable> TREE_LISTENERS_REMOVER = Key.create((String)"TREE_LISTENERS_REMOVER");
    public static final CheckboxTreeBase.CheckPolicy DEFAULT_POLICY = new CheckboxTreeBase.CheckPolicy(true, true, false, true);
    private final CheckboxTreeBase.CheckPolicy myCheckPolicy;
    private final EventDispatcher<CheckboxTreeListener> myEventDispatcher;

    public CheckboxTreeHelper(@NotNull CheckboxTreeBase.CheckPolicy checkPolicy, @NotNull EventDispatcher<CheckboxTreeListener> dispatcher) {
        if (checkPolicy == null) {
            CheckboxTreeHelper.$$$reportNull$$$0(0);
        }
        if (dispatcher == null) {
            CheckboxTreeHelper.$$$reportNull$$$0(1);
        }
        this.myCheckPolicy = checkPolicy;
        this.myEventDispatcher = dispatcher;
    }

    public void initTree(@NotNull Tree tree, JComponent mainComponent, CheckboxTreeBase.CheckboxTreeCellRendererBase cellRenderer) {
        if (tree == null) {
            CheckboxTreeHelper.$$$reportNull$$$0(2);
        }
        CheckboxTreeHelper.removeTreeListeners(mainComponent);
        tree.setCellRenderer(cellRenderer);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions(tree);
        KeyListener keyListener = this.setupKeyListener(tree, mainComponent);
        ClickListener clickListener = this.setupMouseListener(tree, mainComponent, cellRenderer);
        ComponentUtil.putClientProperty((JComponent)mainComponent, TREE_LISTENERS_REMOVER, () -> {
            mainComponent.removeKeyListener(keyListener);
            clickListener.uninstall((Component)mainComponent);
        });
    }

    public void setNodeState(Tree tree, CheckedTreeNode node, boolean checked) {
        this.changeNodeState(node, checked);
        this.adjustParentsAndChildren(node, checked);
        tree.repaint();
        TreeModel model = tree.getModel();
        model.valueForPathChanged(new TreePath(node.getPath()), node.getUserObject());
    }

    private void toggleNode(Tree tree, CheckedTreeNode node) {
        this.setNodeState(tree, node, !node.isChecked());
    }

    private void adjustParentsAndChildren(CheckedTreeNode node, boolean checked) {
        if (!checked) {
            if (this.myCheckPolicy.uncheckParentWithUncheckedChild) {
                for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof CheckedTreeNode)) continue;
                    this.changeNodeState((CheckedTreeNode)parent, false);
                }
            }
            if (this.myCheckPolicy.uncheckChildrenWithUncheckedParent) {
                this.uncheckChildren(node);
            }
        } else {
            if (this.myCheckPolicy.checkChildrenWithCheckedParent) {
                this.checkChildren(node);
            }
            if (this.myCheckPolicy.checkParentWithCheckedChild) {
                for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof CheckedTreeNode)) continue;
                    this.changeNodeState((CheckedTreeNode)parent, true);
                }
            }
        }
    }

    private void changeNodeState(CheckedTreeNode node, boolean checked) {
        if (node.isChecked() != checked) {
            ((CheckboxTreeListener)this.myEventDispatcher.getMulticaster()).beforeNodeStateChanged(node);
            node.setChecked(checked);
            ((CheckboxTreeListener)this.myEventDispatcher.getMulticaster()).nodeStateChanged(node);
        }
    }

    private void uncheckChildren(CheckedTreeNode node) {
        Enumeration children2 = node.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            CheckedTreeNode child = (CheckedTreeNode)o;
            this.changeNodeState(child, false);
            this.uncheckChildren(child);
        }
    }

    private void checkChildren(CheckedTreeNode node) {
        Enumeration children2 = node.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            CheckedTreeNode child = (CheckedTreeNode)o;
            this.changeNodeState(child, true);
            this.checkChildren(child);
        }
    }

    private KeyListener setupKeyListener(final Tree tree, final JComponent mainComponent) {
        KeyAdapter listener2 = new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CheckboxTreeHelper.isToggleEvent(e, mainComponent)) {
                    TreePath treePath = tree.getLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object o = treePath.getLastPathComponent();
                    if (!(o instanceof CheckedTreeNode)) {
                        return;
                    }
                    CheckedTreeNode firstNode = (CheckedTreeNode)o;
                    if (!firstNode.isEnabled()) {
                        return;
                    }
                    CheckboxTreeHelper.this.toggleNode(tree, firstNode);
                    boolean checked = firstNode.isChecked();
                    TreePath[] selectionPaths = tree.getSelectionPaths();
                    for (int i = 0; selectionPaths != null && i < selectionPaths.length; ++i) {
                        TreePath selectionPath = selectionPaths[i];
                        Object o1 = selectionPath.getLastPathComponent();
                        if (!(o1 instanceof CheckedTreeNode)) continue;
                        CheckedTreeNode node = (CheckedTreeNode)o1;
                        CheckboxTreeHelper.this.setNodeState(tree, node, checked);
                    }
                    e.consume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CheckboxTreeHelper$1", "keyPressed"));
            }
        };
        mainComponent.addKeyListener(listener2);
        return listener2;
    }

    public static boolean isToggleEvent(KeyEvent e, JComponent mainComponent) {
        return e.getKeyCode() == 32 && SpeedSearchSupply.getSupply(mainComponent) == null;
    }

    private ClickListener setupMouseListener(final Tree tree, JComponent mainComponent, final CheckboxTreeBase.CheckboxTreeCellRendererBase cellRenderer) {
        ClickListener listener2 = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int row;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((row = tree.getRowForLocation(e.getX(), e.getY())) < 0) {
                    return false;
                }
                Object o = tree.getPathForRow(row).getLastPathComponent();
                if (!(o instanceof CheckedTreeNode)) {
                    return false;
                }
                Rectangle rowBounds = tree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                cellRenderer.validate();
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = checkBounds.width = rowBounds.height;
                }
                CheckedTreeNode node = (CheckedTreeNode)o;
                if (checkBounds.contains(e.getPoint()) && cellRenderer.myCheckbox.isVisible()) {
                    if (node.isEnabled()) {
                        CheckboxTreeHelper.this.toggleNode(tree, node);
                        tree.setSelectionRow(row);
                        return true;
                    }
                } else if (clickCount > 1 && clickCount % 2 == 0) {
                    ((CheckboxTreeListener)CheckboxTreeHelper.this.myEventDispatcher.getMulticaster()).mouseDoubleClicked(node);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CheckboxTreeHelper$2", "onClick"));
            }
        };
        listener2.installOn((Component)mainComponent);
        return listener2;
    }

    private static void removeTreeListeners(JComponent mainComponent) {
        Runnable remover = (Runnable)ComponentUtil.getClientProperty((JComponent)mainComponent, TREE_LISTENERS_REMOVER);
        if (remover != null) {
            remover.run();
        }
    }

    public static <T> T[] getCheckedNodes(final Class<T> nodeType, final @Nullable Tree.NodeFilter<? super T> filter, TreeModel model) {
        final ArrayList nodes = new ArrayList();
        Object root = model.getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            throw new IllegalStateException("The root must be instance of the " + CheckedTreeNode.class.getName() + ": " + root.getClass().getName());
        }
        new Object(){

            public void collect(CheckedTreeNode node) {
                if (node.isLeaf()) {
                    Object userObject = node.getUserObject();
                    if (node.isChecked() && userObject != null && nodeType.isAssignableFrom(userObject.getClass())) {
                        Object value = userObject;
                        if (filter != null && !filter.accept(value)) {
                            return;
                        }
                        nodes.add(value);
                    }
                } else {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        TreeNode child = node.getChildAt(i);
                        if (!(child instanceof CheckedTreeNode)) continue;
                        this.collect((CheckedTreeNode)child);
                    }
                }
            }
        }.collect((CheckedTreeNode)root);
        Object[] result = ArrayUtil.newArray(nodeType, (int)nodes.size());
        nodes.toArray(result);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkPolicy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/CheckboxTreeHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

