/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskState;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@ApiStatus.NonExtendable
public abstract class ProjectTaskManager {
    public static final ProjectTask[] EMPTY_TASKS_ARRAY = new ProjectTask[0];
    @NotNull
    protected final Project myProject;

    public ProjectTaskManager(@NotNull Project project) {
        if (project == null) {
            ProjectTaskManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static ProjectTaskManager getInstance(Project project) {
        return ServiceManager.getService(project, ProjectTaskManager.class);
    }

    public abstract Promise<Result> run(@NotNull ProjectTask var1);

    public abstract Promise<Result> run(@NotNull ProjectTaskContext var1, @NotNull ProjectTask var2);

    public abstract Promise<Result> buildAllModules();

    public abstract Promise<Result> rebuildAllModules();

    public abstract Promise<Result> build(Module ... var1);

    public abstract Promise<Result> rebuild(Module ... var1);

    public abstract Promise<Result> compile(VirtualFile ... var1);

    public abstract Promise<Result> build(ProjectModelBuildableElement ... var1);

    public abstract Promise<Result> rebuild(ProjectModelBuildableElement ... var1);

    public abstract ProjectTask createAllModulesBuildTask(boolean var1, Project var2);

    public abstract ProjectTask createModulesBuildTask(Module var1, boolean var2, boolean var3, boolean var4);

    public abstract ProjectTask createModulesBuildTask(Module[] var1, boolean var2, boolean var3, boolean var4);

    public abstract ProjectTask createBuildTask(boolean var1, ProjectModelBuildableElement ... var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public abstract void run(@NotNull ProjectTask var1, @Nullable ProjectTaskNotification var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public abstract void run(@NotNull ProjectTaskContext var1, @NotNull ProjectTask var2, @Nullable ProjectTaskNotification var3);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public abstract void buildAllModules(@Nullable ProjectTaskNotification var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public abstract void build(Module @NotNull [] var1, @Nullable ProjectTaskNotification var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public abstract void rebuild(Module @NotNull [] var1, @Nullable ProjectTaskNotification var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public abstract void compile(VirtualFile @NotNull [] var1, @Nullable ProjectTaskNotification var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public abstract void build(ProjectModelBuildableElement @NotNull [] var1, @Nullable ProjectTaskNotification var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/task/ProjectTaskManager", "<init>"));
    }

    public static interface Result {
        @NotNull
        public ProjectTaskContext getContext();

        public boolean isAborted();

        public boolean hasErrors();

        @ApiStatus.Experimental
        public boolean anyTaskMatches(@NotNull BiPredicate<? super ProjectTask, ? super ProjectTaskState> var1);
    }
}

