/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsServiceListener;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsFactory;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface CodeStyleSettingsService {
    public static CodeStyleSettingsService getInstance() {
        return (CodeStyleSettingsService)ApplicationManager.getApplication().getService(CodeStyleSettingsService.class);
    }

    @Nullable
    public static LanguageCodeStyleProvider getLanguageCodeStyleProvider(Language language) {
        for (LanguageCodeStyleProvider languageCodeStyleProvider : CodeStyleSettingsService.getInstance().getLanguageCodeStyleProviders()) {
            if (!((Object)((Object)languageCodeStyleProvider.getLanguage())).equals((Object)language)) continue;
            return languageCodeStyleProvider;
        }
        return null;
    }

    public void addListener(@NotNull CodeStyleSettingsServiceListener var1, @Nullable Disposable var2);

    @NotNull
    public List<? extends FileTypeIndentOptionsFactory> getFileTypeIndentOptionsFactories();

    @NotNull
    public List<? extends CustomCodeStyleSettingsFactory> getCustomCodeStyleSettingsFactories();

    @NotNull
    public List<? extends LanguageCodeStyleProvider> getLanguageCodeStyleProviders();

    @Deprecated
    @NotNull
    public Set<? extends CustomCodeStyleSettingsFactory> getSettingsPagesProviders();
}

