/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CodeStyleSettingsServiceListener;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsFactory;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CodeStyleSettingsManager
implements PersistentStateComponentWithModificationTracker<Element> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsManager.class);
    @Deprecated
    @Nullable
    public volatile CodeStyleSettings PER_PROJECT_SETTINGS;
    public volatile boolean USE_PER_PROJECT_SETTINGS;
    public volatile String PREFERRED_PROJECT_CODE_STYLE;
    private volatile CodeStyleSettings myTemporarySettings;
    private final List<CodeStyleSettingsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final WeakList<CodeStyleSettings> ourReferencedSettings = new WeakList();

    @NotNull
    public CodeStyleSettings createSettings() {
        CodeStyleSettings newSettings = new CodeStyleSettings(true, false);
        CodeStyleSettingsManager.registerSettings(newSettings);
        CodeStyleSettings codeStyleSettings = newSettings;
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    static void registerSettings(@NotNull CodeStyleSettings newSettings) {
        if (newSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        ourReferencedSettings.add((Object)newSettings);
    }

    @TestOnly
    public final CodeStyleSettings createTemporarySettings() {
        this.myTemporarySettings = new CodeStyleSettings(true, false);
        return this.myTemporarySettings;
    }

    public final CodeStyleSettings cloneSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        CodeStyleSettings clonedSettings = new CodeStyleSettings(true, false);
        clonedSettings.copyFrom(settings);
        CodeStyleSettingsManager.registerSettings(clonedSettings);
        return clonedSettings;
    }

    @TestOnly
    public static CodeStyleSettings createTestSettings(@Nullable CodeStyleSettings baseSettings) {
        CodeStyleSettings testSettings = new CodeStyleSettings(true, false);
        if (baseSettings != null) {
            testSettings.copyFrom(baseSettings);
        }
        return testSettings;
    }

    private Collection<CodeStyleSettings> getAllSettings() {
        ArrayList<CodeStyleSettings> allSettings = new ArrayList<CodeStyleSettings>(this.enumSettings());
        allSettings.addAll(ourReferencedSettings.toStrongList());
        return allSettings;
    }

    @Override
    public long getStateModificationCount() {
        return this.enumSettings().stream().mapToLong(settings -> settings.getModificationTracker().getModificationCount()).sum();
    }

    public static CodeStyleSettingsManager getInstance(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return CodeStyleSettingsManager.getInstance();
        }
        return (CodeStyleSettingsManager)project.getService(ProjectCodeStyleSettingsManager.class);
    }

    public static CodeStyleSettingsManager getInstance() {
        return (CodeStyleSettingsManager)ApplicationManager.getApplication().getService(AppCodeStyleSettingsManager.class);
    }

    protected void registerExtensionPointListeners(@Nullable Disposable disposable) {
        FileIndentOptionsProvider.EP_NAME.addChangeListener(this::notifyCodeStyleSettingsChanged, disposable);
        CodeStyleSettingsService.getInstance().addListener(new CodeStyleSettingsServiceListener(){

            @Override
            public void fileTypeIndentOptionsFactoryAdded(@NotNull FileTypeIndentOptionsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(0);
                }
                CodeStyleSettingsManager.this.registerFileTypeIndentOptions(CodeStyleSettingsManager.this.getAllSettings(), factory.getFileType(), factory.createIndentOptions());
            }

            @Override
            public void fileTypeIndentOptionsFactoryRemoved(@NotNull FileTypeIndentOptionsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleSettingsManager.this.unregisterFileTypeIndentOptions(CodeStyleSettingsManager.this.getAllSettings(), factory.getFileType());
            }

            @Override
            public void languageCodeStyleProviderAdded(@NotNull LanguageCodeStyleProvider provider) {
                if (provider == null) {
                    1.$$$reportNull$$$0(2);
                }
                CodeStyleSettingsManager.this.registerLanguageSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
            }

            @Override
            public void languageCodeStyleProviderRemoved(@NotNull LanguageCodeStyleProvider provider) {
                if (provider == null) {
                    1.$$$reportNull$$$0(3);
                }
                CodeStyleSettingsManager.this.unregisterLanguageSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
            }

            @Override
            public void customCodeStyleSettingsFactoryAdded(@NotNull CustomCodeStyleSettingsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(4);
                }
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), factory);
            }

            @Override
            public void customCodeStyleSettingsFactoryRemoved(@NotNull CustomCodeStyleSettingsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(5);
                }
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), factory);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypeIndentOptionsFactoryAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypeIndentOptionsFactoryRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "languageCodeStyleProviderAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "languageCodeStyleProviderRemoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "customCodeStyleSettingsFactoryAdded";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "customCodeStyleSettingsFactoryRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    protected Collection<CodeStyleSettings> enumSettings() {
        return Collections.emptyList();
    }

    @ApiStatus.Internal
    public final void registerFileTypeIndentOptions(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull FileType fileType, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        allSettings.forEach(settings -> settings.registerAdditionalIndentOptions(fileType, indentOptions));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterFileTypeIndentOptions(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull FileType fileType) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        allSettings.forEach(settings -> settings.unregisterAdditionalIndentOptions(fileType));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerLanguageSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(9);
        }
        allSettings.forEach(settings -> settings.registerCommonSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterLanguageSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(10);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(11);
        }
        allSettings.forEach(settings -> settings.removeCommonSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerCustomSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull CustomCodeStyleSettingsFactory provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(13);
        }
        allSettings.forEach(settings -> settings.registerCustomSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterCustomSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull CustomCodeStyleSettingsFactory provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(15);
        }
        allSettings.forEach(settings -> settings.removeCustomSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @Deprecated
    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(16);
        }
        return codeStyleSettings;
    }

    protected void checkState() {
    }

    @Deprecated
    @NotNull
    public CodeStyleSettings getCurrentSettings() {
        CodeStyleSettings temporarySettings = this.myTemporarySettings;
        if (temporarySettings != null) {
            CodeStyleSettings codeStyleSettings = temporarySettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(17);
            }
            return codeStyleSettings;
        }
        this.checkState();
        CodeStyleSettings projectSettings = this.getMainProjectCodeStyle();
        if (this.USE_PER_PROJECT_SETTINGS && projectSettings != null) {
            CodeStyleSettings codeStyleSettings = projectSettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(18);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSchemes.getInstance().findPreferredScheme(this.PREFERRED_PROJECT_CODE_STYLE).getCodeStyleSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(19);
        }
        return codeStyleSettings;
    }

    @Override
    public Element getState() {
        Element result = new Element("state");
        try {
            DefaultJDOMExternalizer.write((Object)this, (Element)result, (Predicate)new DifferenceFilter<CodeStyleSettingsManager>(this, new CodeStyleSettingsManager()){

                public boolean test(@NotNull Field field) {
                    if (field == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return !CodeStyleSettingsManager.this.isIgnoredOnSave(field.getName()) && super.test(field);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/codeStyle/CodeStyleSettingsManager$2", "test"));
                }
            });
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        if (fieldName == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(20);
        }
        return false;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(21);
        }
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
    }

    @Nullable
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.PER_PROJECT_SETTINGS;
    }

    @TestOnly
    public void setTemporarySettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(22);
        }
        this.myTemporarySettings = settings;
    }

    @TestOnly
    public void dropTemporarySettings() {
        this.myTemporarySettings = null;
    }

    @Nullable
    @TestOnly
    public CodeStyleSettings getTemporarySettings() {
        return this.myTemporarySettings;
    }

    public void addListener(@NotNull CodeStyleSettingsListener listener2) {
        if (listener2 == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(23);
        }
        this.myListeners.add(listener2);
    }

    private void removeListener(@NotNull CodeStyleSettingsListener listener2) {
        if (listener2 == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(24);
        }
        this.myListeners.remove(listener2);
    }

    public static void removeListener(@Nullable Project project, @NotNull CodeStyleSettingsListener listener2) {
        CodeStyleSettingsManager projectInstance;
        if (listener2 == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(25);
        }
        if (project == null || project.isDefault()) {
            CodeStyleSettingsManager.getInstance().removeListener(listener2);
        } else if (!project.isDisposed() && (projectInstance = (CodeStyleSettingsManager)ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class)) != null) {
            projectInstance.removeListener(listener2);
        }
    }

    public void fireCodeStyleSettingsChanged(@Nullable PsiFile file) {
        for (CodeStyleSettingsListener listener2 : this.myListeners) {
            listener2.codeStyleSettingsChanged(new CodeStyleSettingsChangeEvent(file));
        }
    }

    public final void notifyCodeStyleSettingsChanged() {
        this.updateSettingsTracker();
        this.fireCodeStyleSettingsChanged(null);
    }

    @ApiStatus.Internal
    public void updateSettingsTracker() {
        CodeStyleSettings settings = this.getCurrentSettings();
        settings.getModificationTracker().incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 2: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSettings";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cloneSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeIndentOptions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeIndentOptions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLanguageSettings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomSettings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unregisterCustomSettings";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOnSave";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

