/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.CodeStyleBundle;
import com.intellij.configurationStore.Property;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.ExcludedFiles;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsFactory;
import com.intellij.psi.codeStyle.ImportsLayoutSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.codeStyle.SoftMargins;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.PresentableEnum;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CodeStyleSettings
extends LegacyCodeStyleSettings
implements Cloneable,
JDOMExternalizable,
ImportsLayoutSettings {
    public static final int CURR_VERSION = 173;
    private static final Logger LOG = Logger.getInstance(CodeStyleSettings.class);
    public static final String VERSION_ATTR = "version";
    @NonNls
    private static final String REPEAT_ANNOTATIONS = "REPEAT_ANNOTATIONS";
    @NonNls
    static final String ADDITIONAL_INDENT_OPTIONS = "ADDITIONAL_INDENT_OPTIONS";
    @NonNls
    private static final String FILETYPE = "fileType";
    private CommonCodeStyleSettingsManager myCommonSettingsManager = new CommonCodeStyleSettingsManager(this);
    private final CustomCodeStyleSettingsManager myCustomCodeStyleSettingsManager = new CustomCodeStyleSettingsManager(this);
    private final SoftMargins mySoftMargins = new SoftMargins();
    private final ExcludedFiles myExcludedFiles = new ExcludedFiles();
    private int myVersion = 173;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    public boolean AUTODETECT_INDENTS = true;
    public final CommonCodeStyleSettings.IndentOptions OTHER_INDENT_OPTIONS = new CommonCodeStyleSettings.IndentOptions();
    private final Map<FileType, CommonCodeStyleSettings.IndentOptions> myAdditionalIndentOptions = new LinkedHashMap<FileType, CommonCodeStyleSettings.IndentOptions>();
    private static final String ourSystemLineSeparator = System.lineSeparator();
    public String LINE_SEPARATOR;
    @Deprecated
    public String FIELD_NAME_PREFIX = "";
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public String STATIC_FIELD_NAME_PREFIX = "";
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public String PARAMETER_NAME_PREFIX = "";
    @Deprecated
    public String LOCAL_VARIABLE_NAME_PREFIX = "";
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public String FIELD_NAME_SUFFIX = "";
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public String STATIC_FIELD_NAME_SUFFIX = "";
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public String PARAMETER_NAME_SUFFIX = "";
    @Deprecated
    public String LOCAL_VARIABLE_NAME_SUFFIX = "";
    @Deprecated
    public boolean PREFER_LONGER_NAMES = true;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean GENERATE_FINAL_LOCALS;
    @Deprecated
    public boolean GENERATE_FINAL_PARAMETERS;
    @Deprecated
    public String VISIBILITY = "public";
    @Deprecated
    public boolean PARENTHESES_AROUND_METHOD_ARGUMENTS = true;
    @Deprecated
    public boolean USE_EXTERNAL_ANNOTATIONS;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean INSERT_OVERRIDE_ANNOTATION = true;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean REPEAT_SYNCHRONIZED = true;
    private final List<String> myRepeatAnnotations = new ArrayList<String>();
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
    @Deprecated
    public boolean USE_FQ_CLASS_NAMES;
    @Deprecated
    public boolean USE_FQ_CLASS_NAMES_IN_JAVADOC = true;
    @Deprecated
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    @Deprecated
    public boolean INSERT_INNER_CLASS_IMPORTS;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public final PackageEntryTable PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public final PackageEntryTable IMPORT_LAYOUT_TABLE = new PackageEntryTable();
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int STATIC_FIELDS_ORDER_WEIGHT = 1;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int FIELDS_ORDER_WEIGHT = 2;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int CONSTRUCTORS_ORDER_WEIGHT = 3;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int STATIC_METHODS_ORDER_WEIGHT = 4;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int METHODS_ORDER_WEIGHT = 5;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int STATIC_INNER_CLASSES_ORDER_WEIGHT = 6;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public int INNER_CLASSES_ORDER_WEIGHT = 7;
    @Property(externalName="max_line_length")
    @ApiStatus.Internal
    public int RIGHT_MARGIN = 120;
    @Property(externalName="wrap_on_typing")
    public boolean WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    @Deprecated
    public boolean ENABLE_JAVADOC_FORMATTING = true;
    @Deprecated
    public boolean JD_LEADING_ASTERISKS_ARE_ENABLED = true;
    @Deprecated
    public boolean JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST;
    public boolean FORMATTER_TAGS_ENABLED;
    public String FORMATTER_ON_TAG = "@formatter:on";
    public String FORMATTER_OFF_TAG = "@formatter:off";
    public volatile boolean FORMATTER_TAGS_ACCEPT_REGEXP;
    private volatile Pattern myFormatterOffPattern;
    private volatile Pattern myFormatterOnPattern;
    private CodeStyleSettings myParentSettings;
    private boolean myLoadedAdditionalIndentOptions;

    @Deprecated
    public CodeStyleSettings() {
        this(true, true);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public CodeStyleSettings(boolean loadExtensions) {
        this(loadExtensions, true);
    }

    protected CodeStyleSettings(boolean loadExtensions, boolean needsRegistration) {
        this.initImportsByDefault();
        if (loadExtensions) {
            this.myCustomCodeStyleSettingsManager.initCustomSettings();
        }
        if (needsRegistration) {
            CodeStyleSettingsManager.registerSettings(this);
        }
    }

    private void initImportsByDefault() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "java.awt", false));
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "javax.swing", false));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "javax", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "java", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
    }

    public void setParentSettings(CodeStyleSettings parent) {
        this.myParentSettings = parent;
    }

    public CodeStyleSettings getParentSettings() {
        return this.myParentSettings;
    }

    @NotNull
    public <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> aClass) {
        if (aClass == null) {
            CodeStyleSettings.$$$reportNull$$$0(0);
        }
        T t = this.myCustomCodeStyleSettingsManager.getCustomSettings(aClass);
        if (t == null) {
            CodeStyleSettings.$$$reportNull$$$0(1);
        }
        return t;
    }

    @Nullable
    public <T extends CustomCodeStyleSettings> T getCustomSettingsIfCreated(@NotNull Class<T> aClass) {
        if (aClass == null) {
            CodeStyleSettings.$$$reportNull$$$0(2);
        }
        return this.myCustomCodeStyleSettingsManager.getCustomSettingsIfCreated(aClass);
    }

    @Deprecated
    public CodeStyleSettings clone() {
        CodeStyleSettings clone = new CodeStyleSettings(true, true);
        clone.copyFrom(this);
        return clone;
    }

    private void copyCustomSettingsFrom(@NotNull CodeStyleSettings from) {
        if (from == null) {
            CodeStyleSettings.$$$reportNull$$$0(3);
        }
        this.myCustomCodeStyleSettingsManager.copyFrom(from);
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(from.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        this.IMPORT_LAYOUT_TABLE.copyFrom(from.IMPORT_LAYOUT_TABLE);
        this.OTHER_INDENT_OPTIONS.copyFrom(from.OTHER_INDENT_OPTIONS);
        this.myAdditionalIndentOptions.clear();
        for (Map.Entry<FileType, CommonCodeStyleSettings.IndentOptions> optionEntry : from.myAdditionalIndentOptions.entrySet()) {
            CommonCodeStyleSettings.IndentOptions options = optionEntry.getValue();
            this.myAdditionalIndentOptions.put(optionEntry.getKey(), (CommonCodeStyleSettings.IndentOptions)options.clone());
        }
        this.myCommonSettingsManager = from.myCommonSettingsManager.clone(this);
        this.myRepeatAnnotations.clear();
        this.myRepeatAnnotations.addAll(from.myRepeatAnnotations);
    }

    public void copyFrom(CodeStyleSettings from) {
        CommonCodeStyleSettings.copyPublicFields(from, this);
        CommonCodeStyleSettings.copyPublicFields(from.OTHER_INDENT_OPTIONS, this.OTHER_INDENT_OPTIONS);
        this.mySoftMargins.setValues(from.getDefaultSoftMargins());
        this.myExcludedFiles.setDescriptors(from.getExcludedFiles().getDescriptors());
        this.copyCustomSettingsFrom(from);
    }

    public String getLineSeparator() {
        return this.LINE_SEPARATOR != null ? this.LINE_SEPARATOR : ourSystemLineSeparator;
    }

    @Deprecated
    public List<String> getRepeatAnnotations() {
        return this.myRepeatAnnotations;
    }

    @Deprecated
    public void setRepeatAnnotations(List<String> repeatAnnotations) {
        this.myRepeatAnnotations.clear();
        this.myRepeatAnnotations.addAll(repeatAnnotations);
    }

    @Override
    @Deprecated
    public boolean isLayoutStaticImportsSeparately() {
        return this.LAYOUT_STATIC_IMPORTS_SEPARATELY;
    }

    @Override
    @Deprecated
    public void setLayoutStaticImportsSeparately(boolean value) {
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = value;
    }

    @Override
    @Deprecated
    public int getNamesCountToUseImportOnDemand() {
        return this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    @Override
    @Deprecated
    public void setNamesCountToUseImportOnDemand(int value) {
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    @Override
    @Deprecated
    public int getClassCountToUseImportOnDemand() {
        return this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    @Override
    @Deprecated
    public void setClassCountToUseImportOnDemand(int value) {
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    @Override
    @Deprecated
    public boolean isInsertInnerClassImports() {
        return this.INSERT_INNER_CLASS_IMPORTS;
    }

    @Override
    @Deprecated
    public void setInsertInnerClassImports(boolean value) {
        this.INSERT_INNER_CLASS_IMPORTS = value;
    }

    @Override
    @Deprecated
    public boolean isUseSingleClassImports() {
        return this.USE_SINGLE_CLASS_IMPORTS;
    }

    @Override
    @Deprecated
    public void setUseSingleClassImports(boolean value) {
        this.USE_SINGLE_CLASS_IMPORTS = value;
    }

    @Override
    @Deprecated
    public boolean isUseFqClassNames() {
        return this.USE_FQ_CLASS_NAMES;
    }

    @Override
    @Deprecated
    public void setUseFqClassNames(boolean value) {
        this.USE_FQ_CLASS_NAMES = value;
    }

    @Override
    @Deprecated
    public PackageEntryTable getImportLayoutTable() {
        return this.IMPORT_LAYOUT_TABLE;
    }

    @Override
    @Deprecated
    public PackageEntryTable getPackagesToUseImportOnDemand() {
        return this.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
    }

    @Nullable
    public Pattern getFormatterOffPattern() {
        if (this.myFormatterOffPattern == null && this.FORMATTER_TAGS_ENABLED && this.FORMATTER_TAGS_ACCEPT_REGEXP) {
            this.myFormatterOffPattern = this.getPatternOrDisableRegexp(this.FORMATTER_OFF_TAG);
        }
        return this.myFormatterOffPattern;
    }

    public void setFormatterOffPattern(@Nullable Pattern formatterOffPattern) {
        this.myFormatterOffPattern = formatterOffPattern;
    }

    @Nullable
    public Pattern getFormatterOnPattern() {
        if (this.myFormatterOffPattern == null && this.FORMATTER_TAGS_ENABLED && this.FORMATTER_TAGS_ACCEPT_REGEXP) {
            this.myFormatterOnPattern = this.getPatternOrDisableRegexp(this.FORMATTER_ON_TAG);
        }
        return this.myFormatterOnPattern;
    }

    public void setFormatterOnPattern(@Nullable Pattern formatterOnPattern) {
        this.myFormatterOnPattern = formatterOnPattern;
    }

    @Nullable
    private Pattern getPatternOrDisableRegexp(@NotNull String markerText) {
        if (markerText == null) {
            CodeStyleSettings.$$$reportNull$$$0(4);
        }
        try {
            return Pattern.compile(markerText);
        }
        catch (PatternSyntaxException pse) {
            LOG.error("Loaded regexp pattern is invalid: '" + markerText + "', error message: " + pse.getMessage());
            this.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            return null;
        }
    }

    private static void setVersion(@NotNull Element element, int version) {
        if (element == null) {
            CodeStyleSettings.$$$reportNull$$$0(5);
        }
        element.setAttribute(VERSION_ATTR, Integer.toString(version));
    }

    private static int getVersion(@NotNull Element element) {
        String versionStr;
        if (element == null) {
            CodeStyleSettings.$$$reportNull$$$0(6);
        }
        if ((versionStr = element.getAttributeValue(VERSION_ATTR)) == null) {
            return 0;
        }
        try {
            return Integer.parseInt(versionStr);
        }
        catch (NumberFormatException nfe) {
            return 173;
        }
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.myVersion = CodeStyleSettings.getVersion(element);
        this.myCustomCodeStyleSettingsManager.notifySettingsBeforeLoading();
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if (this.LAYOUT_STATIC_IMPORTS_SEPARATELY) {
            boolean found = false;
            for (PackageEntry entry : this.IMPORT_LAYOUT_TABLE.getEntries()) {
                if (entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) continue;
                found = true;
                break;
            }
            if (!found) {
                Iterator last;
                Iterator iterator = last = this.IMPORT_LAYOUT_TABLE.getEntryCount() == 0 ? null : this.IMPORT_LAYOUT_TABLE.getEntryAt(this.IMPORT_LAYOUT_TABLE.getEntryCount() - 1);
                if (last != PackageEntry.BLANK_LINE_ENTRY) {
                    this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                }
                this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
            }
        }
        this.myRepeatAnnotations.clear();
        Element annotations = element.getChild(REPEAT_ANNOTATIONS);
        if (annotations != null) {
            for (Element anno : annotations.getChildren("ANNO")) {
                this.myRepeatAnnotations.add(anno.getAttributeValue("name"));
            }
        }
        this.myCustomCodeStyleSettingsManager.readExternal(element);
        List list = element.getChildren(ADDITIONAL_INDENT_OPTIONS);
        for (Element additionalIndentElement : list) {
            String fileTypeId = additionalIndentElement.getAttributeValue(FILETYPE);
            if (StringUtil.isEmpty((String)fileTypeId)) continue;
            FileType target = FileTypeRegistry.getInstance().getFileTypeByExtension(fileTypeId);
            if (UnknownFileType.INSTANCE == target || target instanceof PlainTextLikeFileType || target.getDefaultExtension().isEmpty()) {
                target = new TempFileType(fileTypeId);
            }
            CommonCodeStyleSettings.IndentOptions options = CodeStyleSettings.getDefaultIndentOptions(target);
            options.readExternal(additionalIndentElement);
            this.registerAdditionalIndentOptions(target, options);
        }
        this.myCommonSettingsManager.readExternal(element);
        this.mySoftMargins.deserializeFrom(element);
        this.myExcludedFiles.deserializeFrom(element);
        this.migrateLegacySettings();
        this.myCustomCodeStyleSettingsManager.notifySettingsLoaded();
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        CodeStyleSettings.setVersion(element, this.myVersion);
        CodeStyleSettings defaultSettings = new CodeStyleSettings(true, false);
        DefaultJDOMExternalizer.write((Object)this, (Element)element, (Predicate)new DifferenceFilter((Object)this, (Object)defaultSettings));
        this.mySoftMargins.serializeInto(element);
        this.myExcludedFiles.serializeInto(element);
        this.myCustomCodeStyleSettingsManager.writeExternal(element, defaultSettings);
        if (!this.myAdditionalIndentOptions.isEmpty()) {
            FileType[] fileTypes = this.myAdditionalIndentOptions.keySet().toArray(FileType.EMPTY_ARRAY);
            Arrays.sort(fileTypes, Comparator.comparing(FileType::getDefaultExtension));
            for (FileType fileType : fileTypes) {
                Element additionalIndentOptions = new Element(ADDITIONAL_INDENT_OPTIONS);
                this.myAdditionalIndentOptions.get(fileType).serialize(additionalIndentOptions, CodeStyleSettings.getDefaultIndentOptions(fileType));
                additionalIndentOptions.setAttribute(FILETYPE, fileType.getDefaultExtension());
                if (additionalIndentOptions.getChildren().isEmpty()) continue;
                element.addContent(additionalIndentOptions);
            }
        }
        this.myCommonSettingsManager.writeExternal(element);
        if (!this.myRepeatAnnotations.isEmpty()) {
            Element annos = new Element(REPEAT_ANNOTATIONS);
            for (String annotation : this.myRepeatAnnotations) {
                annos.addContent(new Element("ANNO").setAttribute("name", annotation));
            }
            element.addContent(annos);
        }
    }

    private static CommonCodeStyleSettings.IndentOptions getDefaultIndentOptions(FileType fileType) {
        for (FileTypeIndentOptionsFactory fileTypeIndentOptionsFactory : CodeStyleSettingsService.getInstance().getFileTypeIndentOptionsFactories()) {
            if (!fileTypeIndentOptionsFactory.getFileType().equals(fileType)) continue;
            return CodeStyleSettings.getFileTypeIndentOptions(fileTypeIndentOptionsFactory);
        }
        return new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.OTHER_INDENT_OPTIONS;
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(7);
        }
        return indentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@Nullable FileType fileType) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getLanguageIndentOptions(fileType);
        if (indentOptions != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
            if (indentOptions2 == null) {
                CodeStyleSettings.$$$reportNull$$$0(8);
            }
            return indentOptions2;
        }
        if (fileType == null) {
            CommonCodeStyleSettings.IndentOptions indentOptions3 = this.OTHER_INDENT_OPTIONS;
            if (indentOptions3 == null) {
                CodeStyleSettings.$$$reportNull$$$0(9);
            }
            return indentOptions3;
        }
        if (!this.myLoadedAdditionalIndentOptions) {
            this.loadAdditionalIndentOptions();
        }
        if ((indentOptions = this.myAdditionalIndentOptions.get(fileType)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions4 = indentOptions;
            if (indentOptions4 == null) {
                CodeStyleSettings.$$$reportNull$$$0(10);
            }
            return indentOptions4;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions5 = this.OTHER_INDENT_OPTIONS;
        if (indentOptions5 == null) {
            CodeStyleSettings.$$$reportNull$$$0(11);
        }
        return indentOptions5;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByDocument(@Nullable Project project, @NotNull Document document) {
        PsiFile file;
        if (document == null) {
            CodeStyleSettings.$$$reportNull$$$0(12);
        }
        PsiFile psiFile = file = project != null ? PsiDocumentManager.getInstance(project).getPsiFile(document) : null;
        if (file != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptionsByFile(file);
            if (indentOptions == null) {
                CodeStyleSettings.$$$reportNull$$$0(13);
            }
            return indentOptions;
        }
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        FileType fileType = vFile != null ? vFile.getFileType() : null;
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(fileType);
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(14);
        }
        return indentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptionsByFile(file, null);
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(15);
        }
        return indentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file, @Nullable TextRange formatRange) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptionsByFile(file, formatRange, false, null);
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(16);
        }
        return indentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file, @Nullable TextRange formatRange, boolean ignoreDocOptions, @Nullable Processor<? super FileIndentOptionsProvider> providerProcessor) {
        if (file != null && file.isValid()) {
            CommonCodeStyleSettings.IndentOptions options;
            Object options2;
            boolean isFullReformat = CodeStyleSettings.isFileFullyCoveredByRange(file, formatRange);
            if (!ignoreDocOptions && !isFullReformat && (options2 = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument(file)) != null) {
                FileIndentOptionsProvider provider = ((CommonCodeStyleSettings.IndentOptions)options2).getFileIndentOptionsProvider();
                if (providerProcessor != null && provider != null) {
                    providerProcessor.process((Object)provider);
                }
                Object object = options2;
                if (object == null) {
                    CodeStyleSettings.$$$reportNull$$$0(17);
                }
                return object;
            }
            for (FileIndentOptionsProvider provider : FileIndentOptionsProvider.EP_NAME.getExtensionList()) {
                CommonCodeStyleSettings.IndentOptions indentOptions;
                if (isFullReformat && !provider.useOnFullReformat() || (indentOptions = provider.getIndentOptions(this, file)) == null) continue;
                if (providerProcessor != null) {
                    providerProcessor.process((Object)provider);
                }
                indentOptions.setFileIndentOptionsProvider(provider);
                CodeStyleSettings.logIndentOptions(file, provider, indentOptions);
                CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
                if (indentOptions2 == null) {
                    CodeStyleSettings.$$$reportNull$$$0(18);
                }
                return indentOptions2;
            }
            Language language = LanguageUtil.getLanguageForPsi(file.getProject(), file.getVirtualFile(), file.getFileType());
            if (language != null && (options = this.getIndentOptions(language)) != null) {
                CommonCodeStyleSettings.IndentOptions indentOptions = options;
                if (indentOptions == null) {
                    CodeStyleSettings.$$$reportNull$$$0(19);
                }
                return indentOptions;
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(file.getFileType());
            if (indentOptions == null) {
                CodeStyleSettings.$$$reportNull$$$0(20);
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.OTHER_INDENT_OPTIONS;
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(21);
        }
        return indentOptions;
    }

    private static boolean isFileFullyCoveredByRange(@NotNull PsiFile file, @Nullable TextRange formatRange) {
        if (file == null) {
            CodeStyleSettings.$$$reportNull$$$0(22);
        }
        return formatRange != null && formatRange.equals((Object)file.getTextRange());
    }

    private static void logIndentOptions(@NotNull PsiFile file, @NotNull FileIndentOptionsProvider provider, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (file == null) {
            CodeStyleSettings.$$$reportNull$$$0(23);
        }
        if (provider == null) {
            CodeStyleSettings.$$$reportNull$$$0(24);
        }
        if (options == null) {
            CodeStyleSettings.$$$reportNull$$$0(25);
        }
        LOG.debug("Indent options returned by " + provider.getClass().getName() + " for " + file.getName() + ": indent size=" + options.INDENT_SIZE + ", use tabs=" + options.USE_TAB_CHARACTER + ", tab size=" + options.TAB_SIZE);
    }

    @Nullable
    private CommonCodeStyleSettings.IndentOptions getLanguageIndentOptions(@Nullable FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language lang = ((LanguageFileType)fileType).getLanguage();
        return this.getIndentOptions(lang);
    }

    public CommonCodeStyleSettings.IndentOptions getLanguageIndentOptions(@NotNull Language language) {
        CommonCodeStyleSettings.IndentOptions langOptions;
        if (language == null) {
            CodeStyleSettings.$$$reportNull$$$0(26);
        }
        return (langOptions = this.getIndentOptions(language)) != null ? langOptions : this.OTHER_INDENT_OPTIONS;
    }

    @Nullable
    private CommonCodeStyleSettings.IndentOptions getIndentOptions(Language lang) {
        CommonCodeStyleSettings settings = this.myCommonSettingsManager.getCommonSettings(lang);
        return settings != null ? settings.getIndentOptions() : null;
    }

    public boolean isSmartTabs(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).SMART_TABS;
    }

    public int getIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).INDENT_SIZE;
    }

    public int getContinuationIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).CONTINUATION_INDENT_SIZE;
    }

    public int getTabSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).TAB_SIZE;
    }

    public boolean useTabCharacter(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).USE_TAB_CHARACTER;
    }

    void registerAdditionalIndentOptions(FileType fileType, CommonCodeStyleSettings.IndentOptions options) {
        FileType registered = this.findRegisteredFileType(fileType);
        if (registered == null || registered instanceof TempFileType) {
            this.myAdditionalIndentOptions.put(fileType, options);
        }
    }

    @Nullable
    private FileType findRegisteredFileType(@NotNull FileType provided) {
        if (provided == null) {
            CodeStyleSettings.$$$reportNull$$$0(27);
        }
        for (FileType existing : this.myAdditionalIndentOptions.keySet()) {
            if (!Comparing.strEqual((String)existing.getDefaultExtension(), (String)provided.getDefaultExtension())) continue;
            return existing;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAdditionalIndentOptions() {
        Map<FileType, CommonCodeStyleSettings.IndentOptions> map = this.myAdditionalIndentOptions;
        synchronized (map) {
            this.myLoadedAdditionalIndentOptions = true;
            for (FileTypeIndentOptionsFactory fileTypeIndentOptionsFactory : CodeStyleSettingsService.getInstance().getFileTypeIndentOptionsFactories()) {
                if (this.myAdditionalIndentOptions.containsKey(fileTypeIndentOptionsFactory.getFileType())) continue;
                this.registerAdditionalIndentOptions(fileTypeIndentOptionsFactory.getFileType(), CodeStyleSettings.getFileTypeIndentOptions(fileTypeIndentOptionsFactory));
            }
        }
    }

    void unregisterAdditionalIndentOptions(@NotNull FileType fileType) {
        FileType registered;
        if (fileType == null) {
            CodeStyleSettings.$$$reportNull$$$0(28);
        }
        if ((registered = this.findRegisteredFileType(fileType)) != null && !(registered instanceof TempFileType)) {
            TempFileType tempFileType = new TempFileType(fileType.getDefaultExtension());
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myAdditionalIndentOptions.get(fileType);
            this.myAdditionalIndentOptions.remove(fileType);
            this.myAdditionalIndentOptions.put(tempFileType, indentOptions);
        }
    }

    private static CommonCodeStyleSettings.IndentOptions getFileTypeIndentOptions(@NotNull FileTypeIndentOptionsFactory factory) {
        if (factory == null) {
            CodeStyleSettings.$$$reportNull$$$0(29);
        }
        try {
            return factory.createIndentOptions();
        }
        catch (AbstractMethodError error) {
            LOG.error((Throwable)PluginException.createByClass("Plugin uses obsolete API", null, factory.getClass()));
            return new CommonCodeStyleSettings.IndentOptions();
        }
    }

    @TestOnly
    public void clearCodeStyleSettings() {
        CodeStyleSettings cleanSettings = new CodeStyleSettings(true, false);
        this.copyFrom(cleanSettings);
        this.myAdditionalIndentOptions.clear();
        this.myLoadedAdditionalIndentOptions = false;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@Nullable Language lang) {
        CommonCodeStyleSettings settings = this.myCommonSettingsManager.getCommonSettings(lang);
        if (settings == null) {
            settings = this.myCommonSettingsManager.getDefaults();
        }
        CommonCodeStyleSettings commonCodeStyleSettings = settings;
        if (commonCodeStyleSettings == null) {
            CodeStyleSettings.$$$reportNull$$$0(30);
        }
        return commonCodeStyleSettings;
    }

    public CommonCodeStyleSettings getCommonSettings(String langName) {
        return this.myCommonSettingsManager.getCommonSettings(langName);
    }

    public int getRightMargin(@Nullable Language language) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && langSettings.RIGHT_MARGIN >= 0) {
            return langSettings.RIGHT_MARGIN;
        }
        return this.getDefaultRightMargin();
    }

    public void setRightMargin(@Nullable Language language, int rightMargin) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null) {
            langSettings.RIGHT_MARGIN = rightMargin;
            return;
        }
        this.setDefaultRightMargin(rightMargin);
    }

    public int getDefaultRightMargin() {
        return this.RIGHT_MARGIN;
    }

    public void setDefaultRightMargin(int rightMargin) {
        this.RIGHT_MARGIN = rightMargin;
    }

    public boolean isWrapOnTyping(@Nullable Language language) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && langSettings.WRAP_ON_TYPING != CommonCodeStyleSettings.WrapOnTyping.DEFAULT.intValue) {
            return langSettings.WRAP_ON_TYPING == CommonCodeStyleSettings.WrapOnTyping.WRAP.intValue;
        }
        return this.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CodeStyleSettings)) {
            return false;
        }
        if (!ReflectionUtil.comparePublicNonFinalFields((Object)this, (Object)obj)) {
            return false;
        }
        if (!this.mySoftMargins.equals(((CodeStyleSettings)obj).mySoftMargins)) {
            return false;
        }
        if (!this.myExcludedFiles.equals(((CodeStyleSettings)obj).getExcludedFiles())) {
            return false;
        }
        if (!this.OTHER_INDENT_OPTIONS.equals(((CodeStyleSettings)obj).OTHER_INDENT_OPTIONS)) {
            return false;
        }
        if (!this.myCommonSettingsManager.equals(((CodeStyleSettings)obj).myCommonSettingsManager)) {
            return false;
        }
        for (CustomCodeStyleSettings customSettings : this.myCustomCodeStyleSettingsManager.getAllSettings()) {
            if (customSettings.equals(((CodeStyleSettings)obj).getCustomSettings(customSettings.getClass()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static CodeStyleSettings getDefaults() {
        CodeStyleSettings codeStyleSettings = DefaultsHolder.myDefaults;
        if (codeStyleSettings == null) {
            CodeStyleSettings.$$$reportNull$$$0(31);
        }
        return codeStyleSettings;
    }

    private void migrateLegacySettings() {
        if (this.myVersion < 173) {
            for (CustomCodeStyleSettings settings : this.myCustomCodeStyleSettingsManager.getAllSettings()) {
                settings.importLegacySettings(this);
            }
            this.myVersion = 173;
        }
    }

    public void resetDeprecatedFields() {
        CodeStyleSettings defaults = CodeStyleSettings.getDefaults();
        ReflectionUtil.copyFields((Field[])this.getClass().getFields(), (Object)defaults, (Object)this, (DifferenceFilter)new DifferenceFilter<CodeStyleSettings>(this, defaults){

            public boolean test(@NotNull Field field) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                return field.getAnnotation(Deprecated.class) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/codeStyle/CodeStyleSettings$1", "test"));
            }
        });
        this.IMPORT_LAYOUT_TABLE.copyFrom(defaults.IMPORT_LAYOUT_TABLE);
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(defaults.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        this.myRepeatAnnotations.clear();
    }

    public int getVersion() {
        return this.myVersion;
    }

    @NotNull
    public List<Integer> getSoftMargins(@Nullable Language language) {
        CommonCodeStyleSettings languageSettings;
        if (language != null && (languageSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && !languageSettings.getSoftMargins().isEmpty()) {
            List<Integer> list = languageSettings.getSoftMargins();
            if (list == null) {
                CodeStyleSettings.$$$reportNull$$$0(32);
            }
            return list;
        }
        List<Integer> list = this.getDefaultSoftMargins();
        if (list == null) {
            CodeStyleSettings.$$$reportNull$$$0(33);
        }
        return list;
    }

    public void setSoftMargins(@NotNull Language language, List<Integer> softMargins) {
        if (language == null) {
            CodeStyleSettings.$$$reportNull$$$0(34);
        }
        CommonCodeStyleSettings languageSettings = this.myCommonSettingsManager.getCommonSettings(language);
        assert (languageSettings != null) : "Settings for language " + language.getDisplayName() + " do not exist";
        languageSettings.setSoftMargins(softMargins);
    }

    @NotNull
    public List<Integer> getDefaultSoftMargins() {
        List<Integer> list = this.mySoftMargins.getValues();
        if (list == null) {
            CodeStyleSettings.$$$reportNull$$$0(35);
        }
        return list;
    }

    public void setDefaultSoftMargins(List<Integer> softMargins) {
        this.mySoftMargins.setValues(softMargins);
    }

    @NotNull
    public ExcludedFiles getExcludedFiles() {
        ExcludedFiles excludedFiles = this.myExcludedFiles;
        if (excludedFiles == null) {
            CodeStyleSettings.$$$reportNull$$$0(36);
        }
        return excludedFiles;
    }

    public SimpleModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    @ApiStatus.Internal
    public void removeCommonSettings(@NotNull LanguageCodeStyleProvider provider) {
        if (provider == null) {
            CodeStyleSettings.$$$reportNull$$$0(37);
        }
        this.myCommonSettingsManager.removeLanguageSettings(provider);
    }

    @ApiStatus.Internal
    public void registerCommonSettings(@NotNull LanguageCodeStyleProvider provider) {
        if (provider == null) {
            CodeStyleSettings.$$$reportNull$$$0(38);
        }
        this.myCommonSettingsManager.addLanguageSettings(provider);
    }

    @ApiStatus.Internal
    public void removeCustomSettings(@NotNull CustomCodeStyleSettingsFactory factory) {
        if (factory == null) {
            CodeStyleSettings.$$$reportNull$$$0(39);
        }
        this.myCustomCodeStyleSettingsManager.unregisterCustomSettings(factory);
    }

    @ApiStatus.Internal
    public void registerCustomSettings(@NotNull CustomCodeStyleSettingsFactory factory) {
        if (factory == null) {
            CodeStyleSettings.$$$reportNull$$$0(40);
        }
        this.myCustomCodeStyleSettingsManager.registerCustomSettings(this, factory);
    }

    CustomCodeStyleSettingsManager getCustomCodeStyleSettingsManager() {
        return this.myCustomCodeStyleSettingsManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerText";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provided";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILETYPE;
                break;
            }
            case 29: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByDocument";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaults";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftMargins";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSoftMargins";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettingsIfCreated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyCustomSettingsFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPatternOrDisableRegexp";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsByDocument";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isFileFullyCoveredByRange";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "logIndentOptions";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageIndentOptions";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredFileType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAdditionalIndentOptions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeIndentOptions";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setSoftMargins";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonSettings";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "registerCommonSettings";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomSettings";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum QuoteStyle implements PresentableEnum
    {
        Single("'", CodeStyleBundle.messagePointer("quote.style.single", new Object[0])),
        Double("\"", CodeStyleBundle.messagePointer("quote.style.double", new Object[0])),
        None("", CodeStyleBundle.messagePointer("quote.style.none", new Object[0]));

        public final String quote;
        private final Supplier<@NlsContexts.Label String> myDescription;

        private QuoteStyle(String quote, Supplier<String> description) {
            if (quote == null) {
                QuoteStyle.$$$reportNull$$$0(0);
            }
            if (description == null) {
                QuoteStyle.$$$reportNull$$$0(1);
            }
            this.quote = quote;
            this.myDescription = description;
        }

        @Override
        @NlsContexts.Label
        public String getPresentableText() {
            return this.myDescription.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "quote";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/codeStyle/CodeStyleSettings$QuoteStyle";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum HtmlTagNewLineStyle implements PresentableEnum
    {
        Never("Never", CodeStyleBundle.messagePointer("html.tag.new.line.never", new Object[0])),
        WhenMultiline("When multiline", CodeStyleBundle.messagePointer("html.tag.new.line.when.multiline", new Object[0]));

        private final String myValue;
        private final Supplier<@NlsContexts.Label String> myDescription;

        private HtmlTagNewLineStyle(String value, Supplier<String> description) {
            if (value == null) {
                HtmlTagNewLineStyle.$$$reportNull$$$0(0);
            }
            if (description == null) {
                HtmlTagNewLineStyle.$$$reportNull$$$0(1);
            }
            this.myValue = value;
            this.myDescription = description;
        }

        public String toString() {
            return this.myValue;
        }

        @Override
        @NlsContexts.Label
        public String getPresentableText() {
            return this.myDescription.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/codeStyle/CodeStyleSettings$HtmlTagNewLineStyle";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum WrapStyle implements PresentableEnum
    {
        DO_NOT_WRAP(0, CodeStyleBundle.messagePointer("wrapping.do.not.wrap", new Object[0])),
        WRAP_AS_NEEDED(1, CodeStyleBundle.messagePointer("wrapping.wrap.if.long", new Object[0])),
        WRAP_ON_EVERY_ITEM(4, CodeStyleBundle.messagePointer("wrapping.chop.down.if.long", new Object[0])),
        WRAP_ALWAYS(2, CodeStyleBundle.messagePointer("wrapping.wrap.always", new Object[0]));

        private final int myId;
        private final Supplier<@NlsContexts.Label String> myDescription;

        private WrapStyle(int id, Supplier<String> description) {
            if (description == null) {
                WrapStyle.$$$reportNull$$$0(0);
            }
            this.myId = id;
            this.myDescription = description;
        }

        public int getId() {
            return this.myId;
        }

        @Override
        @NlsContexts.Label
        public String getPresentableText() {
            return this.myDescription.get();
        }

        @NotNull
        public static WrapStyle forWrapping(int wrappingStyleID) {
            for (WrapStyle style : WrapStyle.values()) {
                if (style.myId != wrappingStyleID) continue;
                WrapStyle wrapStyle = style;
                if (wrapStyle == null) {
                    WrapStyle.$$$reportNull$$$0(1);
                }
                return wrapStyle;
            }
            LOG.error("Invalid wrapping option index: " + wrappingStyleID);
            WrapStyle wrapStyle = DO_NOT_WRAP;
            if (wrapStyle == null) {
                WrapStyle.$$$reportNull$$$0(2);
            }
            return wrapStyle;
        }

        public static int getId(@Nullable WrapStyle wrapStyle) {
            return Optional.ofNullable(wrapStyle).orElse((WrapStyle)WrapStyle.DO_NOT_WRAP).myId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettings$WrapStyle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettings$WrapStyle";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forWrapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class TempFileType
    implements FileType {
        private final String myExtension;

        private TempFileType(@NotNull String extension) {
            if (extension == null) {
                TempFileType.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
        }

        @Override
        @NotNull
        public String getName() {
            return "TempFileType";
        }

        @Override
        @NotNull
        @NonNls
        public String getDescription() {
            return "TempFileType";
        }

        @Override
        @NotNull
        public String getDefaultExtension() {
            String string = this.myExtension;
            if (string == null) {
                TempFileType.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DefaultsHolder {
        private static final CodeStyleSettings myDefaults = new CodeStyleSettings(true, false);

        private DefaultsHolder() {
        }
    }
}

