/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowEP
implements PluginAware {
    private static final Logger LOG = Logger.getInstance(ToolWindowEP.class);
    public static final ExtensionPointName<ToolWindowEP> EP_NAME = new ExtensionPointName("com.intellij.toolWindow");
    private PluginDescriptor pluginDescriptor;
    @RequiredElement
    @Attribute
    public String id;
    @Attribute
    public String anchor;
    @Attribute
    public String largeStripeAnchor;
    @Attribute
    @Deprecated
    public boolean side;
    @Attribute(value="icon")
    public String icon;
    @Attribute(value="doNotActivateOnStart")
    public boolean isDoNotActivateOnStart;
    @RequiredElement
    @Attribute
    public String factoryClass;
    @Attribute
    @Deprecated
    public String conditionClass;
    @Attribute
    public boolean secondary;
    @Attribute
    public boolean canCloseContents;
    private Class<? extends ToolWindowFactory> myFactoryClass;
    private volatile ToolWindowFactory myFactory;

    @Transient
    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            ToolWindowEP.$$$reportNull$$$0(0);
        }
        return pluginDescriptor;
    }

    public final void setPluginDescriptor(@NotNull PluginDescriptor value) {
        if (value == null) {
            ToolWindowEP.$$$reportNull$$$0(1);
        }
        this.pluginDescriptor = value;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public ToolWindowFactory getToolWindowFactory() {
        return this.getToolWindowFactory(this.getPluginDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ToolWindowFactory getToolWindowFactory(@NotNull PluginDescriptor pluginDescriptor) {
        ToolWindowFactory factory;
        if (pluginDescriptor == null) {
            ToolWindowEP.$$$reportNull$$$0(2);
        }
        if ((factory = this.myFactory) != null) {
            return factory;
        }
        if (this.factoryClass == null) {
            LOG.error((Throwable)new PluginException("No toolwindow factory specified for " + this.id, pluginDescriptor.getPluginId()));
            return null;
        }
        ToolWindowEP toolWindowEP = this;
        synchronized (toolWindowEP) {
            factory = this.myFactory;
            if (factory != null) {
                return factory;
            }
            try {
                this.myFactory = factory = (ToolWindowFactory)ApplicationManager.getApplication().instantiateClass(this.factoryClass, pluginDescriptor);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return factory;
    }

    @Nullable
    public Class<? extends ToolWindowFactory> getFactoryClass(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            ToolWindowEP.$$$reportNull$$$0(3);
        }
        if (this.myFactoryClass == null) {
            if (this.factoryClass == null) {
                LOG.error((Throwable)new PluginException("No toolwindow factory specified for " + this.id, pluginDescriptor.getPluginId()));
                return null;
            }
            ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
            try {
                this.myFactoryClass = Class.forName(this.factoryClass, true, classLoader == null ? ToolWindowEP.class.getClassLoader() : classLoader);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return this.myFactoryClass;
    }

    @Deprecated
    @Nullable
    public Condition<Project> getCondition() {
        return this.getCondition(this.getPluginDescriptor());
    }

    @Nullable
    public Condition<Project> getCondition(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            ToolWindowEP.$$$reportNull$$$0(4);
        }
        if (this.conditionClass == null) {
            return null;
        }
        try {
            return (Condition)ApplicationManager.getApplication().instantiateClass(this.conditionClass, pluginDescriptor);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.id;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/ToolWindowEP";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/ToolWindowEP";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowFactory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

