/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.model.ModelBranchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DistinctRootsCollection;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance(VfsUtilCore.class);
    @NonNls
    private static final String MAILTO = "mailto";
    @NonNls
    public static final String LOCALHOST_URI_PATH_PREFIX = "localhost/";
    public static final char VFS_SEPARATOR_CHAR = '/';
    public static final String VFS_SEPARATOR = "/";
    private static final String PROTOCOL_DELIMITER = ":";

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(0);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(1);
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile2 = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file, @Nullable Set<? extends VirtualFile> roots) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(2);
        }
        if (roots == null || roots.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file; parent != null; parent = parent.getParent()) {
            if (!roots.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnder(@NotNull @NonNls String url, @Nullable @NonNls Collection<String> rootUrls) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(3);
        }
        if (rootUrls == null || rootUrls.isEmpty()) {
            return false;
        }
        for (String excludesUrl : rootUrls) {
            if (!VfsUtilCore.isEqualOrAncestor(excludesUrl, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualOrAncestor(@NotNull @NonNls String ancestorUrl, @NotNull @NonNls String fileUrl) {
        if (ancestorUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(4);
        }
        if (fileUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(5);
        }
        if (ancestorUrl.equals(fileUrl)) {
            return true;
        }
        if (StringUtil.endsWithChar((CharSequence)ancestorUrl, (char)'/')) {
            return fileUrl.startsWith(ancestorUrl);
        }
        return StringUtil.startsWithConcatenation((String)fileUrl, (String[])new String[]{ancestorUrl, VFS_SEPARATOR});
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(6);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(7);
        }
        return FileUtil.isAncestor((File)ancestor, (File)file, (boolean)strict);
    }

    @Nullable
    @NlsSafe
    public static String getRelativeLocation(@Nullable VirtualFile file, @NotNull VirtualFile root) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(8);
        }
        if (file == null) {
            return null;
        }
        String path2 = VfsUtilCore.getRelativePath(file, root);
        return path2 != null ? path2 : file.getPresentableUrl();
    }

    @Nullable
    @NlsSafe
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(9);
        }
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(10);
        }
        return VfsUtilCore.getRelativePath(file, ancestor, '/');
    }

    @Nullable
    @NlsSafe
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(11);
        }
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(12);
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            ModelBranchUtil.checkSameBranch(file, ancestor);
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getNameSequence().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            CharSequence name = parent.getNameSequence();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return new String(chars);
    }

    @Nullable
    public static String findRelativePath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        if (src == null) {
            VfsUtilCore.$$$reportNull$$$0(13);
        }
        if (dst == null) {
            VfsUtilCore.$$$reportNull$$$0(14);
        }
        if (!src.getFileSystem().equals(dst.getFileSystem())) {
            ModelBranchUtil.checkSameBranch(src, dst);
            return null;
        }
        if (!src.isDirectory() && (src = src.getParent()) == null) {
            return null;
        }
        VirtualFile commonAncestor = VfsUtilCore.getCommonAncestor(src, dst);
        if (commonAncestor == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
            while (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                buffer.append("..").append(separatorChar);
                src = src.getParent();
            }
        }
        buffer.append(VfsUtilCore.getRelativePath(dst, commonAncestor, separatorChar));
        if (StringUtil.endsWithChar((CharSequence)buffer, (char)separatorChar)) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path2 = entryVFile.getPath();
        int separatorIndex = path2.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path2.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(15);
        }
        if (toDir == null) {
            VfsUtilCore.$$$reportNull$$$0(16);
        }
        return VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(17);
        }
        if (toDir == null) {
            VfsUtilCore.$$$reportNull$$$0(18);
        }
        if (newName == null) {
            VfsUtilCore.$$$reportNull$$$0(19);
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray(), -1L, -1L, requestor);
        newChild.setBOM(file.getBOM());
        VirtualFile virtualFile2 = newChild;
        if (virtualFile2 == null) {
            VfsUtilCore.$$$reportNull$$$0(20);
        }
        return virtualFile2;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(byte @NotNull [] buf, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(21);
        }
        if (buf == null) {
            VfsUtilCore.$$$reportNull$$$0(22);
        }
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)stream, file);
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file) throws IOException {
        if (stream == null) {
            VfsUtilCore.$$$reportNull$$$0(23);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(24);
        }
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
        if (inputStream == null) {
            VfsUtilCore.$$$reportNull$$$0(25);
        }
        return inputStream;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file) throws IOException {
        byte[] bom;
        if (stream == null) {
            VfsUtilCore.$$$reportNull$$$0(26);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(27);
        }
        if ((bom = file.getBOM()) != null) {
            stream.write(bom);
        }
        OutputStream outputStream = stream;
        if (outputStream == null) {
            VfsUtilCore.$$$reportNull$$$0(28);
        }
        return outputStream;
    }

    public static boolean iterateChildrenRecursively(@NotNull VirtualFile root, @Nullable VirtualFileFilter filter, @NotNull ContentIterator iterator) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(29);
        }
        if (iterator == null) {
            VfsUtilCore.$$$reportNull$$$0(30);
        }
        return VfsUtilCore.iterateChildrenRecursively(root, filter, iterator, new VirtualFileVisitor.Option[0]);
    }

    public static boolean iterateChildrenRecursively(final @NotNull VirtualFile root, final @Nullable VirtualFileFilter filter, final @NotNull ContentIterator iterator, VirtualFileVisitor.Option ... options) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(31);
        }
        if (iterator == null) {
            VfsUtilCore.$$$reportNull$$$0(32);
        }
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(options){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (filter != null && !filter.accept(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (!iterator.processFile(file)) {
                    VirtualFileVisitor.Result result = 1.skipTo(root);
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result;
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(3);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return !Comparing.equal((Object)result.skipToParent, (Object)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        VirtualFileVisitor.Result result;
        block22: {
            Object object;
            boolean allowVisitFile;
            boolean pushed;
            block25: {
                int n;
                block26: {
                    block24: {
                        VirtualFile[] children2;
                        block23: {
                            if (file == null) {
                                VfsUtilCore.$$$reportNull$$$0(33);
                            }
                            if (visitor == null) {
                                VfsUtilCore.$$$reportNull$$$0(34);
                            }
                            ProgressManager.checkCanceled();
                            pushed = false;
                            allowVisitFile = visitor.allowVisitFile(file);
                            if (allowVisitFile) {
                                VirtualFileVisitor.Result result2 = visitor.visitFileEx(file);
                                if (result2.skipChildren) {
                                    VirtualFileVisitor.Result result3 = result2;
                                    VirtualFileVisitor.Result result4 = result3;
                                    if (result4 == null) {
                                        VfsUtilCore.$$$reportNull$$$0(35);
                                    }
                                    return result4;
                                }
                            }
                            Iterable<VirtualFile> childrenIterable = null;
                            children2 = null;
                            try {
                                if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                                    children2 = file.getChildren();
                                }
                            }
                            catch (InvalidVirtualFileAccessException e) {
                                LOG.info("Ignoring: " + e.getMessage());
                                VirtualFileVisitor.Result result5 = VirtualFileVisitor.CONTINUE;
                                visitor.restoreValue(pushed);
                                VirtualFileVisitor.Result result6 = result5;
                                if (result6 == null) {
                                    VfsUtilCore.$$$reportNull$$$0(36);
                                }
                                return result6;
                            }
                            if (childrenIterable == null) break block23;
                            visitor.saveValue();
                            pushed = true;
                            object = childrenIterable.iterator();
                            break block24;
                        }
                        if (children2 == null || children2.length == 0) break block25;
                        visitor.saveValue();
                        pushed = true;
                        object = children2;
                        n = ((Object)object).length;
                        break block26;
                    }
                    while (object.hasNext()) {
                        VirtualFile child = (VirtualFile)object.next();
                        VirtualFileVisitor.Result result7 = VfsUtilCore.visitChildrenRecursively(child, visitor);
                        if (result7.skipToParent == null || Comparing.equal((Object)result7.skipToParent, (Object)child)) continue;
                        VirtualFileVisitor.Result result8 = result7;
                        VirtualFileVisitor.Result result9 = result8;
                        if (result9 == null) {
                            VfsUtilCore.$$$reportNull$$$0(37);
                        }
                        return result9;
                    }
                    break block25;
                }
                for (int i = 0; i < n; ++i) {
                    Object child = object[i];
                    VirtualFileVisitor.Result result10 = VfsUtilCore.visitChildrenRecursively((VirtualFile)child, visitor);
                    if (result10.skipToParent == null || Comparing.equal((Object)result10.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result11 = result10;
                    result = result11;
                    break block22;
                }
            }
            if (allowVisitFile) {
                visitor.afterChildrenVisited(file);
            }
            object = VirtualFileVisitor.CONTINUE;
            Object object2 = object;
            if (object2 == null) {
                VfsUtilCore.$$$reportNull$$$0(39);
            }
            return object2;
            finally {
                visitor.restoreValue(pushed);
            }
        }
        if (result == null) {
            VfsUtilCore.$$$reportNull$$$0(38);
        }
        return result;
    }

    public static <E extends Exception> VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor, @NotNull Class<E> eClass) throws E {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(40);
        }
        if (visitor == null) {
            VfsUtilCore.$$$reportNull$$$0(41);
        }
        if (eClass == null) {
            VfsUtilCore.$$$reportNull$$$0(42);
        }
        try {
            return VfsUtilCore.visitChildrenRecursively(file, visitor);
        }
        catch (VirtualFileVisitor.VisitorException e) {
            Throwable cause = e.getCause();
            if (eClass.isInstance(cause)) {
                throw (Exception)eClass.cast(cause);
            }
            throw e;
        }
    }

    public static boolean isBrokenLink(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(43);
        }
        return file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null;
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        VirtualFile target;
        if (link == null) {
            VfsUtilCore.$$$reportNull$$$0(44);
        }
        return (target = link.getCanonicalFile()) == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(45);
        }
        return VfsUtilCore.loadText(file, (int)file.getLength());
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file, int length) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(46);
        }
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        String string = new String(FileUtilRt.loadText((Reader)reader, (int)length));
        String string2 = string;
        if (string2 == null) {
            VfsUtilCore.$$$reportNull$$$0(47);
        }
        return string2;
        finally {
            reader.close();
        }
    }

    public static byte @NotNull [] loadBytes(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(48);
        }
        byte[] byArray = FileUtilRt.isTooLarge((long)file.getLength()) ? FileUtil.loadFirstAndClose((InputStream)file.getInputStream(), (int)FileUtilRt.LARGE_FILE_PREVIEW_SIZE) : file.contentsToByteArray();
        if (byArray == null) {
            VfsUtilCore.$$$reportNull$$$0(49);
        }
        return byArray;
    }

    public static VirtualFile @NotNull [] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(50);
        }
        VirtualFile[] virtualFileArray = files.isEmpty() ? VirtualFile.EMPTY_ARRAY : files.toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            VfsUtilCore.$$$reportNull$$$0(51);
        }
        return virtualFileArray;
    }

    @NotNull
    @NlsSafe
    public static String urlToPath(@Nullable String url) {
        String string = URLUtil.urlToPath((String)url);
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(53);
        }
        return new File(PathUtil.toPresentableUrl(file.getUrl()));
    }

    @NotNull
    public static String pathToUrl(@NotNull String path2) {
        if (path2 == null) {
            VfsUtilCore.$$$reportNull$$$0(54);
        }
        String string = VirtualFileManager.constructUrl("file", FileUtil.toSystemIndependentName((String)path2));
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public static String fileToUrl(@NotNull File file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(56);
        }
        return VfsUtilCore.pathToUrl(file.getPath());
    }

    public static List<File> virtualToIoFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(57);
        }
        return ContainerUtil.map2List(files, file -> VfsUtilCore.virtualToIoFile(file));
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(58);
        }
        return VfsUtilCore.toIdeaUrl(url, true);
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url, boolean removeLocalhostPrefix) {
        int index;
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(59);
        }
        if ((index = url.indexOf(":/")) < 0 || index + 2 >= url.length()) {
            String string = url;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(60);
            }
            return string;
        }
        if (url.charAt(index + 2) != '/') {
            String prefix = url.substring(0, index);
            String suffix = url.substring(index + 2);
            if (SystemInfoRt.isWindows) {
                String string = prefix + "://" + suffix;
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(61);
                }
                return string;
            }
            if (removeLocalhostPrefix && prefix.equals("file") && suffix.startsWith(LOCALHOST_URI_PATH_PREFIX)) {
                String string = prefix + ":///" + suffix.substring(LOCALHOST_URI_PATH_PREFIX.length());
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(62);
                }
                return string;
            }
            String string = prefix + ":///" + suffix;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(63);
            }
            return string;
        }
        if (SystemInfoRt.isWindows && index + 3 < url.length() && url.charAt(index + 3) == '/' && url.regionMatches(0, "file://", 0, "file://".length())) {
            char c;
            for (int i = index + 4; i < url.length() && (c = url.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                String string = "file://" + url.substring(index + 4);
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(64);
                }
                return string;
            }
            String string = url;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(65);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(66);
        }
        return string;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(67);
        }
        return VfsUtilCore.toIdeaUrl(url, false);
    }

    @NotNull
    public static String convertFromUrl(@NotNull URL url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(68);
        }
        String protocol = url.getProtocol();
        String path2 = url.getPath();
        if (protocol.equals("jar")) {
            if (StringUtil.startsWithConcatenation((String)path2, (String[])new String[]{"file", PROTOCOL_DELIMITER})) {
                try {
                    URL subURL = new URL(path2);
                    path2 = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(CoreBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(CoreBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfoRt.isWindows) {
            while (!path2.isEmpty() && path2.charAt(0) == '/') {
                path2 = path2.substring(1);
            }
        }
        path2 = URLUtil.unescapePercentSequences((String)path2);
        String string = protocol + "://" + path2;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(69);
        }
        return string;
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(70);
        }
        if (vfsUrl.startsWith("jar://")) {
            try {
                return new URL("jar:file:///" + vfsUrl.substring("jar://".length()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split2 = vfsUrl.split("://");
        if (split2.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split2[0];
        String path2 = split2[1];
        try {
            if (protocol.equals("file")) {
                return new URL("file", "", path2);
            }
            return URLUtil.internProtocol((URL)new URL(vfsUrl));
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occurred:" + e.getMessage());
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public static String fixIDEAUrl(@NotNull String ideaUrl) {
        String ideaProtocolMarker;
        int idx;
        if (ideaUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(71);
        }
        if ((idx = ideaUrl.indexOf(ideaProtocolMarker = "://")) >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals("jar")) {
                s = "jar:file";
            }
            String urlWithoutProtocol = ideaUrl.substring(idx + ideaProtocolMarker.length());
            ideaUrl = s + PROTOCOL_DELIMITER + (urlWithoutProtocol.startsWith(VFS_SEPARATOR) ? "" : VFS_SEPARATOR) + urlWithoutProtocol;
        }
        String string = ideaUrl;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(72);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@NotNull @NonNls String uri, @Nullable VirtualFile base) {
        if (uri == null) {
            VfsUtilCore.$$$reportNull$$$0(73);
        }
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
        } else {
            uri = StringUtil.trimStart((String)uri, (String)"file:");
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (!SystemInfoRt.isWindows && StringUtil.startsWithChar((CharSequence)uri, (char)'/') || SystemInfoRt.isWindows && uri.length() >= 2 && Character.isLetter(uri.charAt(0)) && uri.charAt(1) == ':') {
            file = StandardFileSystems.local().findFileByPath(uri);
        }
        if (file == null && uri.contains("!/") && (file = StandardFileSystems.jar().findFileByPath(uri)) == null && base == null) {
            file = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file == null) {
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            if (!base.isDirectory()) {
                base = base.getParent();
            }
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            file = VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + VFS_SEPARATOR + uri);
        }
        return file;
    }

    public static boolean processFilesRecursively(final @NotNull VirtualFile root, final @NotNull Processor<? super VirtualFile> processor) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(74);
        }
        if (processor == null) {
            VfsUtilCore.$$$reportNull$$$0(75);
        }
        final Ref result = new Ref((Object)true);
        VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!processor.process((Object)file)) {
                    result.set((Object)Boolean.FALSE);
                    VirtualFileVisitor.Result result2 = 2.skipTo(root);
                    if (result2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return (Boolean)result.get();
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile parent1;
        if (file1 == null) {
            VfsUtilCore.$$$reportNull$$$0(76);
        }
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(77);
        }
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        if (file1.equals(file2)) {
            return file1;
        }
        int depth1 = VfsUtilCore.depth(file1);
        int depth2 = VfsUtilCore.depth(file2);
        VirtualFile parent2 = file2;
        for (parent1 = file1; depth1 > depth2 && parent1 != null; parent1 = parent1.getParent(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    private static int depth(VirtualFile file) {
        int depth = 0;
        while (file != null) {
            ++depth;
            file = file.getParent();
        }
        return depth;
    }

    static VirtualFile @NotNull [] getPathComponents(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(78);
        }
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)componentsList.get(size - i - 1);
        }
        if (components == null) {
            VfsUtilCore.$$$reportNull$$$0(79);
        }
        return components;
    }

    public static boolean hasInvalidFiles(@NotNull Iterable<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(80);
        }
        for (VirtualFile virtualFile2 : files) {
            if (virtualFile2.isValid()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile findContainingDirectory(@NotNull VirtualFile file, @NotNull CharSequence name) {
        VirtualFile parent;
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(81);
        }
        if (name == null) {
            VfsUtilCore.$$$reportNull$$$0(82);
        }
        VirtualFile virtualFile2 = parent = file.isDirectory() ? file : file.getParent();
        while (parent != null) {
            if (StringUtilRt.equal((CharSequence)parent.getNameSequence(), (CharSequence)name, (boolean)SystemInfoRt.isFileSystemCaseSensitive)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @ApiStatus.Experimental
    public static boolean pathEqualsTo(@NotNull VirtualFile file, @NotNull @SystemIndependent String path2) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(83);
        }
        if (path2 == null) {
            VfsUtilCore.$$$reportNull$$$0(84);
        }
        path2 = FileUtil.toCanonicalPath((String)path2);
        int li = path2.length();
        while (file != null && li != -1) {
            int i = path2.lastIndexOf(47, li - 1);
            CharSequence fileName = file.getNameSequence();
            if (i == 6 && StringUtil.startsWith((CharSequence)fileName, (CharSequence)"//wsl$")) {
                i = -1;
            }
            if (StringUtil.endsWithChar((CharSequence)fileName, (char)'/')) {
                fileName = fileName.subSequence(0, fileName.length() - 1);
            }
            if (!StringUtilRt.equal((CharSequence)fileName, (CharSequence)path2.substring(i + 1, li), (boolean)file.isCaseSensitive())) {
                return false;
            }
            file = file.getParent();
            li = i;
        }
        return li == -1 && file == null;
    }

    @NotNull
    private static List<VirtualFile> getHierarchy(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(85);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        while (file != null) {
            result.add(file);
            file = file.getParent();
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            VfsUtilCore.$$$reportNull$$$0(86);
        }
        return arrayList;
    }

    @ApiStatus.Experimental
    public static boolean isAncestorOrSelf(@NotNull @SystemIndependent String ancestorPath, @NotNull VirtualFile file) {
        if (ancestorPath == null) {
            VfsUtilCore.$$$reportNull$$$0(87);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(88);
        }
        ancestorPath = FileUtil.toCanonicalPath((String)ancestorPath);
        List<VirtualFile> hierarchy = VfsUtilCore.getHierarchy(file);
        if (ancestorPath.isEmpty()) {
            return true;
        }
        int i = 0;
        boolean result = false;
        for (int j = hierarchy.size() - 1; j >= 0; --j) {
            boolean matches;
            VirtualFile part = hierarchy.get(j);
            String name = part.getName();
            boolean bl = matches = part.isCaseSensitive() ? StringUtil.startsWith((CharSequence)ancestorPath, (int)i, (CharSequence)name) : StringUtilRt.startsWithIgnoreCase((String)ancestorPath, (int)i, (String)name);
            if (!matches) break;
            i += name.length();
            if (!name.endsWith(VFS_SEPARATOR)) {
                if (i != ancestorPath.length() && ancestorPath.charAt(i) != '/') break;
                ++i;
            }
            if (i < ancestorPath.length()) continue;
            result = true;
            break;
        }
        return result;
    }

    @NotNull
    public static VirtualFile getRootFile(@NotNull VirtualFile file) {
        VirtualFile parent;
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(89);
        }
        while ((parent = file.getParent()) != null) {
            file = parent;
        }
        VirtualFile virtualFile2 = file;
        if (virtualFile2 == null) {
            VfsUtilCore.$$$reportNull$$$0(90);
        }
        return virtualFile2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 86: 
            case 90: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 86: 
            case 90: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 33: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 53: 
            case 56: 
            case 78: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 58: 
            case 59: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 8: 
            case 29: 
            case 31: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eClass";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 50: 
            case 57: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 54: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfsUrl";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaUrl";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "inputStreamSkippingBOM";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "outputStreamAddingBOM";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "visitChildrenRecursively";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "toVirtualFileArray";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToPath";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToUrl";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "toIdeaUrl";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromUrl";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "fixIDEAUrl";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathComponents";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchy";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEqualOrAncestor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeLocation";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRelativePath";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 86: 
            case 90: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "byteStreamSkippingBOM";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamSkippingBOM";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "outputStreamAddingBOM";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "iterateChildrenRecursively";
                break;
            }
            case 33: 
            case 34: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitChildrenRecursively";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenLink";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidLink";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toVirtualFileArray";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "virtualToIoFile";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "pathToUrl";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fileToUrl";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "virtualToIoFiles";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "toIdeaUrl";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "fixURLforIDEA";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "convertFromUrl";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "convertToURL";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "fixIDEAUrl";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeFile";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestor";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getPathComponents";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidFiles";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "findContainingDirectory";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "pathEqualsTo";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorOrSelf";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getRootFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 79: 
            case 86: 
            case 90: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class DistinctVFilesRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public DistinctVFilesRootsCollection(@NotNull Collection<? extends VirtualFile> virtualFiles) {
            if (virtualFiles == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(0);
            }
            super(virtualFiles);
        }

        public DistinctVFilesRootsCollection(VirtualFile @NotNull [] collection) {
            if (collection == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(1);
            }
            super((Object[])collection);
        }

        protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile2) {
            if (ancestor == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(2);
            }
            if (virtualFile2 == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(3);
            }
            return VfsUtilCore.isAncestor(ancestor, virtualFile2, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore$DistinctVFilesRootsCollection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAncestor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

