/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CompactVirtualFileSet
extends AbstractSet<VirtualFile> {
    private final Set<VirtualFile> weirdFiles;
    private IntSet idSet;
    private BitSet fileIds;
    private boolean frozen;

    public CompactVirtualFileSet() {
        this.weirdFiles = new HashSet<VirtualFile>();
    }

    public CompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(0);
        }
        this.weirdFiles = new HashSet<VirtualFile>();
        this.addAll(files);
    }

    @Override
    public boolean contains(Object file) {
        if (file instanceof VirtualFileWithId) {
            BitSet ids = this.fileIds;
            int id = ((VirtualFileWithId)file).getId();
            if (ids != null) {
                return ids.get(id);
            }
            IntSet idSet = this.idSet;
            if (idSet != null) {
                return idSet.contains(id);
            }
        }
        return this.weirdFiles.contains(file);
    }

    @Override
    public boolean add(@NotNull VirtualFile file) {
        boolean added;
        if (file == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(1);
        }
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
        if (file instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)((Object)file)).getId();
            BitSet ids = this.fileIds;
            IntSet idSet = this.idSet;
            if (ids != null) {
                added = !ids.get(id);
                ids.set(id);
            } else if (idSet != null) {
                added = idSet.add(id);
                if (idSet.size() > 1000) {
                    this.fileIds = new BitSet();
                    IntIterator iterator = idSet.iterator();
                    while (iterator.hasNext()) {
                        this.fileIds.set(iterator.nextInt());
                    }
                    this.idSet = null;
                }
            } else {
                added = this.weirdFiles.add(file);
                if (this.weirdFiles.size() > 10) {
                    this.idSet = idSet = new IntOpenHashSet(this.weirdFiles.size());
                    Iterator<VirtualFile> iterator = this.weirdFiles.iterator();
                    while (iterator.hasNext()) {
                        VirtualFile wf = iterator.next();
                        if (!(wf instanceof VirtualFileWithId)) continue;
                        idSet.add(((VirtualFileWithId)((Object)wf)).getId());
                        iterator.remove();
                    }
                }
            }
        } else {
            added = this.weirdFiles.add(file);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean process(@NotNull Processor<? super VirtualFile> processor) {
        IntSet idSet;
        if (processor == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(2);
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        BitSet ids = this.fileIds;
        if (ids != null) {
            int id = ids.nextSetBit(0);
            while (id < ids.size() && id >= 0) {
                VirtualFile file = virtualFileManager.findFileById(id);
                if (file != null && !processor.process((Object)file)) {
                    return false;
                }
                id = ids.nextSetBit(id + 1);
            }
        }
        if ((idSet = this.idSet) != null) {
            IntIterator iterator = idSet.iterator();
            while (iterator.hasNext()) {
                VirtualFile file = virtualFileManager.findFileById(iterator.nextInt());
                if (file == null || processor.process((Object)file)) continue;
                return false;
            }
        }
        for (VirtualFile t : this.weirdFiles) {
            if (processor.process((Object)t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        BitSet ids = this.fileIds;
        IntSet idSet = this.idSet;
        return (ids == null ? 0 : ids.cardinality()) + (idSet == null ? 0 : idSet.size()) + this.weirdFiles.size();
    }

    @Override
    @NotNull
    public Iterator<VirtualFile> iterator() {
        Iterator totalIterator;
        BitSet ids = this.fileIds;
        IntSet idSet = this.idSet;
        final VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Iterator idsIterator = ids == null ? Collections.emptyIterator() : ids.stream().mapToObj(id -> {
            ProgressManager.checkCanceled();
            return virtualFileManager.findFileById(id);
        }).iterator();
        if (idSet == null) {
            totalIterator = ContainerUtil.concatIterators((Iterator[])new Iterator[]{idsIterator, this.weirdFiles.iterator()});
        } else {
            final IntIterator iterator = idSet.iterator();
            Iterator<VirtualFile> idSetIterator = new Iterator<VirtualFile>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public VirtualFile next() {
                    int id = iterator.nextInt();
                    ProgressManager.checkCanceled();
                    return virtualFileManager.findFileById(id);
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
            totalIterator = ContainerUtil.concatIterators((Iterator[])new Iterator[]{idsIterator, idSetIterator, this.weirdFiles.iterator()});
        }
        return new Iterator<VirtualFile>(){
            VirtualFile next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (totalIterator.hasNext()) {
                    VirtualFile t = (VirtualFile)totalIterator.next();
                    if (t == null) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public VirtualFile next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                VirtualFile result = this.next;
                this.findNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

