/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.roots.ImmutableSyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyntheticLibrary {
    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            SyntheticLibrary.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            SyntheticLibrary.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return null;
    }

    public boolean isShowInExternalLibrariesNode() {
        return this instanceof ItemPresentation;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull List<? extends VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(2);
        }
        return SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<? extends VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(3);
        }
        return SyntheticLibrary.newImmutableLibrary(SyntheticLibrary.asList(sourceRoots), Collections.emptySet(), null);
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull List<? extends VirtualFile> sourceRoots, @NotNull Set<? extends VirtualFile> excludedRoots, @Nullable Condition<? super VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(4);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(5);
        }
        return SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptyList(), excludedRoots, excludeCondition);
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull Set<? extends VirtualFile> excludedRoots, @Nullable Condition<? super VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(6);
        }
        if (binaryRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(7);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(8);
        }
        return new ImmutableSyntheticLibrary(sourceRoots, binaryRoots, excludedRoots, excludeCondition);
    }

    @NotNull
    public final Collection<VirtualFile> getAllRoots() {
        return this.getRoots(true, true);
    }

    @NotNull
    private Collection<VirtualFile> getRoots(boolean includeSources, boolean includeBinaries) {
        if (includeSources && includeBinaries) {
            Collection<VirtualFile> sourceRoots = this.getSourceRoots();
            Collection<VirtualFile> binaryRoots = this.getBinaryRoots();
            if (binaryRoots.isEmpty()) {
                Collection<VirtualFile> collection = sourceRoots;
                if (collection == null) {
                    SyntheticLibrary.$$$reportNull$$$0(9);
                }
                return collection;
            }
            if (sourceRoots.isEmpty()) {
                Collection<VirtualFile> collection = binaryRoots;
                if (collection == null) {
                    SyntheticLibrary.$$$reportNull$$$0(10);
                }
                return collection;
            }
            Set set = ContainerUtil.union(sourceRoots, binaryRoots);
            if (set == null) {
                SyntheticLibrary.$$$reportNull$$$0(11);
            }
            return set;
        }
        if (includeSources) {
            Collection<VirtualFile> collection = this.getSourceRoots();
            if (collection == null) {
                SyntheticLibrary.$$$reportNull$$$0(12);
            }
            return collection;
        }
        if (includeBinaries) {
            Collection<VirtualFile> collection = this.getBinaryRoots();
            if (collection == null) {
                SyntheticLibrary.$$$reportNull$$$0(13);
            }
            return collection;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            SyntheticLibrary.$$$reportNull$$$0(14);
        }
        return set;
    }

    public final boolean contains(@NotNull VirtualFile file, boolean includeSources, boolean includeBinaries) {
        Set<VirtualFile> roots;
        if (file == null) {
            SyntheticLibrary.$$$reportNull$$$0(15);
        }
        return VfsUtilCore.isUnder(file, roots = SyntheticLibrary.asSet(this.getRoots(includeSources, includeBinaries))) && !VfsUtilCore.isUnder(file, this.getExcludedRoots());
    }

    public final boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            SyntheticLibrary.$$$reportNull$$$0(16);
        }
        return this.contains(file, true, true);
    }

    @NotNull
    private static <T extends VirtualFile> Set<T> asSet(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            SyntheticLibrary.$$$reportNull$$$0(17);
        }
        return collection instanceof Set ? (Set)collection : new ObjectOpenHashSet(collection);
    }

    @NotNull
    static <T extends VirtualFile> List<T> asList(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            SyntheticLibrary.$$$reportNull$$$0(18);
        }
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newImmutableLibrary";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "asSet";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "asList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

