/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentFactory;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkCommandLineSetup;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdkUtil {
    public static final Key<Map<String, String>> COMMAND_LINE_CONTENT = Key.create((String)"command.line.content");
    public static final Key<JdkCommandLineSetup> COMMAND_LINE_SETUP_KEY = Key.create((String)"com.intellij.openapi.projectRoots.JdkCommandLineSetup");
    public static final Key<String> AGENT_RUNTIME_CLASSPATH = Key.create((String)"command.line.agent.classpath");
    public static final String PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL = "idea.do.not.escape.classpath.url";
    public static final String PROPERTY_DYNAMIC_CLASSPATH = "dynamic.classpath";

    private JdkUtil() {
    }

    @Nullable
    public static String getJdkMainAttribute(@NotNull Sdk jdk, @NotNull Attributes.Name attribute) {
        File signatureJar;
        String homePath;
        String versionString;
        if (jdk == null) {
            JdkUtil.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            JdkUtil.$$$reportNull$$$0(1);
        }
        if (attribute == Attributes.Name.IMPLEMENTATION_VERSION && (versionString = jdk.getVersionString()) != null) {
            int start = versionString.indexOf(34);
            int end = versionString.lastIndexOf(34);
            if (start >= 0 && end > start) {
                return versionString.substring(start + 1, end);
            }
        }
        if ((homePath = jdk.getHomePath()) != null && (signatureJar = FileUtil.findFirstThatExist((String[])new String[]{homePath + "/jre/lib/rt.jar", homePath + "/lib/rt.jar", homePath + "/lib/jrt-fs.jar", homePath + "/jre/lib/vm.jar", homePath + "/../Classes/classes.jar"})) != null) {
            return JarUtil.getJarAttribute((File)signatureJar, (Attributes.Name)attribute);
        }
        return null;
    }

    @Nullable
    public static String suggestJdkName(@Nullable String versionString) {
        JavaVersion version = JavaVersion.tryParse((String)versionString);
        if (version == null) {
            return null;
        }
        return JdkUtil.suggestJdkName(version, null);
    }

    @NotNull
    public static String suggestJdkName(@NotNull JavaVersion version, @Nullable String vendorPrefix) {
        if (version == null) {
            JdkUtil.$$$reportNull$$$0(2);
        }
        StringBuilder suggested = new StringBuilder();
        if (vendorPrefix != null) {
            suggested.append(vendorPrefix).append('-');
        }
        if (version.feature < 9) {
            suggested.append("1.");
        }
        suggested.append(version.feature);
        if (version.ea) {
            suggested.append("-ea");
        }
        String string = suggested.toString();
        if (string == null) {
            JdkUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean checkForJdk(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(4);
        }
        return JdkUtil.checkForJdk(Path.of(homePath, new String[0]));
    }

    public static boolean checkForJdk(@NotNull Path homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(5);
        }
        return !(!Files.exists(homePath.resolve("bin/javac"), new LinkOption[0]) && !Files.exists(homePath.resolve("bin/javac.exe"), new LinkOption[0]) || !JdkUtil.isModularRuntime(homePath) && !Files.exists(homePath.resolve("jre/lib/rt.jar"), new LinkOption[0]) && !Files.isDirectory(homePath.resolve("classes"), new LinkOption[0]) && !Files.exists(homePath.resolve("jre/lib/vm.jar"), new LinkOption[0]) && !Files.exists(homePath.resolve("../Classes/classes.jar"), new LinkOption[0]));
    }

    public static boolean checkForJre(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(6);
        }
        return JdkUtil.checkForJre(Path.of(homePath, new String[0]));
    }

    public static boolean checkForJre(@NotNull Path homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(7);
        }
        return Files.exists(homePath.resolve("bin/java"), new LinkOption[0]) || Files.exists(homePath.resolve("bin/java.exe"), new LinkOption[0]);
    }

    public static boolean isModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(8);
        }
        return JdkUtil.isModularRuntime(Path.of(homePath, new String[0]));
    }

    public static boolean isModularRuntime(@NotNull Path homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(9);
        }
        return Files.isRegularFile(homePath.resolve("lib/jrt-fs.jar"), new LinkOption[0]) || JdkUtil.isExplodedModularRuntime(homePath);
    }

    public static boolean isExplodedModularRuntime(@NotNull Path homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(10);
        }
        return Files.isDirectory(homePath.resolve("modules/java.base"), new LinkOption[0]);
    }

    @ApiStatus.Internal
    @NotNull
    public static TargetedCommandLineBuilder setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters, @NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration targetConfiguration) throws CantRunException {
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(11);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(12);
        }
        JdkCommandLineSetup setup = new JdkCommandLineSetup(request, targetConfiguration);
        setup.setupJavaExePath(javaParameters);
        setup.setupCommandLine(javaParameters);
        TargetedCommandLineBuilder targetedCommandLineBuilder = setup.getCommandLine();
        if (targetedCommandLineBuilder == null) {
            JdkUtil.$$$reportNull$$$0(13);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    public static GeneralCommandLine setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(14);
        }
        LocalTargetEnvironmentFactory environmentFactory = new LocalTargetEnvironmentFactory();
        TargetEnvironmentRequest request = environmentFactory.createRequest();
        TargetedCommandLineBuilder builder = JdkUtil.setupJVMCommandLine(javaParameters, request, null);
        LocalTargetEnvironment environment = environmentFactory.prepareRemoteEnvironment(request, TargetEnvironmentAwareRunProfileState.TargetProgressIndicator.EMPTY);
        Objects.requireNonNull((JdkCommandLineSetup)builder.getUserData(COMMAND_LINE_SETUP_KEY)).provideEnvironment(environment, TargetEnvironmentAwareRunProfileState.TargetProgressIndicator.EMPTY);
        GeneralCommandLine generalCommandLine = environment.createGeneralCommandLine(builder.build());
        if (generalCommandLine == null) {
            JdkUtil.$$$reportNull$$$0(15);
        }
        return generalCommandLine;
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        boolean hasDynamicProperty = Boolean.parseBoolean(System.getProperty("idea.dynamic.classpath", "false"));
        return project != null ? PropertiesComponent.getInstance(project).getBoolean(PROPERTY_DYNAMIC_CLASSPATH, hasDynamicProperty) : hasDynamicProperty;
    }

    public static boolean useDynamicVMOptions() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.vmoptions", true);
    }

    public static boolean useDynamicParameters() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.parameters", true);
    }

    public static boolean useClasspathJar() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.classpath.jar", true);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        try {
            javaParameters.setUseDynamicClasspath(forceDynamicClasspath);
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{exePath});
            JdkUtil.setupCommandLine(commandLine, javaParameters);
            return commandLine;
        }
        catch (CantRunException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private static void setupCommandLine(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters) throws CantRunException {
        LocalTargetEnvironmentFactory environmentFactory = new LocalTargetEnvironmentFactory();
        TargetEnvironmentRequest request = environmentFactory.createRequest();
        JdkCommandLineSetup setup = new JdkCommandLineSetup(request, null);
        setup.setupCommandLine(javaParameters);
        LocalTargetEnvironment environment = environmentFactory.prepareRemoteEnvironment(request, TargetEnvironmentAwareRunProfileState.TargetProgressIndicator.EMPTY);
        GeneralCommandLine generalCommandLine = environment.createGeneralCommandLine(setup.getCommandLine().build());
        commandLine.withParentEnvironmentType(javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.getParametersList().addAll(generalCommandLine.getParametersList().getList());
        commandLine.getEnvironment().putAll(generalCommandLine.getEnvironment());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/JdkUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/JdkUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestJdkName";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setupJVMCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdkMainAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestJdkName";
                break;
            }
            case 3: 
            case 13: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdk";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkForJre";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isModularRuntime";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExplodedModularRuntime";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupJVMCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

