/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurableTreeRenderer;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="configurable")
public class ConfigurableEP<T extends UnnamedConfigurable>
implements PluginAware {
    private static final Logger LOG = Logger.getInstance(ConfigurableEP.class);
    private PluginDescriptor pluginDescriptor;
    @Attribute(value="displayName")
    @Nls(capitalization=Nls.Capitalization.Title)
    public String displayName;
    @Attribute(value="key")
    @Nls(capitalization=Nls.Capitalization.Title)
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Property(surroundWithTag=false)
    @XCollection
    public List<ConfigurableEP<?>> children;
    @Attribute(value="childrenEPName")
    public String childrenEPName;
    @Attribute(value="dynamic")
    public boolean dynamic;
    @Attribute(value="parentId")
    public String parentId;
    @Attribute(value="id")
    public String id;
    @Attribute(value="groupId")
    public String groupId;
    @Attribute(value="groupWeight")
    public int groupWeight;
    @Attribute(value="nonDefaultProject")
    public boolean nonDefaultProject;
    @Deprecated
    @Attribute(value="implementation")
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public String implementationClass;
    @Attribute(value="instance")
    public String instanceClass;
    @Attribute(value="provider")
    public String providerClass;
    @Attribute(value="treeRenderer")
    public String treeRendererClass;
    private final NotNullLazyValue<ObjectProducer> myProducer;
    private ComponentManager componentManager;
    private Project myProject;

    @Transient
    public final PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public final void setPluginDescriptor(@NotNull PluginDescriptor value) {
        if (value == null) {
            ConfigurableEP.$$$reportNull$$$0(0);
        }
        this.pluginDescriptor = value;
    }

    @NotNull
    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        if (this.displayName != null) {
            String string = this.displayName;
            if (string == null) {
                ConfigurableEP.$$$reportNull$$$0(1);
            }
            return string;
        }
        ResourceBundle resourceBundle = this.findBundle();
        if (resourceBundle == null || this.key == null) {
            if (this.key == null) {
                LOG.warn("Bundle key missed for " + this.displayName);
            } else {
                LOG.warn("Bundle missed for " + this.displayName);
            }
            if (this.providerClass == null) {
                String string = this.instanceClass == null ? this.implementationClass : this.instanceClass;
                if (string == null) {
                    ConfigurableEP.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = this.providerClass;
            if (string == null) {
                ConfigurableEP.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = BundleBase.messageOrDefault((ResourceBundle)resourceBundle, (String)this.key, null, (Object[])new Object[0]);
        if (string == null) {
            ConfigurableEP.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public ResourceBundle findBundle() {
        String pathToBundle = this.findPathToBundle();
        if (pathToBundle == null) {
            return null;
        }
        ClassLoader loader = this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginClassLoader();
        return DynamicBundle.INSTANCE.getResourceBundle(pathToBundle, loader != null ? loader : this.getClass().getClassLoader());
    }

    @Nullable
    private String findPathToBundle() {
        if (this.bundle == null && this.pluginDescriptor != null) {
            return this.pluginDescriptor.getResourceBundleBaseName();
        }
        return this.bundle;
    }

    @NotNull
    public List<ConfigurableEP<?>> getChildren() {
        for (ConfigurableEP<?> child : this.children) {
            child.componentManager = this.componentManager;
            child.pluginDescriptor = this.pluginDescriptor;
            child.myProject = this.myProject;
        }
        List<ConfigurableEP<?>> list = this.children;
        if (list == null) {
            ConfigurableEP.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isAvailable() {
        return !this.nonDefaultProject || this.myProject == null || !this.myProject.isDefault();
    }

    @NonInjectable
    public ConfigurableEP(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            ConfigurableEP.$$$reportNull$$$0(6);
        }
        this(ApplicationManager.getApplication());
        this.setPluginDescriptor(pluginDescriptor);
    }

    protected ConfigurableEP() {
        this(ApplicationManager.getApplication());
    }

    protected ConfigurableEP(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            ConfigurableEP.$$$reportNull$$$0(7);
        }
        this.myProducer = NotNullLazyValue.atomicLazy(this::createProducer);
        this.myProject = componentManager instanceof Project ? (Project)componentManager : null;
        this.componentManager = componentManager;
    }

    @NonInjectable
    public ConfigurableEP(@NotNull Project project) {
        if (project == null) {
            ConfigurableEP.$$$reportNull$$$0(8);
        }
        this.myProducer = NotNullLazyValue.atomicLazy(this::createProducer);
        this.myProject = project;
        this.componentManager = project;
    }

    @NotNull
    protected ObjectProducer createProducer() {
        try {
            if (this.providerClass != null) {
                ConfigurableProvider provider = this.instantiateConfigurableProvider();
                return provider == null ? new ObjectProducer() : new ProviderProducer(provider);
            }
            if (this.instanceClass != null) {
                return new ClassProducer(this.componentManager, this.instanceClass, this.pluginDescriptor);
            }
            if (this.implementationClass != null) {
                return new ClassProducer(this.componentManager, this.implementationClass, this.pluginDescriptor);
            }
            throw new PluginException("configurable class name is not set", this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginId());
        }
        catch (AssertionError | Exception | LinkageError error) {
            LOG.error((Throwable)new PluginException((Throwable)error, this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginId()));
            return new ObjectProducer();
        }
    }

    @Nullable
    public final ConfigurableProvider instantiateConfigurableProvider() {
        return this.providerClass != null ? (ConfigurableProvider)this.componentManager.instantiateClass(this.providerClass, this.pluginDescriptor) : null;
    }

    @Nullable
    public final Class<?> findClassOrNull(@NotNull String className) {
        if (className == null) {
            ConfigurableEP.$$$reportNull$$$0(9);
        }
        try {
            ClassLoader classLoader = this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginClassLoader();
            return Class.forName(className, true, classLoader);
        }
        catch (Throwable t) {
            if (this.pluginDescriptor == null) {
                LOG.error(t);
            } else {
                LOG.error((Throwable)new PluginException(t, this.pluginDescriptor.getPluginId()));
            }
            return null;
        }
    }

    @Nullable
    public T createConfigurable() {
        ObjectProducer producer = (ObjectProducer)this.myProducer.getValue();
        if (producer.canCreateElement()) {
            UnnamedConfigurable configurable = (UnnamedConfigurable)producer.createElement();
            return (T)configurable;
        }
        return null;
    }

    @Nullable
    public ConfigurableTreeRenderer createTreeRenderer() {
        if (this.treeRendererClass == null) {
            return null;
        }
        try {
            return (ConfigurableTreeRenderer)this.componentManager.instantiateClass(this.treeRendererClass, this.pluginDescriptor);
        }
        catch (ProcessCanceledException exception) {
            throw exception;
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.error((Throwable)new PluginException((Throwable)e, this.pluginDescriptor == null ? null : this.pluginDescriptor.getPluginId()));
            return null;
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean canCreateConfigurable() {
        return ((ObjectProducer)this.myProducer.getValue()).canCreateElement();
    }

    @Nullable
    public Class<?> getConfigurableType() {
        return ((ObjectProducer)this.myProducer.getValue()).getType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ConfigurableEP";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ConfigurableEP";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClassOrNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ClassProducer
    extends ObjectProducer {
        private final ComponentManager componentManager;
        private final String className;
        private final PluginDescriptor pluginDescriptor;

        private ClassProducer(@NotNull ComponentManager componentManager, @NotNull String className, @Nullable PluginDescriptor pluginDescriptor) {
            if (componentManager == null) {
                ClassProducer.$$$reportNull$$$0(0);
            }
            if (className == null) {
                ClassProducer.$$$reportNull$$$0(1);
            }
            this.componentManager = componentManager;
            this.className = className;
            this.pluginDescriptor = pluginDescriptor;
        }

        @Override
        protected Object createElement() {
            try {
                return this.componentManager.instantiateClass(this.className, this.pluginDescriptor);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (ExtensionNotApplicableException ignore) {
                return null;
            }
            catch (AssertionError | Exception | LinkageError e) {
                LOG.error("Cannot create configurable", (Throwable)e);
                return null;
            }
        }

        @Override
        protected boolean canCreateElement() {
            return true;
        }

        @Override
        protected Class<?> getType() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/options/ConfigurableEP$ClassProducer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ProviderProducer
    extends ObjectProducer {
        @NotNull
        private final ConfigurableProvider myProvider;

        private ProviderProducer(@NotNull ConfigurableProvider provider) {
            if (provider == null) {
                ProviderProducer.$$$reportNull$$$0(0);
            }
            this.myProvider = provider;
        }

        @Override
        protected Object createElement() {
            return this.myProvider.createConfigurable();
        }

        @Override
        protected boolean canCreateElement() {
            return this.myProvider.canCreateConfigurable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/options/ConfigurableEP$ProviderProducer", "<init>"));
        }
    }

    protected static class ObjectProducer {
        protected ObjectProducer() {
        }

        protected Object createElement() {
            return null;
        }

        protected boolean canCreateElement() {
            return false;
        }

        protected Class<?> getType() {
            return null;
        }
    }
}

