/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.im.InputContext;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeyboardSettings", storages={@Storage(value="keyboard.xml")})
public final class NationalKeyboardSupport
implements PersistentStateComponent<OptionSet> {
    private static final String[] MAC_SUPPORTED_LOCALES = new String[]{"de", "fr", "it", "no", "sk"};
    private static final String[] WIN_SUPPORTED_LOCALES = new String[]{"be", "ru", "uk", "bg", "sr"};
    public static final String VMOption = NationalKeyboardSupport.getVMOption();
    private OptionSet myOptions = new OptionSet();

    public static boolean isSupportedKeyboardLayout(@NotNull Component component) {
        String[] supportedNonEnglishLanguages;
        if (component == null) {
            NationalKeyboardSupport.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isLinux) {
            return true;
        }
        if (SystemInfo.isMac) {
            supportedNonEnglishLanguages = MAC_SUPPORTED_LOCALES;
        } else if (SystemInfo.isWindows) {
            supportedNonEnglishLanguages = WIN_SUPPORTED_LOCALES;
        } else {
            return false;
        }
        String keyboardLayoutLanguage = NationalKeyboardSupport.getLanguageForComponent(component);
        for (String language : supportedNonEnglishLanguages) {
            if (!language.equals(keyboardLayoutLanguage)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getVMOption() {
        if (SystemInfo.isMac || SystemInfo.isLinux) {
            return "com.sun.awt.use.national.layouts";
        }
        return "com.sun.awt.useLatinNonAlphaNumKeycodes";
    }

    @NotNull
    public static String getKeymapBundleKey() {
        if (SystemInfo.isMac || SystemInfo.isLinux) {
            return "use.national.layouts.for.shortcuts";
        }
        return "use.us.non.alpha.num.keys";
    }

    @Nullable
    public static String getLanguageForComponent(@NotNull Component component) {
        Locale locale;
        if (component == null) {
            NationalKeyboardSupport.$$$reportNull$$$0(1);
        }
        return (locale = NationalKeyboardSupport.getLocaleForComponent(component)) == null ? null : locale.getLanguage();
    }

    @Nullable
    protected static Locale getLocaleForComponent(@NotNull Component component) {
        InputContext context;
        if (component == null) {
            NationalKeyboardSupport.$$$reportNull$$$0(2);
        }
        return (context = component.getInputContext()) == null ? null : context.getLocale();
    }

    public static NationalKeyboardSupport getInstance() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return new NationalKeyboardSupport();
        }
        return (NationalKeyboardSupport)ApplicationManager.getApplication().getService(NationalKeyboardSupport.class);
    }

    @Override
    @Nullable
    public OptionSet getState() {
        return this.myOptions;
    }

    @Override
    public void loadState(@NotNull OptionSet state) {
        if (state == null) {
            NationalKeyboardSupport.$$$reportNull$$$0(3);
        }
        state.enabled = state.enabled || "true".equals(System.getProperty(VMOption));
        this.myOptions = state;
    }

    @Override
    public void noStateLoaded() {
        if (SystemInfo.isMac) {
            this.myOptions.enabled = "true".equals(System.getProperty(VMOption, "true"));
        }
    }

    public boolean getEnabled() {
        return this.myOptions.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.myOptions.enabled = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/keymap/NationalKeyboardSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedKeyboardLayout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguageForComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocaleForComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class OptionSet {
        public boolean enabled = "true".equals(System.getProperty(VMOption));
    }
}

