/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "externalProjectPath", "", "(Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;Ljava/lang/String;)V", "getExternalProjectPath", "()Ljava/lang/String;", "readableName", "getReadableName", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.externalSystem"})
@ApiStatus.Experimental
public final class ExternalSystemProjectId {
    @NotNull
    private final String readableName;
    @NotNull
    private final ProjectSystemId systemId;
    @NotNull
    private final String externalProjectPath;

    @NotNull
    public final String getReadableName() {
        return this.readableName;
    }

    @NotNull
    public final ProjectSystemId getSystemId() {
        return this.systemId;
    }

    @NotNull
    public final String getExternalProjectPath() {
        return this.externalProjectPath;
    }

    public ExternalSystemProjectId(@NotNull ProjectSystemId systemId, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        this.systemId = systemId;
        this.externalProjectPath = externalProjectPath;
        this.readableName = this.systemId.getReadableName() + " (" + PathUtil.getFileName(this.externalProjectPath) + ')';
    }

    @NotNull
    public final ProjectSystemId component1() {
        return this.systemId;
    }

    @NotNull
    public final String component2() {
        return this.externalProjectPath;
    }

    @NotNull
    public final ExternalSystemProjectId copy(@NotNull ProjectSystemId systemId, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        return new ExternalSystemProjectId(systemId, externalProjectPath);
    }

    public static /* synthetic */ ExternalSystemProjectId copy$default(ExternalSystemProjectId externalSystemProjectId, ProjectSystemId projectSystemId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            projectSystemId = externalSystemProjectId.systemId;
        }
        if ((n & 2) != 0) {
            string = externalSystemProjectId.externalProjectPath;
        }
        return externalSystemProjectId.copy(projectSystemId, string);
    }

    @NotNull
    public String toString() {
        return "ExternalSystemProjectId(systemId=" + this.systemId + ", externalProjectPath=" + this.externalProjectPath + ")";
    }

    public int hashCode() {
        ProjectSystemId projectSystemId = this.systemId;
        String string = this.externalProjectPath;
        return (projectSystemId != null ? ((Object)projectSystemId).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ExternalSystemProjectId)) break block3;
                ExternalSystemProjectId externalSystemProjectId = (ExternalSystemProjectId)object;
                if (!Intrinsics.areEqual((Object)this.systemId, (Object)externalSystemProjectId.systemId) || !Intrinsics.areEqual((Object)this.externalProjectPath, (Object)externalSystemProjectId.externalProjectPath)) break block3;
            }
            return true;
        }
        return false;
    }
}

