/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import org.jetbrains.annotations.NonNls;

public class IndentGuideDescriptor {
    public final int indentLevel;
    public final int codeConstructStartLine;
    public final int startLine;
    public final int endLine;

    public IndentGuideDescriptor(int indentLevel, int startLine, int endLine) {
        this(indentLevel, startLine, startLine, endLine);
    }

    public IndentGuideDescriptor(int indentLevel, int codeConstructStartLine, int startLine, int endLine) {
        this.indentLevel = indentLevel;
        this.codeConstructStartLine = codeConstructStartLine;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public int hashCode() {
        int result = this.indentLevel;
        result = 31 * result + this.startLine;
        result = 31 * result + this.endLine;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndentGuideDescriptor that = (IndentGuideDescriptor)o;
        if (this.endLine != that.endLine) {
            return false;
        }
        if (this.indentLevel != that.indentLevel) {
            return false;
        }
        return this.startLine == that.startLine;
    }

    @NonNls
    public String toString() {
        return String.format("%d (%d-%d-%d)", this.indentLevel, this.codeConstructStartLine, this.startLine, this.endLine);
    }
}

