/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.InputStream;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;
    private final String myMotto;
    private static volatile ApplicationNamesInfo instance;

    @NotNull
    private static Element loadData() {
        Element element;
        String prefix = System.getProperty("idea.platform.prefix", "");
        String resource = "/idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        InputStream stream = ApplicationNamesInfo.class.getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        try {
            element = JDOMUtil.load((InputStream)stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
        if (element == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(0);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static Element initAndGetRawData() {
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            Element data = ApplicationNamesInfo.loadData();
            if (instance == null) {
                instance = new ApplicationNamesInfo(data);
            }
            Element element = data;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (element == null) {
                ApplicationNamesInfo.$$$reportNull$$$0(1);
            }
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo result = instance;
        if (result == null) {
            Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
            // MONITORENTER : com.intellij.openapi.application.ApplicationNamesInfo.class
            result = instance;
            if (result == null) {
                instance = result = new ApplicationNamesInfo(ApplicationNamesInfo.loadData());
            }
            // MONITOREXIT : clazz
        }
        ApplicationNamesInfo applicationNamesInfo = result;
        if (applicationNamesInfo != null) return applicationNamesInfo;
        ApplicationNamesInfo.$$$reportNull$$$0(2);
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo(@NotNull Element rootElement) {
        if (rootElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(3);
        }
        Element names = rootElement.getChild("names", rootElement.getNamespace());
        this.myProductName = names.getAttributeValue("product");
        this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
        this.myEditionName = names.getAttributeValue("edition");
        this.myScriptName = names.getAttributeValue("script");
        this.myDefaultLauncherName = names.getAttributeValue("default-launcher-name", this.myScriptName);
        this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
    }

    @NlsSafe
    public String getProductName() {
        return this.myProductName;
    }

    @NlsSafe
    public String getFullProductName() {
        return this.myFullProductName;
    }

    @NlsSafe
    public String getFullProductNameWithEdition() {
        return this.myEditionName != null ? this.myFullProductName + ' ' + this.myEditionName : this.myFullProductName;
    }

    @NlsSafe
    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        return StringUtil.capitalize((String)StringUtil.toLowerCase((String)this.myProductName));
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public String getDefaultLauncherName() {
        return this.myDefaultLauncherName;
    }

    @NotNull
    public String getMotto() {
        String string = this.myMotto;
        if (string == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initAndGetRawData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

