/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.util.NlsActions;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleOptionAction
extends ToggleAction {
    @NotNull
    private final Function<? super AnActionEvent, ? extends Option> optionSupplier;

    public ToggleOptionAction(@NotNull Option option) {
        if (option == null) {
            ToggleOptionAction.$$$reportNull$$$0(0);
        }
        this(option, null);
    }

    public ToggleOptionAction(@NotNull Option option, @Nullable Icon icon) {
        if (option == null) {
            ToggleOptionAction.$$$reportNull$$$0(1);
        }
        this((? super AnActionEvent event) -> option, icon);
    }

    public ToggleOptionAction(@NotNull Function<? super AnActionEvent, ? extends Option> optionSupplier) {
        if (optionSupplier == null) {
            ToggleOptionAction.$$$reportNull$$$0(2);
        }
        this(optionSupplier, null);
    }

    public ToggleOptionAction(@NotNull Function<? super AnActionEvent, ? extends Option> optionSupplier, @Nullable Icon icon) {
        if (optionSupplier == null) {
            ToggleOptionAction.$$$reportNull$$$0(3);
        }
        super(() -> null, () -> null, icon);
        this.optionSupplier = optionSupplier;
    }

    @Override
    public final boolean isSelected(@NotNull AnActionEvent event) {
        Option option;
        if (event == null) {
            ToggleOptionAction.$$$reportNull$$$0(4);
        }
        return (option = this.optionSupplier.apply(event)) != null && option.isSelected();
    }

    @Override
    public final void setSelected(@NotNull AnActionEvent event, boolean selected) {
        Option option;
        if (event == null) {
            ToggleOptionAction.$$$reportNull$$$0(5);
        }
        if ((option = this.optionSupplier.apply(event)) != null) {
            option.setSelected(selected);
        }
    }

    @Override
    public final void update(@NotNull AnActionEvent event) {
        Option option;
        if (event == null) {
            ToggleOptionAction.$$$reportNull$$$0(6);
        }
        boolean enabled = (option = this.optionSupplier.apply(event)) != null && option.isEnabled();
        boolean visible2 = enabled || option != null && option.isAlwaysVisible();
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(enabled);
        presentation.setVisible(visible2);
        if (visible2) {
            String description;
            Toggleable.setSelected(presentation, option.isSelected());
            String name = option.getName();
            if (name != null) {
                presentation.setText(name);
            }
            if ((description = option.getDescription()) != null) {
                presentation.setDescription(description);
            }
            if (ActionPlaces.isPopupPlace(event.getPlace())) {
                presentation.setIcon(null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionSupplier";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/ToggleOptionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Option {
        @Nullable
        @NlsActions.ActionText
        default public String getName() {
            return null;
        }

        @Nullable
        @NlsActions.ActionDescription
        default public String getDescription() {
            return null;
        }

        default public boolean isEnabled() {
            return true;
        }

        default public boolean isAlwaysVisible() {
            return false;
        }

        public boolean isSelected();

        public void setSelected(boolean var1);
    }
}

