/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/actionSystem/ActionGroupStub;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionStubBase;", "id", "", "actionClass", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ide/plugins/IdeaPluginDescriptor;)V", "getActionClass", "()Ljava/lang/String;", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "iconPath", "getIconPath", "setIconPath", "(Ljava/lang/String;)V", "getId", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "popupDefinedInXml", "", "getPopupDefinedInXml", "()Z", "setPopupDefinedInXml", "(Z)V", "initGroup", "", "target", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "intellij.platform.ide"})
public final class ActionGroupStub
extends DefaultActionGroup
implements ActionStubBase {
    private boolean popupDefinedInXml;
    @Nullable
    private String iconPath;
    @NotNull
    private final String id;
    @NotNull
    private final String actionClass;
    @NotNull
    private final IdeaPluginDescriptor plugin;

    @NotNull
    public final ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getPlugin().getPluginClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"plugin.pluginClassLoader");
        return classLoader;
    }

    public final boolean getPopupDefinedInXml() {
        return this.popupDefinedInXml;
    }

    public final void setPopupDefinedInXml(boolean bl) {
        this.popupDefinedInXml = bl;
    }

    @Override
    @Nullable
    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(@Nullable String string) {
        this.iconPath = string;
    }

    public final void initGroup(@NotNull ActionGroup target, @NotNull ActionManager actionManager) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)actionManager, (String)"actionManager");
        ActionStub.copyTemplatePresentation(this.getTemplatePresentation(), target.getTemplatePresentation());
        this.copyActionTextOverrides(target);
        target.setShortcutSet(this.getShortcutSet());
        AnAction[] children2 = this.getChildren(null, actionManager);
        Intrinsics.checkNotNullExpressionValue((Object)children2, (String)"children");
        AnAction[] anActionArray = children2;
        int n = 0;
        AnAction[] anActionArray2 = anActionArray;
        int n2 = 0;
        if (!(anActionArray2.length == 0)) {
            ActionGroup actionGroup = target;
            if (!(actionGroup instanceof DefaultActionGroup)) {
                actionGroup = null;
            }
            if ((DefaultActionGroup)actionGroup == null) {
                throw (Throwable)new PluginException("Action group class must extend DefaultActionGroup for the group to accept children: " + this.actionClass, this.getPlugin().getPluginId());
            }
            for (AnAction action : children2) {
                ((DefaultActionGroup)target).addAction(action, Constraints.LAST, actionManager);
            }
        }
        if (this.popupDefinedInXml) {
            target.setPopup(this.isPopup());
        }
        target.setSearchable(this.isSearchable());
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final String getActionClass() {
        return this.actionClass;
    }

    @Override
    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    public ActionGroupStub(@NotNull String id, @NotNull String actionClass, @NotNull IdeaPluginDescriptor plugin) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)actionClass, (String)"actionClass");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.id = id;
        this.actionClass = actionClass;
        this.plugin = plugin;
    }
}

