/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
    private static final Key<Collection<MetaLanguage>> MATCHING_LANGUAGES = Key.create((String)"language.matching");

    private LanguageUtil() {
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(0);
        }
        return LanguageUtil.getLanguageForPsi(project, file, null);
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file, @Nullable FileType fileType) {
        Language fileLanguage;
        Language explicit;
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            return null;
        }
        Language language = explicit = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
        Language language2 = explicit != null ? explicit : (fileLanguage = LanguageUtil.getFileTypeLanguage(fileType != null ? fileType : file.getFileType()));
        if (fileLanguage == null) {
            return null;
        }
        for (LanguageSubstitutor substitutor : LanguageSubstitutors.getInstance().forKey(Language.ANY)) {
            Language language3 = substitutor.getLanguage(file, project);
            if (language3 == null || language3 == Language.ANY) continue;
            fileLanguage = language3;
            break;
        }
        return LanguageSubstitutors.getInstance().substituteLanguage(fileLanguage, file, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        Language l = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
        return l != null ? l : LanguageUtil.getFileTypeLanguage(file.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@Nullable FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Nullable
    public static FileType getLanguageFileType(@Nullable Language language) {
        return language == null ? null : language.getAssociatedFileType();
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Set<Language> getAllDerivedLanguages(@NotNull Language base) {
        if (base == null) {
            LanguageUtil.$$$reportNull$$$0(2);
        }
        HashSet<Language> result = new HashSet<Language>();
        LanguageUtil.getAllDerivedLanguages(base, result);
        HashSet<Language> hashSet = result;
        if (hashSet == null) {
            LanguageUtil.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static void getAllDerivedLanguages(Language base, Set<? super Language> result) {
        result.add(base);
        for (Language dialect : base.getDialects()) {
            LanguageUtil.getAllDerivedLanguages(dialect, result);
        }
    }

    public static boolean isInTemplateLanguageFile(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(4);
        }
        if (language == Language.ANY) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    @NotNull
    public static List<Language> getInjectableLanguages() {
        return LanguageUtil.getLanguages(lang -> LanguageUtil.isInjectableLanguage(lang));
    }

    public static boolean isFileLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(5);
        }
        if (language instanceof DependentLanguage || language instanceof InjectableLanguage) {
            return false;
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            return false;
        }
        LanguageFileType type = language.getAssociatedFileType();
        if (type == null || StringUtil.isEmpty((String)type.getDefaultExtension())) {
            return false;
        }
        return StringUtil.isNotEmpty((String)type.getDefaultExtension());
    }

    @NotNull
    public static List<Language> getFileLanguages() {
        return LanguageUtil.getLanguages(lang -> LanguageUtil.isFileLanguage(lang));
    }

    @NotNull
    public static List<Language> getLanguages(Function<? super Language, Boolean> filter) {
        LanguageParserDefinitions.INSTANCE.ensureValuesLoaded();
        ArrayList<Language> result = new ArrayList<Language>();
        for (Language language : Language.getRegisteredLanguages()) {
            if (!filter.apply(language).booleanValue()) continue;
            result.add(language);
        }
        result.sort(LANGUAGE_COMPARATOR);
        ArrayList<Language> arrayList = result;
        if (arrayList == null) {
            LanguageUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        Language language;
        PsiFile containingFile;
        FileViewProvider provider;
        Set<Language> languages;
        if (element == null) {
            LanguageUtil.$$$reportNull$$$0(7);
        }
        if ((languages = (provider = (containingFile = element.getContainingFile()).getViewProvider()).getLanguages()).size() > 1 && languages.contains((Object)(language = containingFile.getLanguage()))) {
            Language language2 = language;
            if (language2 == null) {
                LanguageUtil.$$$reportNull$$$0(8);
            }
            return language2;
        }
        Language language3 = provider.getBaseLanguage();
        if (language3 == null) {
            LanguageUtil.$$$reportNull$$$0(9);
        }
        return language3;
    }

    @NotNull
    static Collection<MetaLanguage> matchingMetaLanguages(@NotNull Language language) {
        Set result;
        Collection cached;
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(10);
        }
        if ((cached = (Collection)language.getUserData(MATCHING_LANGUAGES)) != null) {
            Collection collection = cached;
            if (collection == null) {
                LanguageUtil.$$$reportNull$$$0(11);
            }
            return collection;
        }
        if (!ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(MetaLanguage.EP_NAME)) {
            List<MetaLanguage> list = Collections.emptyList();
            if (list == null) {
                LanguageUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (language instanceof MetaLanguage) {
            result = Collections.emptySet();
        } else {
            result = new HashSet();
            MetaLanguage.EP_NAME.forEachExtensionSafe(metaLanguage -> {
                if (metaLanguage.matchesLanguage(language)) {
                    result.add(metaLanguage);
                }
            });
        }
        Collection collection = (Collection)language.putUserDataIfAbsent(MATCHING_LANGUAGES, result);
        if (collection == null) {
            LanguageUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    static void clearMatchingMetaLanguages(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(14);
        }
        language.putUserData(MATCHING_LANGUAGES, null);
    }

    @NotNull
    static JBIterable<Language> hierarchy(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(15);
        }
        JBIterable jBIterable = JBIterable.generate((Object)((Object)language), Language::getBaseLanguage);
        if (jBIterable == null) {
            LanguageUtil.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/LanguageUtil";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/LanguageUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDerivedLanguages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootLanguage";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingMetaLanguages";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "hierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForPsi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllDerivedLanguages";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInjectableLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRootLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchingMetaLanguages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearMatchingMetaLanguages";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

