/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilderFactory;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleBuilder
extends AbstractModuleBuilder {
    private static final ExtensionPointName<ModuleBuilderFactory> EP_NAME = new ExtensionPointName("com.intellij.moduleBuilder");
    private static final Logger LOG = Logger.getInstance(ModuleBuilder.class);
    private final Set<ModuleConfigurationUpdater> myUpdaters = new HashSet<ModuleConfigurationUpdater>();
    private final EventDispatcher<ModuleBuilderListener> myDispatcher = EventDispatcher.create(ModuleBuilderListener.class);
    protected Sdk myJdk;
    private String myName;
    @NonNls
    private String myModuleFilePath;
    private String myContentEntryPath;

    @NotNull
    public List<Class<? extends ModuleWizardStep>> getIgnoredSteps() {
        List<Class<? extends ModuleWizardStep>> list = Collections.emptyList();
        if (list == null) {
            ModuleBuilder.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<ModuleBuilder> getAllBuilders() {
        ArrayList<ModuleBuilder> result = new ArrayList<ModuleBuilder>();
        for (ModuleType<?> moduleType : ModuleTypeManager.getInstance().getRegisteredTypes()) {
            Object builder = moduleType.createModuleBuilder();
            if (!((ModuleBuilder)builder).isAvailable()) continue;
            result.add((ModuleBuilder)builder);
        }
        EP_NAME.forEachExtensionSafe(factory -> {
            ModuleBuilder builder = factory.createBuilder();
            if (builder.isAvailable()) {
                result.add(builder);
            }
        });
        ArrayList<ModuleBuilder> arrayList = result;
        if (arrayList == null) {
            ModuleBuilder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static void deleteModuleFile(String moduleFilePath) {
        VirtualFile file;
        File moduleFile = new File(moduleFilePath);
        if (moduleFile.exists()) {
            FileUtil.delete((File)moduleFile);
        }
        if ((file = LocalFileSystem.getInstance().findFileByIoFile(moduleFile)) != null) {
            file.refresh(false, false);
        }
    }

    public boolean isAvailable() {
        return true;
    }

    @Nullable
    protected static String acceptParameter(String param) {
        return param != null && param.length() > 0 ? param : null;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String name) {
        this.myName = ModuleBuilder.acceptParameter(name);
    }

    @Override
    @Nullable
    @NonNls
    public String getBuilderId() {
        ModuleType<?> moduleType = this.getModuleType();
        return moduleType == null ? null : moduleType.getId();
    }

    @Override
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        ModuleType<?> moduleType;
        if (wizardContext == null) {
            ModuleBuilder.$$$reportNull$$$0(2);
        }
        if (modulesProvider == null) {
            ModuleBuilder.$$$reportNull$$$0(3);
        }
        return (moduleType = this.getModuleType()) == null ? ModuleWizardStep.EMPTY_ARRAY : moduleType.createWizardSteps(wizardContext, this, modulesProvider);
    }

    @Override
    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            ModuleBuilder.$$$reportNull$$$0(4);
        }
        return this.modifyStep(settingsStep);
    }

    public ModuleWizardStep modifyStep(SettingsStep settingsStep) {
        ModuleType<?> type = this.getModuleType();
        if (type == null) {
            return null;
        }
        final ModuleWizardStep step = type.modifySettingsStep(settingsStep, this);
        final List<WizardInputField<?>> fields = this.getAdditionalFields();
        for (WizardInputField<?> field : fields) {
            field.addToSettings(settingsStep);
        }
        return new ModuleWizardStep(){

            @Override
            public JComponent getComponent() {
                return null;
            }

            @Override
            public void updateDataModel() {
                if (step != null) {
                    step.updateDataModel();
                }
            }

            @Override
            public boolean validate() throws ConfigurationException {
                for (WizardInputField field : fields) {
                    if (field.validate()) continue;
                    return false;
                }
                return step == null || step.validate();
            }
        };
    }

    @Override
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        ModuleType<?> type;
        if (settingsStep == null) {
            ModuleBuilder.$$$reportNull$$$0(5);
        }
        return (type = this.getModuleType()) == null ? null : type.modifyProjectTypeStep(settingsStep, this);
    }

    @NotNull
    protected List<WizardInputField<?>> getAdditionalFields() {
        List<WizardInputField<?>> list = Collections.emptyList();
        if (list == null) {
            ModuleBuilder.$$$reportNull$$$0(6);
        }
        return list;
    }

    public String getModuleFilePath() {
        return this.myModuleFilePath;
    }

    @Override
    public void setModuleFilePath(@NonNls String path2) {
        this.myModuleFilePath = ModuleBuilder.acceptParameter(path2);
    }

    public void addModuleConfigurationUpdater(ModuleConfigurationUpdater updater) {
        this.myUpdaters.add(updater);
    }

    @Nullable
    public String getContentEntryPath() {
        if (this.myContentEntryPath == null) {
            String directory = this.getModuleFileDirectory();
            if (directory == null) {
                return null;
            }
            new File(directory).mkdirs();
            return directory;
        }
        return this.myContentEntryPath;
    }

    @Override
    public void setContentEntryPath(String moduleRootPath) {
        String path2 = ModuleBuilder.acceptParameter(moduleRootPath);
        if (path2 != null) {
            try {
                this.myContentEntryPath = FileUtil.resolveShortWindowsName((String)path2);
            }
            catch (IOException e) {
                this.myContentEntryPath = path2;
            }
        } else {
            this.myContentEntryPath = null;
        }
        if (this.myContentEntryPath != null) {
            this.myContentEntryPath = this.myContentEntryPath.replace(File.separatorChar, '/');
        }
    }

    @Nullable
    protected ContentEntry doAddContentEntry(ModifiableRootModel modifiableRootModel) {
        String contentEntryPath = this.getContentEntryPath();
        if (contentEntryPath == null) {
            return null;
        }
        new File(contentEntryPath).mkdirs();
        VirtualFile moduleContentRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(contentEntryPath.replace('\\', '/'));
        if (moduleContentRoot == null) {
            return null;
        }
        return modifiableRootModel.addContentEntry(moduleContentRoot);
    }

    @Nullable
    public String getModuleFileDirectory() {
        if (this.myModuleFilePath == null) {
            return null;
        }
        String parent = new File(this.myModuleFilePath).getParent();
        if (parent == null) {
            return null;
        }
        return parent.replace(File.separatorChar, '/');
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            ModuleBuilder.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(this.myName != null);
        LOG.assertTrue(this.myModuleFilePath != null);
        ModuleBuilder.deleteModuleFile(this.myModuleFilePath);
        ModuleType<?> moduleType = this.getModuleType();
        Module module = moduleModel.newModule(this.myModuleFilePath, moduleType.getId());
        this.setupModule(module);
        Module module2 = module;
        if (module2 == null) {
            ModuleBuilder.$$$reportNull$$$0(8);
        }
        return module2;
    }

    protected void setupModule(Module module) throws ConfigurationException {
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance(module).getModifiableModel();
        this.setupRootModel(modifiableModel);
        for (ModuleConfigurationUpdater updater : this.myUpdaters) {
            updater.update(module, modifiableModel);
        }
        modifiableModel.commit();
        this.setProjectType(module);
    }

    private void onModuleInitialized(Module module) {
        ((ModuleBuilderListener)this.myDispatcher.getMulticaster()).moduleCreated(module);
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        if (modifiableRootModel == null) {
            ModuleBuilder.$$$reportNull$$$0(9);
        }
    }

    public abstract ModuleType<?> getModuleType();

    protected ProjectType getProjectType() {
        return null;
    }

    protected void setProjectType(Module module) {
        ProjectType projectType = this.getProjectType();
        if (projectType != null && ProjectTypeService.getProjectType(module.getProject()) == null) {
            ProjectTypeService.setProjectType(module.getProject(), projectType);
        }
    }

    @NotNull
    public Module createAndCommitIfNeeded(@NotNull Project project, @Nullable ModifiableModuleModel model, boolean runFromProjectWizard) throws InvalidDataException, ConfigurationException, IOException, JDOMException, ModuleWithNameAlreadyExists {
        if (project == null) {
            ModuleBuilder.$$$reportNull$$$0(10);
        }
        ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance(project).getModifiableModel();
        Module module = this.createModule(moduleModel);
        if (model == null) {
            moduleModel.commit();
        }
        if (runFromProjectWizard) {
            StartupManager.getInstance(module.getProject()).runAfterOpened(() -> GuiUtils.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> this.onModuleInitialized(module)), ModalityState.NON_MODAL, module.getDisposed()));
        } else {
            this.onModuleInitialized(module);
        }
        Module module2 = module;
        if (module2 == null) {
            ModuleBuilder.$$$reportNull$$$0(11);
        }
        return module2;
    }

    public void addListener(ModuleBuilderListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(ModuleBuilderListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public boolean canCreateModule() {
        return true;
    }

    @Override
    @Nullable
    public List<Module> commit(@NotNull Project project, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        Module module;
        if (project == null) {
            ModuleBuilder.$$$reportNull$$$0(12);
        }
        return (module = this.commitModule(project, model)) != null ? Collections.singletonList(module) : null;
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        if (project == null) {
            ModuleBuilder.$$$reportNull$$$0(13);
        }
        if (this.canCreateModule()) {
            if (this.myName == null) {
                this.myName = project.getName();
            }
            if (this.myModuleFilePath == null) {
                this.myModuleFilePath = project.getBasePath() + File.separator + this.myName + ".iml";
            }
            try {
                return (Module)ApplicationManager.getApplication().runWriteAction(() -> this.createAndCommitIfNeeded(project, model, true));
            }
            catch (Exception ex) {
                LOG.warn((Throwable)ex);
                Messages.showErrorDialog(IdeBundle.message("error.adding.module.to.project", ex.getMessage()), IdeBundle.message("title.add.module", new Object[0]));
            }
        }
        return null;
    }

    @Override
    public Icon getNodeIcon() {
        return this.getModuleType().getNodeIcon(false);
    }

    @NlsContexts.DetailedDescription
    public String getDescription() {
        return this.getModuleType().getDescription();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getPresentableName() {
        return this.getModuleTypeName();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    protected String getModuleTypeName() {
        String name = this.getModuleType().getName();
        return StringUtil.trimEnd((String)name, (String)" Module");
    }

    public String getGroupName() {
        return this.getPresentableName().split(" ")[0];
    }

    public String getParentGroup() {
        return null;
    }

    public int getWeight() {
        return 0;
    }

    public boolean isTemplate() {
        return false;
    }

    public boolean isTemplateBased() {
        return false;
    }

    public void updateFrom(ModuleBuilder from) {
        this.myName = from.getName();
        this.myContentEntryPath = from.getContentEntryPath();
        this.myModuleFilePath = from.getModuleFilePath();
    }

    public Sdk getModuleJdk() {
        return this.myJdk;
    }

    public void setModuleJdk(Sdk jdk) {
        this.myJdk = jdk;
    }

    @NotNull
    public FrameworkRole getDefaultAcceptableRole() {
        FrameworkRole frameworkRole = this.getModuleType().getDefaultAcceptableRole();
        if (frameworkRole == null) {
            ModuleBuilder.$$$reportNull$$$0(14);
        }
        return frameworkRole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/ModuleBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredSteps";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuilders";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/ModuleBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalFields";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndCommitIfNeeded";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAcceptableRole";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modifySettingsStep";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAndCommitIfNeeded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "commitModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ModuleConfigurationUpdater {
        public abstract void update(@NotNull Module var1, @NotNull ModifiableRootModel var2);
    }
}

