/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScratchFileService {
    private static ScratchFileService ourInstance = CachedSingletonsRegistry.markCachedField(ScratchFileService.class);

    public static ScratchFileService getInstance() {
        ScratchFileService result = ourInstance;
        if (result == null) {
            ourInstance = result = (ScratchFileService)ApplicationManager.getApplication().getService(ScratchFileService.class);
        }
        return result;
    }

    @NotNull
    public abstract String getRootPath(@NotNull RootType var1);

    @Nullable
    public abstract RootType getRootType(@Nullable VirtualFile var1);

    public abstract VirtualFile findFile(@NotNull RootType var1, @NotNull String var2, @NotNull Option var3) throws IOException;

    @NotNull
    public abstract PerFileMappings<Language> getScratchesMapping();

    @Nullable
    public static RootType findRootType(@Nullable VirtualFile file) {
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        VirtualFile parent = file.isDirectory() ? file : file.getParent();
        return ScratchFileService.getInstance().getRootType(parent);
    }

    @NotNull
    public static Set<VirtualFile> getAllRootPaths() {
        ScratchFileService instance = ScratchFileService.getInstance();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        for (RootType rootType : RootType.getAllRootTypes()) {
            if (rootType.isHidden()) continue;
            ContainerUtil.addIfNotNull((Collection)result, (Object)fileSystem.findFileByPath(instance.getRootPath(rootType)));
        }
        ObjectOpenHashSet objectOpenHashSet = result;
        if (objectOpenHashSet == null) {
            ScratchFileService.$$$reportNull$$$0(0);
        }
        return objectOpenHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileService", "getAllRootPaths"));
    }

    public static enum Option {
        existing_only,
        create_if_missing,
        create_new_always;

    }
}

