/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewNode<Value>
extends AbstractTreeNode<Value>
implements RootsProvider,
SettingsProvider {
    protected static final Logger LOG = Logger.getInstance(ProjectViewNode.class);
    private final ViewSettings mySettings;
    private boolean myValidating;

    protected ProjectViewNode(Project project, @NotNull Value value, ViewSettings viewSettings) {
        if (value == null) {
            ProjectViewNode.$$$reportNull$$$0(0);
        }
        super(project, value);
        this.mySettings = viewSettings;
    }

    public abstract boolean contains(@NotNull VirtualFile var1);

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Override
    public final ViewSettings getSettings() {
        return this.mySettings;
    }

    public static List<AbstractTreeNode<?>> wrap(Collection<?> objects, Project project, Class<? extends AbstractTreeNode<?>> nodeClass, ViewSettings settings) {
        try {
            ArrayList result = new ArrayList();
            for (Object object : objects) {
                result.add(ProjectViewNode.createTreeNode(nodeClass, project, object, settings));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new ArrayList();
        }
    }

    @NotNull
    public static AbstractTreeNode<?> createTreeNode(Class<? extends AbstractTreeNode<?>> nodeClass, Project project, Object value, ViewSettings settings) throws InstantiationException {
        Object[] parameters = new Object[]{project, value, settings};
        for (Constructor<?> constructor : nodeClass.getConstructors()) {
            AbstractTreeNode abstractTreeNode;
            if (constructor.getParameterCount() != 3) continue;
            try {
                abstractTreeNode = (AbstractTreeNode)constructor.newInstance(parameters);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                // empty catch block
            }
            if (abstractTreeNode == null) {
                ProjectViewNode.$$$reportNull$$$0(1);
            }
            return abstractTreeNode;
        }
        throw new InstantiationException("no constructor found in " + nodeClass);
    }

    public boolean someChildContainsFile(VirtualFile file) {
        return this.someChildContainsFile(file, true);
    }

    public boolean someChildContainsFile(VirtualFile file, boolean optimizeByCheckingFileRootsFirst) {
        VirtualFile parent = file.getParent();
        boolean mayContain = false;
        if (optimizeByCheckingFileRootsFirst && parent != null) {
            Collection<VirtualFile> roots = this.getRoots();
            for (VirtualFile virtualFile2 : roots) {
                if (parent.equals(virtualFile2.getParent())) {
                    mayContain = true;
                } else {
                    if (!VfsUtilCore.isAncestor(virtualFile2, file, true)) continue;
                    mayContain = true;
                }
                break;
            }
        } else {
            mayContain = true;
        }
        if (!mayContain) {
            return false;
        }
        Collection<AbstractTreeNode<?>> kids = this.getChildren();
        for (AbstractTreeNode abstractTreeNode : kids) {
            ProjectViewNode node = (ProjectViewNode)abstractTreeNode;
            if (!node.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRoots() {
        Object value = this.getValue();
        if (value instanceof RootsProvider) {
            Collection<VirtualFile> collection = ((RootsProvider)value).getRoots();
            if (collection == null) {
                ProjectViewNode.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (value instanceof VirtualFile) {
            Set<VirtualFile> set = Collections.singleton((VirtualFile)value);
            if (set == null) {
                ProjectViewNode.$$$reportNull$$$0(3);
            }
            return set;
        }
        if (value instanceof PsiFileSystemItem) {
            PsiFileSystemItem item = (PsiFileSystemItem)value;
            Collection<VirtualFile> collection = ProjectViewNode.getDefaultRootsFor(item.getVirtualFile());
            if (collection == null) {
                ProjectViewNode.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            ProjectViewNode.$$$reportNull$$$0(5);
        }
        return set;
    }

    protected static Collection<VirtualFile> getDefaultRootsFor(@Nullable VirtualFile file) {
        return file != null ? Collections.singleton(file) : Collections.emptySet();
    }

    @Override
    protected boolean hasProblemFileBeneath() {
        if (!Registry.is((String)"projectView.showHierarchyErrors")) {
            return false;
        }
        Project project = this.getProject();
        WolfTheProblemSolver wolf = project == null ? null : WolfTheProblemSolver.getInstance(project);
        return wolf != null && wolf.hasProblemFilesBeneath((Condition<? super VirtualFile>)((Condition)virtualFile2 -> {
            Object value;
            return this.contains((VirtualFile)virtualFile2) && ((value = this.getValue()) instanceof PsiElement && Comparing.equal((Object)PsiUtilCore.getVirtualFile((PsiElement)value), (Object)virtualFile2) || this.someChildContainsFile((VirtualFile)virtualFile2));
        }));
    }

    public boolean canHaveChildrenMatching(Condition<? super PsiFile> condition) {
        return true;
    }

    @Nullable
    @NlsContexts.PopupTitle
    public String getTitle() {
        return null;
    }

    public boolean isSortByFirstChild() {
        return false;
    }

    @NotNull
    public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
        if (settings == null) {
            ProjectViewNode.$$$reportNull$$$0(6);
        }
        NodeSortOrder nodeSortOrder = settings.isManualOrder() ? NodeSortOrder.MANUAL : NodeSortOrder.UNSPECIFIED;
        if (nodeSortOrder == null) {
            ProjectViewNode.$$$reportNull$$$0(7);
        }
        return nodeSortOrder;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 0;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return null;
    }

    @Nullable
    public Comparable getSortKey() {
        return null;
    }

    @Nullable
    public Comparable getManualOrderKey() {
        return null;
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        return null;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return false;
    }

    public boolean validate() {
        this.setValidating(true);
        try {
            this.update();
        }
        finally {
            this.setValidating(false);
        }
        return this.getValue() != null;
    }

    @Override
    protected boolean shouldPostprocess() {
        return !this.isValidating();
    }

    @Override
    protected boolean shouldApply() {
        return !this.isValidating();
    }

    private void setValidating(boolean validating) {
        this.myValidating = validating;
    }

    public boolean isValidating() {
        return this.myValidating;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/ProjectViewNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/ProjectViewNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

