/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@com.intellij.openapi.components.State(name="PluginFeatureService", storages={@Storage(value="pluginAdvertiser.xml")})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003JJ\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u00060\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u00060\u000fJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/plugins/PluginFeatureService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ide/plugins/PluginFeatureService$State;", "()V", "featureMappingsCollected", "", "", "state", "collectFeatureMapping", "", "T", "featureType", "ep", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "idMapping", "Lkotlin/Function1;", "displayNameMapping", "getPluginForFeature", "Lcom/intellij/ide/plugins/PluginFeatureService$FeaturePluginData;", "implementationName", "getState", "loadState", "Companion", "FeaturePluginData", "FeaturePluginsList", "State", "intellij.platform.ide"})
public final class PluginFeatureService
implements PersistentStateComponent<State> {
    private final Set<String> featureMappingsCollected;
    private State state;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public State getState() {
        return this.state;
    }

    @Override
    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    public final <T> void collectFeatureMapping(@NotNull String featureType, @NotNull ExtensionPointName<T> ep, @NotNull Function1<? super T, String> idMapping, @NotNull Function1<? super T, String> displayNameMapping) {
        FeaturePluginsList featurePluginsList;
        Intrinsics.checkNotNullParameter((Object)featureType, (String)"featureType");
        Intrinsics.checkNotNullParameter(ep, (String)"ep");
        Intrinsics.checkNotNullParameter(idMapping, (String)"idMapping");
        Intrinsics.checkNotNullParameter(displayNameMapping, (String)"displayNameMapping");
        if (!this.featureMappingsCollected.add(featureType)) {
            return;
        }
        Map<String, FeaturePluginsList> $this$getOrPut$iv = this.state.getFeatures();
        boolean $i$f$getOrPut = false;
        FeaturePluginsList value$iv = $this$getOrPut$iv.get(featureType);
        if (value$iv == null) {
            boolean bl = false;
            FeaturePluginsList answer$iv = new FeaturePluginsList();
            $this$getOrPut$iv.put(featureType, answer$iv);
            featurePluginsList = answer$iv;
        } else {
            featurePluginsList = value$iv;
        }
        FeaturePluginsList pluginsList = featurePluginsList;
        ep.processWithPluginDescriptor(new BiConsumer<T, PluginDescriptor>(idMapping, displayNameMapping, pluginsList){
            final /* synthetic */ Function1 $idMapping;
            final /* synthetic */ Function1 $displayNameMapping;
            final /* synthetic */ FeaturePluginsList $pluginsList;

            public final void accept(T ext, PluginDescriptor pluginDescriptor) {
                String id = (String)this.$idMapping.invoke(ext);
                String displayName = (String)this.$displayNameMapping.invoke(ext);
                Map<String, FeaturePluginData> map = this.$pluginsList.getFeatureMap();
                PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor2, (String)"pluginDescriptor");
                String string = pluginDescriptor2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginDescriptor.name");
                PluginId pluginId = pluginDescriptor.getPluginId();
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginDescriptor.pluginId");
                String string2 = pluginId.getIdString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluginDescriptor.pluginId.idString");
                map.put(id, new FeaturePluginData(displayName, string, string2, pluginDescriptor.isBundled()));
            }
            {
                this.$idMapping = function1;
                this.$displayNameMapping = function12;
                this.$pluginsList = featurePluginsList;
            }
        });
    }

    @Nullable
    public final FeaturePluginData getPluginForFeature(@NotNull String featureType, @NotNull String implementationName) {
        Intrinsics.checkNotNullParameter((Object)featureType, (String)"featureType");
        Intrinsics.checkNotNullParameter((Object)implementationName, (String)"implementationName");
        FeaturePluginsList featurePluginsList = this.state.getFeatures().get(featureType);
        if (featurePluginsList == null) {
            return null;
        }
        FeaturePluginsList pluginList = featurePluginsList;
        FeaturePluginData featurePluginData = pluginList.getFeatureMap().get(implementationName);
        if (featurePluginData == null) {
            return null;
        }
        return featurePluginData;
    }

    public PluginFeatureService() {
        boolean bl = false;
        this.featureMappingsCollected = new LinkedHashSet();
        this.state = new State();
    }

    @JvmStatic
    @NotNull
    public static final PluginFeatureService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/plugins/PluginFeatureService$FeaturePluginData;", "", "displayName", "", "pluginName", "pluginId", "bundled", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getBundled", "()Z", "getDisplayName", "()Ljava/lang/String;", "getPluginId", "getPluginName", "intellij.platform.ide"})
    public static final class FeaturePluginData {
        @Attribute(value="displayName")
        @NotNull
        private final String displayName;
        @Attribute(value="pluginName")
        @NotNull
        private final String pluginName;
        @Attribute(value="pluginId")
        @NotNull
        private final String pluginId;
        @Attribute(value="bundled")
        private final boolean bundled;

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getPluginName() {
            return this.pluginName;
        }

        @NotNull
        public final String getPluginId() {
            return this.pluginId;
        }

        public final boolean getBundled() {
            return this.bundled;
        }

        public FeaturePluginData(@NotNull String displayName, @NotNull String pluginName, @NotNull String pluginId, boolean bundled) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            this.displayName = displayName;
            this.pluginName = pluginName;
            this.pluginId = pluginId;
            this.bundled = bundled;
        }

        public /* synthetic */ FeaturePluginData(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            this(string, string2, string3, bl);
        }

        public FeaturePluginData() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/plugins/PluginFeatureService$FeaturePluginsList;", "", "()V", "featureMap", "", "", "Lcom/intellij/ide/plugins/PluginFeatureService$FeaturePluginData;", "getFeatureMap", "()Ljava/util/Map;", "setFeatureMap", "(Ljava/util/Map;)V", "intellij.platform.ide"})
    public static final class FeaturePluginsList {
        @NotNull
        private Map<String, FeaturePluginData> featureMap;

        @NotNull
        public final Map<String, FeaturePluginData> getFeatureMap() {
            return this.featureMap;
        }

        public final void setFeatureMap(@NotNull Map<String, FeaturePluginData> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.featureMap = map;
        }

        public FeaturePluginsList() {
            boolean bl = false;
            this.featureMap = new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/plugins/PluginFeatureService$State;", "", "()V", "features", "", "", "Lcom/intellij/ide/plugins/PluginFeatureService$FeaturePluginsList;", "getFeatures", "()Ljava/util/Map;", "setFeatures", "(Ljava/util/Map;)V", "intellij.platform.ide"})
    public static final class State {
        @NotNull
        private Map<String, FeaturePluginsList> features;

        @NotNull
        public final Map<String, FeaturePluginsList> getFeatures() {
            return this.features;
        }

        public final void setFeatures(@NotNull Map<String, FeaturePluginsList> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.features = map;
        }

        public State() {
            boolean bl = false;
            this.features = new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/plugins/PluginFeatureService$Companion;", "", "()V", "getInstance", "Lcom/intellij/ide/plugins/PluginFeatureService;", "intellij.platform.ide"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PluginFeatureService getInstance() {
            Object object = ApplicationManager.getApplication().getService(PluginFeatureService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026atureService::class.java)");
            return (PluginFeatureService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

