/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QuickSwitchSchemeAction
extends AnAction
implements DumbAware {
    private static final Condition<? super AnAction> DEFAULT_PRESELECT_ACTION = a -> a.getTemplatePresentation().getIcon() != AllIcons.Actions.Forward;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected static final Icon ourCurrentAction = AllIcons.Actions.Forward;
    protected static final Icon ourNotCurrentAction = IconLoader.createLazy(() -> EmptyIcon.create((int)AllIcons.Actions.Forward.getIconWidth(), (int)AllIcons.Actions.Forward.getIconHeight()));
    protected String myActionPlace = "unknown";
    private final boolean myShowPopupWithNoActions;

    protected QuickSwitchSchemeAction() {
        this(false);
    }

    protected QuickSwitchSchemeAction(boolean showPopupWithNoActions) {
        this.myShowPopupWithNoActions = showPopupWithNoActions;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickSwitchSchemeAction.$$$reportNull$$$0(0);
        }
        Project project = e.getData(CommonDataKeys.PROJECT);
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillActions(project, group, e.getDataContext());
        this.showPopup(e, group);
    }

    protected abstract void fillActions(Project var1, @NotNull DefaultActionGroup var2, @NotNull DataContext var3);

    private void showPopup(AnActionEvent e, DefaultActionGroup group) {
        if (!this.myShowPopupWithNoActions && group.getChildrenCount() == 0) {
            return;
        }
        JBPopupFactory.ActionSelectionAid aid = this.getAidMethod();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.getPopupTitle(e), (ActionGroup)group, e.getDataContext(), aid, true, null, -1, this.preselectAction(), this.myActionPlace);
        this.showPopup(e, popup);
    }

    @Nullable
    protected Condition<? super AnAction> preselectAction() {
        return DEFAULT_PRESELECT_ACTION;
    }

    protected void showPopup(AnActionEvent e, ListPopup popup) {
        Project project = e.getProject();
        if (project != null) {
            popup.showCenteredInCurrentWindow(project);
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    protected JBPopupFactory.ActionSelectionAid getAidMethod() {
        return JBPopupFactory.ActionSelectionAid.NUMBERING;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    protected String getPopupTitle(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickSwitchSchemeAction.$$$reportNull$$$0(1);
        }
        return e.getPresentation().getText();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickSwitchSchemeAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null && this.isEnabled());
    }

    protected boolean isEnabled() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/QuickSwitchSchemeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopupTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

