/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UINumericRange;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ReportValue;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

@State(name="GeneralSettings", storages={@Storage(value="ide.general.xml")})
public final class GeneralSettings
implements PersistentStateComponent<GeneralSettings> {
    public static final String IDE_GENERAL_XML = "ide.general.xml";
    public static final int OPEN_PROJECT_ASK = -1;
    public static final int OPEN_PROJECT_NEW_WINDOW = 0;
    public static final int OPEN_PROJECT_SAME_WINDOW = 1;
    public static final int OPEN_PROJECT_SAME_WINDOW_ATTACH = 2;
    public static final String PROP_INACTIVE_TIMEOUT = "inactiveTimeout";
    public static final String PROP_SUPPORT_SCREEN_READERS = "supportScreenReaders";
    public static final String SCREEN_READERS_DETECTED_PROPERTY = "ide.support.screenreaders.detected";
    public static final String SUPPORT_SCREEN_READERS = "ide.support.screenreaders.enabled";
    private static final Boolean SUPPORT_SCREEN_READERS_OVERRIDDEN = GeneralSettings.getSupportScreenReadersOverridden();
    static final UINumericRange SAVE_FILES_AFTER_IDLE_SEC = new UINumericRange(15, 1, 300);
    private static final String SHOW_TIPS_ON_STARTUP_DEFAULT_VALUE_PROPERTY = "ide.show.tips.on.startup.default.value";
    private String myBrowserPath = BrowserUtil.getDefaultAlternativeBrowserPath();
    private boolean myShowTipsOnStartup = Boolean.parseBoolean(System.getProperty("ide.show.tips.on.startup.default.value", "true"));
    private boolean myReopenLastProject = true;
    private boolean mySupportScreenReaders = (Boolean)ObjectUtils.chooseNotNull((Object)SUPPORT_SCREEN_READERS_OVERRIDDEN, (Object)Boolean.getBoolean("ide.support.screenreaders.detected"));
    private boolean mySyncOnFrameActivation = true;
    private boolean mySaveOnFrameDeactivation = true;
    private boolean myAutoSaveIfInactive = false;
    private int myInactiveTimeout = 15;
    private boolean myUseSafeWrite = true;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private boolean myUseDefaultBrowser = true;
    private boolean mySearchInBackground;
    private boolean myConfirmExit = true;
    private boolean myShowWelcomeScreen = !PlatformUtils.isDataGrip();
    private int myConfirmOpenNewProject = -1;
    private ProcessCloseConfirmation myProcessCloseConfirmation = ProcessCloseConfirmation.ASK;
    private String myDefaultProjectDirectory = "";
    private static final String CONFIGURED_PROPERTY = "GeneralSettings.initiallyConfigured";

    public static GeneralSettings getInstance() {
        return (GeneralSettings)ApplicationManager.getApplication().getService(GeneralSettings.class);
    }

    public GeneralSettings() {
        PropertiesComponent propertyManager;
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isHeadlessEnvironment()) {
            return;
        }
        if ((PlatformUtils.isPyCharmEducational() || PlatformUtils.isRubyMine() || PlatformUtils.isWebStorm()) && !(propertyManager = PropertiesComponent.getInstance()).isValueSet(CONFIGURED_PROPERTY)) {
            propertyManager.setValue(CONFIGURED_PROPERTY, true);
            this.setShowTipsOnStartup(false);
        }
    }

    public void addPropertyChangeListener(@NotNull String propertyName, @NotNull Disposable parentDisposable, @NotNull PropertyChangeListener listener2) {
        if (propertyName == null) {
            GeneralSettings.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            GeneralSettings.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            GeneralSettings.$$$reportNull$$$0(2);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(propertyName, listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myPropertyChangeSupport.removePropertyChangeListener(propertyName, listener2));
    }

    public String getBrowserPath() {
        return this.myBrowserPath;
    }

    public void setBrowserPath(String browserPath) {
        this.myBrowserPath = browserPath;
    }

    public boolean isShowTipsOnStartup() {
        return this.myShowTipsOnStartup;
    }

    public void setShowTipsOnStartup(boolean value) {
        this.myShowTipsOnStartup = value;
    }

    public boolean isReopenLastProject() {
        return this.myReopenLastProject;
    }

    public void setReopenLastProject(boolean reopenLastProject) {
        this.myReopenLastProject = reopenLastProject;
    }

    @Nullable
    private static Boolean getSupportScreenReadersOverridden() {
        String prop = System.getProperty(SUPPORT_SCREEN_READERS);
        return prop != null ? Boolean.valueOf(Boolean.parseBoolean(prop)) : null;
    }

    public static boolean isSupportScreenReadersOverridden() {
        return SUPPORT_SCREEN_READERS_OVERRIDDEN != null;
    }

    public boolean isSupportScreenReaders() {
        return this.mySupportScreenReaders;
    }

    public void setSupportScreenReaders(boolean enabled) {
        boolean oldValue = this.mySupportScreenReaders;
        this.mySupportScreenReaders = enabled;
        this.myPropertyChangeSupport.firePropertyChange(PROP_SUPPORT_SCREEN_READERS, (Object)oldValue, (Object)enabled);
    }

    public ProcessCloseConfirmation getProcessCloseConfirmation() {
        return this.myProcessCloseConfirmation;
    }

    public void setProcessCloseConfirmation(ProcessCloseConfirmation processCloseConfirmation) {
        this.myProcessCloseConfirmation = processCloseConfirmation;
    }

    @OptionTag(value="autoSyncFiles")
    public boolean isSyncOnFrameActivation() {
        return this.mySyncOnFrameActivation;
    }

    public void setSyncOnFrameActivation(boolean syncOnFrameActivation) {
        this.mySyncOnFrameActivation = syncOnFrameActivation;
    }

    @OptionTag(value="autoSaveFiles")
    public boolean isSaveOnFrameDeactivation() {
        return this.mySaveOnFrameDeactivation;
    }

    public void setSaveOnFrameDeactivation(boolean saveOnFrameDeactivation) {
        this.mySaveOnFrameDeactivation = saveOnFrameDeactivation;
    }

    public boolean isAutoSaveIfInactive() {
        return this.myAutoSaveIfInactive;
    }

    public void setAutoSaveIfInactive(boolean autoSaveIfInactive) {
        this.myAutoSaveIfInactive = autoSaveIfInactive;
    }

    public int getInactiveTimeout() {
        return SAVE_FILES_AFTER_IDLE_SEC.fit(this.myInactiveTimeout);
    }

    public void setInactiveTimeout(int inactiveTimeoutSeconds) {
        int oldInactiveTimeout = this.myInactiveTimeout;
        this.myInactiveTimeout = SAVE_FILES_AFTER_IDLE_SEC.fit(inactiveTimeoutSeconds);
        this.myPropertyChangeSupport.firePropertyChange(PROP_INACTIVE_TIMEOUT, (Object)oldInactiveTimeout, (Object)this.myInactiveTimeout);
    }

    public boolean isUseSafeWrite() {
        return this.myUseSafeWrite;
    }

    public void setUseSafeWrite(boolean value) {
        this.myUseSafeWrite = value;
    }

    @Override
    @NotNull
    public GeneralSettings getState() {
        GeneralSettings generalSettings = this;
        if (generalSettings == null) {
            GeneralSettings.$$$reportNull$$$0(3);
        }
        return generalSettings;
    }

    @Override
    public void loadState(@NotNull GeneralSettings state) {
        if (state == null) {
            GeneralSettings.$$$reportNull$$$0(4);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean isUseDefaultBrowser() {
        return this.myUseDefaultBrowser;
    }

    public void setUseDefaultBrowser(boolean value) {
        this.myUseDefaultBrowser = value;
    }

    @Transient
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean isConfirmExtractFiles() {
        return true;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void setConfirmExtractFiles(boolean value) {
    }

    public boolean isConfirmExit() {
        return this.myConfirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.myConfirmExit = confirmExit;
    }

    public boolean isShowWelcomeScreen() {
        return this.myShowWelcomeScreen;
    }

    public void setShowWelcomeScreen(boolean show) {
        this.myShowWelcomeScreen = show;
    }

    @OptionTag(value="confirmOpenNewProject2")
    @ReportValue
    @OpenNewProjectOption
    public int getConfirmOpenNewProject() {
        return this.myConfirmOpenNewProject;
    }

    public void setConfirmOpenNewProject(@OpenNewProjectOption int confirmOpenNewProject) {
        this.myConfirmOpenNewProject = confirmOpenNewProject;
    }

    public boolean isSearchInBackground() {
        return this.mySearchInBackground;
    }

    public void setSearchInBackground(boolean searchInBackground) {
        this.mySearchInBackground = searchInBackground;
    }

    public @SystemDependent String getDefaultProjectDirectory() {
        return this.myDefaultProjectDirectory;
    }

    public void setDefaultProjectDirectory(@SystemDependent String defaultProjectDirectory) {
        this.myDefaultProjectDirectory = defaultProjectDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/GeneralSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/GeneralSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static @interface OpenNewProjectOption {
    }

    public static enum ProcessCloseConfirmation {
        ASK,
        TERMINATE,
        DISCONNECT;

    }
}

