/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentedSettings;
import com.intellij.execution.ui.FragmentedSettingsBuilder;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class FragmentedSettingsEditor<Settings extends FragmentedSettings>
extends CompositeSettingsEditor<Settings> {
    private final NotNullLazyValue<Collection<SettingsEditorFragment<Settings, ?>>> myFragments = NotNullLazyValue.createValue(() -> {
        Collection<SettingsEditorFragment<Settings, ?>> fragments2 = this.createFragments();
        this.initFragments(fragments2);
        return fragments2;
    });
    protected final Settings mySettings;

    protected FragmentedSettingsEditor(Settings settings) {
        this.mySettings = settings;
    }

    protected boolean isDefaultSettings() {
        return false;
    }

    protected abstract Collection<SettingsEditorFragment<Settings, ?>> createFragments();

    protected final Collection<SettingsEditorFragment<Settings, ?>> getFragments() {
        return (Collection)this.myFragments.getValue();
    }

    private Stream<SettingsEditorFragment<Settings, ?>> getAllFragments() {
        return this.getFragments().stream().flatMap(fragment -> Stream.concat(fragment.getChildren().stream(), Stream.of(fragment)));
    }

    @Override
    public void resetEditorFrom(@NotNull Settings settings) {
        if (settings == null) {
            FragmentedSettingsEditor.$$$reportNull$$$0(0);
        }
        super.resetEditorFrom(settings);
        List<FragmentedSettings.Option> options = settings.getSelectedOptions();
        Iterator iterator = this.getAllFragments().collect(Collectors.toList()).iterator();
        while (iterator.hasNext()) {
            SettingsEditorFragment fragment;
            FragmentedSettings.Option option = (FragmentedSettings.Option)ContainerUtil.find(options, arg_0 -> FragmentedSettingsEditor.lambda$resetEditorFrom$2(fragment = (SettingsEditorFragment)iterator.next(), arg_0));
            fragment.setSelected(option == null ? fragment.isInitiallyVisible(settings) : option.getVisible());
        }
    }

    @Override
    public void applyEditorTo(@NotNull Settings settings) throws ConfigurationException {
        if (settings == null) {
            FragmentedSettingsEditor.$$$reportNull$$$0(1);
        }
        super.applyEditorTo(settings);
        List<FragmentedSettings.Option> options = this.getAllFragments().filter(fragment -> (this.isDefaultSettings() || fragment.isCanBeHidden()) && fragment.isSelected() != fragment.isInitiallyVisible(settings)).map(fragment -> new FragmentedSettings.Option(fragment.getId(), fragment.isSelected())).collect(Collectors.toList());
        if (!this.isDefaultSettings()) {
            for (FragmentedSettings.Option option : settings.getSelectedOptions()) {
                if (ContainerUtil.or(options, o -> o.getName().equals(option.getName()))) continue;
                options.add(option);
            }
        }
        settings.setSelectedOptions(options);
    }

    @Override
    @NotNull
    public CompositeSettingsBuilder<Settings> getBuilder() {
        return new FragmentedSettingsBuilder<Settings>(this.getFragments(), null, this);
    }

    @Override
    public void installWatcher(JComponent c) {
        super.installWatcher(c);
        this.addSettingsEditorListener(editor -> SwingUtilities.invokeLater(() -> UIUtil.setupEnclosingDialogBounds((JComponent)c)));
    }

    protected void initFragments(Collection<? extends SettingsEditorFragment<Settings, ?>> fragments2) {
    }

    private static /* synthetic */ boolean lambda$resetEditorFrom$2(SettingsEditorFragment fragment, FragmentedSettings.Option o) {
        return fragment.getId().equals(o.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "settings";
        objectArray2[1] = "com/intellij/execution/ui/FragmentedSettingsEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

