/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class FragmentedSettingsBuilder<Settings>
implements CompositeSettingsBuilder<Settings> {
    static final int TOP_INSET = 5;
    static final int GROUP_INSET = 20;
    public static final int TAG_VGAP = JBUI.scale((int)6);
    public static final int TAG_HGAP = JBUI.scale((int)2);
    private final Disposable myDisposable;
    private final JPanel myPanel;
    private final GridBagConstraints myConstraints;
    private final Collection<? extends SettingsEditorFragment<Settings, ?>> myFragments;
    private final SettingsEditorFragment<Settings, ?> myMain;
    private DropDownLink<String> myLinkLabel;

    FragmentedSettingsBuilder(Collection<? extends SettingsEditorFragment<Settings, ?>> fragments2, SettingsEditorFragment<Settings, ?> main, @NotNull Disposable disposable) {
        if (disposable == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(0);
        }
        this.myPanel = new JPanel(new GridBagLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                FragmentedSettingsBuilder.this.registerShortcuts();
            }
        };
        this.myConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insetsTop((int)5), 0, 0);
        this.myFragments = fragments2;
        this.myMain = main;
        this.myDisposable = disposable;
    }

    @Override
    @NotNull
    public Collection<SettingsEditor<Settings>> getEditors() {
        return new ArrayList<SettingsEditor<Settings>>(this.myFragments);
    }

    @Override
    @NotNull
    public JComponent createCompoundEditor() {
        if (this.myMain == null) {
            this.myPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            this.addLine(new JSeparator());
        }
        ArrayList fragments2 = new ArrayList(this.myFragments);
        List subGroups = ContainerUtil.filter(fragments2, fragment -> !fragment.getChildren().isEmpty());
        fragments2.removeAll(subGroups);
        fragments2.sort(Comparator.comparingInt(SettingsEditorFragment::getCommandLinePosition));
        this.buildBeforeRun(fragments2);
        this.addLine(this.buildHeader(fragments2));
        if (this.myMain != null && this.myMain.component() != null) {
            this.addLine((Component)this.myMain.component());
        }
        this.buildCommandLinePanel(fragments2);
        JPanel tagsPanel = new JPanel((LayoutManager)new WrapLayout(3, TAG_HGAP, TAG_VGAP));
        for (SettingsEditorFragment settingsEditorFragment : fragments2) {
            JComponent component2 = settingsEditorFragment.getComponent();
            if (settingsEditorFragment.isTag()) {
                tagsPanel.add(component2);
                continue;
            }
            this.addLine(component2);
            if (settingsEditorFragment.getHintComponent() == null) continue;
            this.addLine(settingsEditorFragment.getHintComponent(), 0, FragmentedSettingsBuilder.getLeftInset(component2), 5);
        }
        this.addLine(tagsPanel, 20, -FragmentedSettingsBuilder.getLeftInset((JComponent)tagsPanel.getComponent(0)) - TAG_HGAP, 0);
        for (SettingsEditorFragment settingsEditorFragment : subGroups) {
            this.addLine(settingsEditorFragment.getComponent());
        }
        if (this.myMain == null) {
            this.myConstraints.weighty = 1.0;
            this.myPanel.add((Component)new JPanel(), this.myConstraints);
        }
        List panels = Arrays.stream(this.myPanel.getComponents()).filter(component -> component instanceof PanelWithAnchor).map(component -> (PanelWithAnchor)component).collect(Collectors.toList());
        UIUtil.mergeComponentsWithAnchor(panels);
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private void addLine(Component component, int top, int left, int bottom) {
        this.myConstraints.insets = JBUI.insets((int)top, (int)left, (int)bottom, (int)0);
        this.myPanel.add(component, this.myConstraints.clone());
        ++this.myConstraints.gridy;
        this.myConstraints.insets = JBUI.insetsTop((int)top);
    }

    private void addLine(Component component) {
        this.addLine(component, 5, 0, 0);
    }

    private void buildBeforeRun(Collection<? extends SettingsEditorFragment<Settings, ?>> fragments2) {
        SettingsEditorFragment beforeRun = (SettingsEditorFragment)ContainerUtil.find(fragments2, fragment -> fragment.getCommandLinePosition() == -2);
        if (beforeRun != null) {
            this.addLine(beforeRun.getComponent(), 5, 0, 10);
            fragments2.remove(beforeRun);
        }
    }

    private JComponent buildHeader(Collection<? extends SettingsEditorFragment<Settings, ?>> fragments2) {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        SettingsEditorFragment label = (SettingsEditorFragment)ContainerUtil.find(fragments2, fragment -> fragment.getCommandLinePosition() == -1);
        if (label != null) {
            panel2.add((Component)label.getComponent(), "West");
            fragments2.remove(label);
        }
        if (this.myMain != null) {
            panel2.add((Component)SeparatorFactory.createSeparator(this.myMain.getGroup(), null), "Center");
        }
        String message = OptionsBundle.message(this.myMain == null ? "settings.editor.modify.options" : "settings.editor.modify", new Object[0]);
        this.myLinkLabel = new DropDownLink<String>(message, (Function1<DropDownLink<String>, JBPopup>)((Function1)link -> this.showOptions()));
        this.myLinkLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        JPanel linkPanel = new JPanel(new BorderLayout());
        linkPanel.add(this.myLinkLabel, "Center");
        CustomShortcutSet shortcutSet = KeymapUtil.getMnemonicAsShortcut(TextWithMnemonic.parse((String)message).getMnemonic());
        if (shortcutSet != null) {
            List list = ContainerUtil.map((Object[])shortcutSet.getShortcuts(), shortcut -> KeymapUtil.getShortcutText(shortcut));
            list.sort(Comparator.comparingInt(String::length));
            JLabel shortcutLabel = new JLabel((String)list.get(0));
            shortcutLabel.setEnabled(false);
            shortcutLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
            linkPanel.add((Component)shortcutLabel, "East");
        }
        panel2.add((Component)linkPanel, "East");
        return panel2;
    }

    private void registerShortcuts() {
        for (final AnAction action : this.buildGroup((Ref<JComponent>)new Ref()).getChildActionsOrStubs()) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (shortcutSet.getShortcuts().length <= 0 || !(action instanceof ToggleFragmentAction)) continue;
            new DumbAwareAction(action.getTemplateText()){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    SettingsEditorFragment<?, ?> fragment = ((ToggleFragmentAction)action).myFragment;
                    fragment.toggle(true, e);
                    IdeFocusManager.getGlobalInstance().requestFocus(fragment.getEditorComponent(), false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/ui/FragmentedSettingsBuilder$2", "actionPerformed"));
                }
            }.registerCustomShortcutSet(shortcutSet, this.myPanel.getRootPane(), this.myDisposable);
        }
    }

    private JBPopup showOptions() {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.myLinkLabel);
        Ref lastSelected = new Ref();
        DefaultActionGroup group = this.buildGroup((Ref<JComponent>)lastSelected);
        Runnable callback = () -> ApplicationManager.getApplication().invokeLater(() -> {
            JComponent component = (JComponent)lastSelected.get();
            if (component != null && !(component instanceof JPanel) && !(component instanceof JLabel)) {
                IdeFocusManager.getGlobalInstance().requestFocus(component, false);
            }
        });
        String title = this.myMain != null ? IdeBundle.message("popup.title.add.group.options", this.myMain.getGroup()) : IdeBundle.message("popup.title.add.run.options", new Object[0]);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(title, group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, callback, -1);
        popup.addListSelectionListener(e -> {
            AnActionHolder data = (AnActionHolder)PlatformDataKeys.SELECTED_ITEM.getData((DataProvider)e.getSource());
            popup.setAdText(FragmentedSettingsBuilder.getHint(data == null ? null : data.getAction()), 2);
        });
        popup.setAdText(FragmentedSettingsBuilder.getHint((AnAction)ContainerUtil.find((Object[])group.getChildren(null), action -> !(action instanceof Separator))), 2);
        return popup;
    }

    @NotNull
    @NlsContexts.PopupAdvertisement
    private static String getHint(AnAction action) {
        return action != null && StringUtil.isNotEmpty((String)action.getTemplatePresentation().getDescription()) ? action.getTemplatePresentation().getDescription() : "";
    }

    @NotNull
    private DefaultActionGroup buildGroup(List<? extends SettingsEditorFragment<Settings, ?>> fragments2, Ref<? super JComponent> lastSelected) {
        fragments2.sort(Comparator.comparingInt(SettingsEditorFragment::getMenuPosition));
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        String group = null;
        for (SettingsEditorFragment<Settings, ?> fragment : this.restoreGroups(fragments2)) {
            ActionGroup customGroup;
            if (fragment.isRemovable() && !Objects.equals(group, fragment.getGroup())) {
                group = fragment.getGroup();
                actionGroup.add(new Separator(group));
            }
            if ((customGroup = fragment.getCustomActionGroup()) != null) {
                actionGroup.add(customGroup);
                continue;
            }
            ToggleFragmentAction action = new ToggleFragmentAction(fragment, lastSelected);
            ShortcutSet shortcutSet = ActionUtil.getMnemonicAsShortcut(action);
            if (shortcutSet != null) {
                action.registerCustomShortcutSet(shortcutSet, null);
            }
            actionGroup.add(action);
            List<SettingsEditorFragment<Settings, ?>> children2 = fragment.getChildren();
            if (children2.isEmpty()) continue;
            DefaultActionGroup childGroup = this.buildGroup(children2, lastSelected);
            childGroup.setPopup(true);
            childGroup.getTemplatePresentation().setText(fragment.getChildrenGroupName());
            actionGroup.add(childGroup);
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    private DefaultActionGroup buildGroup(Ref<? super JComponent> lastSelected) {
        DefaultActionGroup group = this.buildGroup(ContainerUtil.filter(this.myFragments, fragment -> fragment.getName() != null), lastSelected);
        if (this.myMain != null) {
            group.add((AnAction)Separator.create(), Constraints.FIRST);
            group.add((AnAction)new ToggleFragmentAction(this.myMain, lastSelected), Constraints.FIRST);
        }
        return group;
    }

    private List<SettingsEditorFragment<Settings, ?>> restoreGroups(List<? extends SettingsEditorFragment<Settings, ?>> fragments2) {
        ArrayList result = new ArrayList();
        for (SettingsEditorFragment<Settings, ?> fragment : fragments2) {
            String group = fragment.getGroup();
            int last = ContainerUtil.lastIndexOf(result, f -> f.getGroup() == group);
            result.add(last >= 0 ? last + 1 : result.size(), fragment);
        }
        return result;
    }

    private void buildCommandLinePanel(Collection<? extends SettingsEditorFragment<Settings, ?>> fragments2) {
        List list = ContainerUtil.filter(fragments2, fragment -> fragment.getCommandLinePosition() > 0);
        if (list.isEmpty()) {
            return;
        }
        fragments2.removeAll(list);
        CommandLinePanel panel2 = new CommandLinePanel(list, this.myDisposable);
        this.addLine(panel2, 0, -panel2.getLeftInset(), 5);
    }

    static int getLeftInset(JComponent component) {
        if (component.getBorder() != null) {
            return component.getBorder().getBorderInsets((Component)component).left;
        }
        JComponent wrapped = (JComponent)ContainerUtil.find((Object[])component.getComponents(), co -> co.isVisible());
        return wrapped != null ? FragmentedSettingsBuilder.getLeftInset(wrapped) : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/FragmentedSettingsBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/FragmentedSettingsBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompoundEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ToggleFragmentAction
    extends ToggleAction
    implements DumbAware {
        private final SettingsEditorFragment<?, ?> myFragment;
        private final Ref<? super JComponent> myLastSelected;

        private ToggleFragmentAction(SettingsEditorFragment<?, ?> fragment, Ref<? super JComponent> lastSelected) {
            super(fragment.getName());
            this.myFragment = fragment;
            this.myLastSelected = lastSelected;
            this.getTemplatePresentation().setDescription(fragment.getActionHint());
            if (fragment.getActionDescription() != null) {
                this.getTemplatePresentation().putClientProperty(Presentation.PROP_VALUE, fragment.getActionDescription());
            }
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleFragmentAction.$$$reportNull$$$0(0);
            }
            return this.myFragment.isSelected();
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleFragmentAction.$$$reportNull$$$0(1);
            }
            this.myFragment.toggle(state, e);
            if (state) {
                this.myLastSelected.set((Object)this.myFragment.getEditorComponent());
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleFragmentAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setVisible(this.myFragment.isRemovable());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/ui/FragmentedSettingsBuilder$ToggleFragmentAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

