/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PluginProblemReporter;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.Strings;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginException
extends RuntimeException
implements ExceptionWithAttachments {
    private final PluginId myPluginId;
    private final List<Attachment> attachments;

    public PluginException(@NotNull @NonNls String message, Throwable cause, @Nullable PluginId pluginId) {
        if (message == null) {
            PluginException.$$$reportNull$$$0(0);
        }
        super(message, cause);
        this.myPluginId = pluginId;
        this.attachments = Collections.emptyList();
    }

    public PluginException(@NotNull Throwable e, @Nullable PluginId pluginId) {
        if (e == null) {
            PluginException.$$$reportNull$$$0(1);
        }
        super(e.getMessage(), e);
        this.myPluginId = pluginId;
        this.attachments = Collections.emptyList();
    }

    public PluginException(@NotNull @NonNls String message, @Nullable PluginId pluginId) {
        if (message == null) {
            PluginException.$$$reportNull$$$0(2);
        }
        super(message);
        this.myPluginId = pluginId;
        this.attachments = Collections.emptyList();
    }

    public PluginException(@NotNull @NonNls String message, @Nullable PluginId pluginId, @NotNull List<Attachment> attachments) {
        if (message == null) {
            PluginException.$$$reportNull$$$0(3);
        }
        if (attachments == null) {
            PluginException.$$$reportNull$$$0(4);
        }
        super(message);
        this.myPluginId = pluginId;
        this.attachments = attachments;
    }

    @Nullable
    public final PluginId getPluginId() {
        return this.myPluginId;
    }

    @Override
    @NotNull
    @NonNls
    public String getMessage() {
        String message = super.getMessage();
        if (this.myPluginId == null || message != null && message.contains("PluginDescriptor(")) {
            String string = message;
            if (string == null) {
                PluginException.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = Strings.notNullize((String)message) + " [Plugin: " + this.myPluginId + "]";
        if (string == null) {
            PluginException.$$$reportNull$$$0(6);
        }
        return string;
    }

    public final Attachment @NotNull [] getAttachments() {
        Attachment[] attachmentArray = this.attachments.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            PluginException.$$$reportNull$$$0(7);
        }
        return attachmentArray;
    }

    @NotNull
    public static PluginException createByClass(@NotNull @NonNls String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        if (errorMessage == null) {
            PluginException.$$$reportNull$$$0(8);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(9);
        }
        PluginException pluginException = PluginProblemReporter.getInstance().createPluginExceptionByClass(errorMessage, cause, pluginClass);
        if (pluginException == null) {
            PluginException.$$$reportNull$$$0(10);
        }
        return pluginException;
    }

    @NotNull
    public static PluginException createByClass(@NotNull Throwable cause, @NotNull Class<?> pluginClass) {
        if (cause == null) {
            PluginException.$$$reportNull$$$0(11);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(12);
        }
        PluginException pluginException = PluginProblemReporter.getInstance().createPluginExceptionByClass(Strings.notNullize((String)cause.getMessage()), cause, pluginClass);
        if (pluginException == null) {
            PluginException.$$$reportNull$$$0(13);
        }
        return pluginException;
    }

    public static void logPluginError(@NotNull Logger logger, @NotNull @NonNls String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        if (logger == null) {
            PluginException.$$$reportNull$$$0(14);
        }
        if (errorMessage == null) {
            PluginException.$$$reportNull$$$0(15);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(16);
        }
        logger.error((Throwable)PluginException.createByClass(errorMessage, cause, pluginClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/PluginException";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/PluginException";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createByClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createByClass";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logPluginError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

