/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettingsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.JdomKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ParameterNameHintsSettings", storages={@Storage(value="parameter.hints.xml")})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0007\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0002H\u0016J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u001e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002J\u0016\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0016J\u0016\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010%\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002R6\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000e\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "addedPatterns", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "disabledLanguages", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "options", "", "removedPatterns", "addIgnorePattern", "", "language", "Lcom/intellij/lang/Language;", "pattern", "getAddedPatterns", "getBlackListDiff", "Lcom/intellij/codeInsight/hints/settings/Diff;", "getOption", "optionId", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getRemovedPatterns", "getState", "isEnabledForLanguage", "loadState", "state", "setAddedPatterns", "added", "setBlackListDiff", "diff", "setIsEnabledForLanguage", "enabled", "setOption", "value", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "setRemovedPatterns", "removed", "Companion", "intellij.platform.lang"})
public final class ParameterNameHintsSettings
implements PersistentStateComponent<Element> {
    private final HashMap<String, Set<String>> removedPatterns;
    private final HashMap<String, Set<String>> addedPatterns;
    private final HashMap<String, Boolean> options;
    private final HashSet<String> disabledLanguages;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void addIgnorePattern(@NotNull Language language, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Set<String> patternsBefore = this.getAddedPatterns(language);
        this.setAddedPatterns(language, SetsKt.plus(patternsBefore, (Object)pattern));
    }

    @NotNull
    public final Diff getBlackListDiff(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Set<String> added = this.getAddedPatterns(language);
        Set<String> removed = this.getRemovedPatterns(language);
        return new Diff(added, removed);
    }

    public final void setBlackListDiff(@NotNull Language language, @NotNull Diff diff) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.setAddedPatterns(language, diff.getAdded());
        this.setRemovedPatterns(language, diff.getRemoved());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Element getState() {
        Object element;
        String string;
        Object removed;
        Map.Entry element$iv;
        Iterator iterator;
        boolean $i$f$forEach3;
        Object $this$forEach$iv;
        Element root;
        block12: {
            block11: {
                root = new Element("settings");
                Map map = this.removedPatterns;
                boolean bl = false;
                if (!map.isEmpty()) break block11;
                map = this.addedPatterns;
                bl = false;
                if (!(!map.isEmpty())) break block12;
            }
            Element blacklists = new Element("blacklists");
            root.addContent(blacklists);
            Set<String> set = this.removedPatterns.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"removedPatterns.keys");
            Set<String> set2 = this.addedPatterns.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"addedPatterns.keys");
            Set allLanguages = SetsKt.plus(set, (Iterable)set2);
            $this$forEach$iv = allLanguages;
            $i$f$forEach3 = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Element element2;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Set set3;
                element$iv = iterator.next();
                String it = (String)((Object)element$iv);
                boolean bl = false;
                Object object = this.removedPatterns.get(it);
                if (object == null) {
                    object = removed = SetsKt.emptySet();
                }
                if ((set3 = this.addedPatterns.get(it)) == null) {
                    set3 = SetsKt.emptySet();
                }
                Set added = set3;
                string = new Element("blacklist");
                boolean bl2 = false;
                boolean bl3 = false;
                String $this$apply = string;
                boolean bl4 = false;
                $this$apply.setAttribute("language", it);
                Iterable $this$map$iv = (Iterable)removed;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it2;
                    String string2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    element2 = ParameterNameHintsSettingsKt.access$toPatternElement((String)it2, "removed");
                    collection.add(element2);
                }
                List removedElements = (List)destination$iv$iv;
                Iterable $this$map$iv2 = added;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    String bl5 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl6 = false;
                    element2 = ParameterNameHintsSettingsKt.access$toPatternElement((String)it3, "added");
                    collection.add(element2);
                }
                List addedElements = (List)destination$iv$iv2;
                $this$apply.addContent((Collection)CollectionsKt.plus((Collection)addedElements, (Iterable)removedElements));
                String languageBlacklist = string;
                blacklists.addContent((Element)languageBlacklist);
            }
        }
        Object $this$forEach$iv2 = this.options;
        boolean $i$f$forEach22 = false;
        $this$forEach$iv = $this$forEach$iv2;
        $i$f$forEach3 = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void id;
            Map.Entry $dstr$id$value = element$iv = iterator.next();
            boolean bl = false;
            removed = $dstr$id$value;
            boolean added = false;
            string = (String)removed.getKey();
            removed = $dstr$id$value;
            added = false;
            boolean value = (Boolean)removed.getValue();
            element = new Element("option");
            element.setAttribute("id", (String)id);
            element.setAttribute("value", String.valueOf(value));
            root.addContent(element);
        }
        $this$forEach$iv2 = this.disabledLanguages;
        $i$f$forEach22 = false;
        if (!$this$forEach$iv2.isEmpty()) {
            Collection<Element> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Element disabledLanguagesElement = new Element("disabledLanguages");
            Iterable $i$f$forEach22 = this.disabledLanguages;
            Element element3 = disabledLanguagesElement;
            boolean $i$f$map = false;
            void $i$f$forEach3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Element element4 = new Element("language");
                element4.setAttribute("id", (String)it);
                Element element5 = element4;
                collection.add(element5);
            }
            collection = (List)destination$iv$iv;
            element3.addContent((Collection)collection);
            root.addContent(disabledLanguagesElement);
        }
        return root;
    }

    public final void setIsEnabledForLanguage(boolean enabled, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        if (!enabled) {
            this.disabledLanguages.add(language.getID());
        } else {
            this.disabledLanguages.remove(language.getID());
        }
    }

    public final boolean isEnabledForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return !this.disabledLanguages.contains(language.getID());
    }

    @Override
    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.addedPatterns.clear();
        this.removedPatterns.clear();
        this.options.clear();
        this.disabledLanguages.clear();
        Object object = state.getChild("blacklists");
        if (object == null || (object = object.getChildren("blacklist")) == null) {
            object = CollectionsKt.emptyList();
        }
        Object allBlacklistElements = object;
        Iterable $this$forEach$iv = (Iterable)allBlacklistElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String language;
            Element blacklistElement = (Element)element$iv;
            boolean bl = false;
            Element element = blacklistElement;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"blacklistElement");
            if (ParameterNameHintsSettingsKt.access$attributeValue(element, "language") == null) {
                continue;
            }
            Set added = ParameterNameHintsSettingsKt.access$extractPatterns(blacklistElement, "added");
            Map map = this.addedPatterns;
            Set set = this.addedPatterns.get(language);
            if (set == null || (set = SetsKt.plus((Set)set, (Iterable)added)) == null) {
                set = added;
            }
            map.put(language, set);
            Set removed = ParameterNameHintsSettingsKt.access$extractPatterns(blacklistElement, "removed");
            Map map2 = this.removedPatterns;
            Set set2 = this.removedPatterns.get(language);
            if (set2 == null || (set2 = SetsKt.plus((Set)set2, (Iterable)removed)) == null) {
                set2 = removed;
            }
            map2.put(language, set2);
        }
        List list = state.getChildren("option");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"state.getChildren(\"option\")");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String id = it.getAttributeValue("id");
            Map map = this.options;
            String string = id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
            Element element = it;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"it");
            map.put(string, JdomKt.getAttributeBooleanValue((Element)element, (String)"value"));
        }
        Element element = state.getChild("disabledLanguages");
        if (element != null) {
            Element element2 = element;
            boolean bl = false;
            boolean bl2 = false;
            Element $this$apply = element2;
            boolean bl3 = false;
            List list2 = $this$apply.getChildren("language");
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(XmlTagHelper.DISABLED_LANGUAGE_ITEM)");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String languageId;
                Element it = (Element)element$iv;
                boolean bl4 = false;
                Element element3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"it");
                if (ParameterNameHintsSettingsKt.access$attributeValue(element3, "id") == null) {
                    continue;
                }
                this.disabledLanguages.add(languageId);
            }
        }
    }

    @Nullable
    public final Boolean getOption(@NotNull String optionId) {
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        return this.options.get(optionId);
    }

    public final void setOption(@NotNull String optionId, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        if (value == null) {
            this.options.remove(optionId);
        } else {
            ((Map)this.options).put(optionId, value);
        }
    }

    private final Set<String> getAddedPatterns(Language language) {
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.displayName");
        String key = string;
        Set set = this.addedPatterns.get(key);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final Set<String> getRemovedPatterns(Language language) {
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.displayName");
        String key = string;
        Set set = this.removedPatterns.get(key);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void setRemovedPatterns(Language language, Set<String> removed) {
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.displayName");
        String key = string;
        ((Map)this.removedPatterns).put(key, removed);
    }

    private final void setAddedPatterns(Language language, Set<String> added) {
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.displayName");
        String key = string;
        ((Map)this.addedPatterns).put(key, added);
    }

    public ParameterNameHintsSettings() {
        boolean bl = false;
        this.removedPatterns = new HashMap();
        bl = false;
        this.addedPatterns = new HashMap();
        bl = false;
        this.options = new HashMap();
        bl = false;
        this.disabledLanguages = new HashSet();
    }

    @JvmStatic
    @NotNull
    public static final ParameterNameHintsSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings$Companion;", "", "()V", "getInstance", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ParameterNameHintsSettings getInstance() {
            Object object = ApplicationManager.getApplication().getService(ParameterNameHintsSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026intsSettings::class.java)");
            return (ParameterNameHintsSettings)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

