/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.ColorizeProxyIcon;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayLevel {
    private static final Map<HighlightSeverity, HighlightDisplayLevel> ourMap = new HashMap<HighlightSeverity, HighlightDisplayLevel>();
    public static final HighlightDisplayLevel GENERIC_SERVER_ERROR_OR_WARNING = new HighlightDisplayLevel(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, HighlightDisplayLevel.createIconPair(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING, AllIcons.General.InspectionsWarning, AllIcons.General.InspectionsWarningEmpty));
    public static final HighlightDisplayLevel ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR, HighlightDisplayLevel.createIconPair(CodeInsightColors.ERRORS_ATTRIBUTES, AllIcons.General.InspectionsError, AllIcons.General.InspectionsErrorEmpty));
    public static final HighlightDisplayLevel WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING, HighlightDisplayLevel.createIconPair(CodeInsightColors.WARNINGS_ATTRIBUTES, AllIcons.General.InspectionsWarning, AllIcons.General.InspectionsWarningEmpty));
    private static final TextAttributesKey DO_NOT_SHOW_KEY = TextAttributesKey.createTextAttributesKey("DO_NOT_SHOW");
    public static final HighlightDisplayLevel DO_NOT_SHOW = new HighlightDisplayLevel(HighlightSeverity.INFORMATION, EmptyIcon.ICON_0);
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static final HighlightDisplayLevel INFO = new HighlightDisplayLevel(HighlightSeverity.INFO, HighlightDisplayLevel.createIconByKey(DO_NOT_SHOW_KEY));
    public static final HighlightDisplayLevel WEAK_WARNING = new HighlightDisplayLevel(HighlightSeverity.WEAK_WARNING, HighlightDisplayLevel.createIconPair(CodeInsightColors.WEAK_WARNING_ATTRIBUTES, AllIcons.General.InspectionsWarning, AllIcons.General.InspectionsWarningEmpty));
    public static final HighlightDisplayLevel NON_SWITCHABLE_ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR){

        @Override
        public boolean isNonSwitchable() {
            return true;
        }
    };
    public static final HighlightDisplayLevel NON_SWITCHABLE_WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING){

        @Override
        public boolean isNonSwitchable() {
            return true;
        }
    };
    private Pair<Icon, Icon> myIconPair;
    private final HighlightSeverity mySeverity;

    @Nullable
    public static HighlightDisplayLevel find(String name) {
        if ("NON_SWITCHABLE_ERROR".equals(name)) {
            return NON_SWITCHABLE_ERROR;
        }
        if ("NON_SWITCHABLE_WARNING".equals(name)) {
            return NON_SWITCHABLE_WARNING;
        }
        for (Map.Entry<HighlightSeverity, HighlightDisplayLevel> entry : ourMap.entrySet()) {
            HighlightSeverity severity = entry.getKey();
            HighlightDisplayLevel displayLevel = entry.getValue();
            if (!Comparing.strEqual((String)severity.getName(), (String)name)) continue;
            return displayLevel;
        }
        return null;
    }

    public static HighlightDisplayLevel find(HighlightSeverity severity) {
        return ourMap.get(severity);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity, @NotNull Icon icon) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(1);
        }
        this(severity, (Pair<Icon, Icon>)new Pair((Object)icon, (Object)icon));
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity, Pair<@NotNull Icon, @NotNull Icon> iconPair) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(2);
        }
        this(severity);
        this.myIconPair = iconPair;
        ourMap.put(this.mySeverity, this);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(3);
        }
        this.myIconPair = new Pair(null, null);
        this.mySeverity = severity;
    }

    @NonNls
    public String toString() {
        return this.mySeverity.toString();
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = this.mySeverity.getName();
        if (string == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public Icon getIcon() {
        return (Icon)this.myIconPair.first;
    }

    public Icon getOutlineIcon() {
        return (Icon)this.myIconPair.second;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(5);
        }
        return highlightSeverity;
    }

    public boolean isNonSwitchable() {
        return false;
    }

    public static void registerSeverity(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey key, @Nullable Icon icon) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(6);
        }
        if (key == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(7);
        }
        Pair iconPair = icon != null ? new Pair((Object)icon, (Object)icon) : HighlightDisplayLevel.createIconByKey(key);
        HighlightDisplayLevel level = ourMap.get(severity);
        if (level == null) {
            new HighlightDisplayLevel(severity, (Pair<Icon, Icon>)iconPair);
        } else {
            level.myIconPair = iconPair;
        }
    }

    public static int getEmptyIconDim() {
        return JBUIScale.scale((int)14);
    }

    private static Pair<Icon, Icon> createIconByKey(@NotNull TextAttributesKey key) {
        if (key == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(8);
        }
        return StringUtil.containsIgnoreCase((String)key.getExternalName(), (String)"error") ? HighlightDisplayLevel.createIconPair(key, AllIcons.General.InspectionsError, AllIcons.General.InspectionsErrorEmpty) : HighlightDisplayLevel.createIconPair(key, AllIcons.General.InspectionsWarning, AllIcons.General.InspectionsWarningEmpty);
    }

    private static Pair<Icon, Icon> createIconPair(@NotNull TextAttributesKey key, @NotNull Icon first, @NotNull Icon second) {
        if (key == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(9);
        }
        if (first == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(10);
        }
        if (second == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(11);
        }
        return new Pair((Object)new ColorizedIcon(key, first), (Object)new ColorizedIcon(key, second));
    }

    @NotNull
    public static Icon createIconByMask(Color renderColor) {
        return new MyColorIcon(HighlightDisplayLevel.getEmptyIconDim(), renderColor);
    }

    @Nullable
    private static Color getColorFromAttributes(@NotNull TextAttributesKey key) {
        EditorColorsManager manager;
        if (key == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(12);
        }
        if ((manager = EditorColorsManager.getInstance()) != null) {
            Color stripe;
            TextAttributes attributes = manager.getGlobalScheme().getAttributes(key);
            Color color = stripe = attributes == null ? null : attributes.getErrorStripeColor();
            if (stripe != null) {
                return stripe;
            }
            if (attributes != null) {
                Color effectColor = attributes.getEffectColor();
                if (effectColor != null) {
                    return effectColor;
                }
                Color foregroundColor = attributes.getForegroundColor();
                if (foregroundColor != null) {
                    return foregroundColor;
                }
                return attributes.getBackgroundColor();
            }
            return null;
        }
        TextAttributes defaultAttributes = key.getDefaultAttributes();
        if (defaultAttributes == null) {
            defaultAttributes = TextAttributes.ERASE_MARKER;
        }
        return defaultAttributes.getErrorStripeColor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeHighlighting/HighlightDisplayLevel";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeHighlighting/HighlightDisplayLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerSeverity";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createIconByKey";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createIconPair";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColorFromAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ColorizedIcon
    extends ColorizeProxyIcon
    implements ColoredIcon {
        private final TextAttributesKey myKey;

        private ColorizedIcon(@NotNull TextAttributesKey key, @NotNull Icon baseIcon) {
            if (key == null) {
                ColorizedIcon.$$$reportNull$$$0(0);
            }
            if (baseIcon == null) {
                ColorizedIcon.$$$reportNull$$$0(1);
            }
            super(baseIcon);
            this.myKey = key;
        }

        @Override
        @NotNull
        public Color getColor() {
            Color color = (Color)ObjectUtils.notNull((Object)HighlightDisplayLevel.getColorFromAttributes(this.myKey), (Object)JBColor.GRAY);
            if (color == null) {
                ColorizedIcon.$$$reportNull$$$0(2);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseIcon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeHighlighting/HighlightDisplayLevel$ColorizedIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeHighlighting/HighlightDisplayLevel$ColorizedIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ColoredIcon {
        public Color getColor();
    }

    private static class MyColorIcon
    extends ColorIcon
    implements ColoredIcon {
        MyColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                MyColorIcon.$$$reportNull$$$0(0);
            }
            super(size, color);
        }

        @Override
        public Color getColor() {
            return this.getIconColor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeHighlighting/HighlightDisplayLevel$MyColorIcon", "<init>"));
        }
    }
}

