/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleConstraints;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContinuationOption
implements CodeStyleConstraints {
    @Nullable
    private IntegerField myField;
    private boolean mySupported;
    private final @NlsContexts.Label String myName;
    private final Function<? super CommonCodeStyleSettings.IndentOptions, Integer> myGetter;
    private final BiConsumer<? super CommonCodeStyleSettings.IndentOptions, ? super Integer> mySetter;
    private final int myDefaultValue;
    private JLabel myLabel;

    public ContinuationOption(@NlsContexts.Label String name, Function<? super CommonCodeStyleSettings.IndentOptions, Integer> getter2, BiConsumer<? super CommonCodeStyleSettings.IndentOptions, ? super Integer> setter2, int defaultValue) {
        this.myName = name;
        this.myGetter = getter2;
        this.mySetter = setter2;
        this.myDefaultValue = defaultValue;
    }

    public void addToEditor(@NotNull IndentOptionsEditor editor) {
        if (editor == null) {
            ContinuationOption.$$$reportNull$$$0(0);
        }
        if (this.mySupported) {
            this.myLabel = new JLabel(this.myName);
            this.myField = editor.createIndentTextField("Continuation indent", 0, 32, this.myDefaultValue);
            editor.add((JComponent)this.myLabel, this.myField);
        }
    }

    public void setSupported(boolean supported) {
        this.mySupported = supported;
    }

    public void setEnabled(boolean isEnabled) {
        if (this.mySupported && this.myField != null && this.myLabel != null) {
            this.myField.setEnabled(isEnabled);
            this.myLabel.setEnabled(isEnabled);
        }
    }

    public boolean isModified(@NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (options == null) {
            ContinuationOption.$$$reportNull$$$0(1);
        }
        return this.mySupported && this.myField != null && !this.myField.getValue().equals(this.myGetter.apply(options));
    }

    public void reset(@NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (options == null) {
            ContinuationOption.$$$reportNull$$$0(2);
        }
        if (this.mySupported && this.myField != null) {
            this.myField.setValue(this.myGetter.apply(options));
            this.setDefaultValueToDisplay(options.CONTINUATION_INDENT_SIZE);
        }
    }

    public void apply(@NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (options == null) {
            ContinuationOption.$$$reportNull$$$0(3);
        }
        if (this.mySupported && this.myField != null) {
            this.mySetter.accept(options, this.myField.getValue());
        }
    }

    public void addListener(@NotNull ValueEditor.Listener<Integer> listener2) {
        if (listener2 == null) {
            ContinuationOption.$$$reportNull$$$0(4);
        }
        assert (this.myField != null);
        this.myField.getValueEditor().addListener(listener2);
    }

    public void setDefaultValueToDisplay(int value) {
        if (this.mySupported && this.myField != null) {
            this.myField.setDefaultValueText(Integer.toString(value));
        }
    }

    public void setVisible(boolean visible2) {
        if (this.myField != null && this.myLabel != null) {
            this.myLabel.setVisible(visible2);
            this.myField.setVisible(visible2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/ContinuationOption";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addToEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

