/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.DefaultCodeStyleSettingsFacade;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsFacade;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.FileCodeStyleProvider;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.joinLines.JoinedLinesSpacingCalculator;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CodeStyle {
    private CodeStyle() {
    }

    @NotNull
    public static CodeStyleSettings getDefaultSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance().getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Project project) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(1);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getProjectOrDefaultSettings(@Nullable Project project) {
        return project != null ? CodeStyle.getSettings(project) : CodeStyle.getDefaultSettings();
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull PsiFile file) {
        Project project;
        CodeStyleSettings tempSettings;
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(3);
        }
        if ((tempSettings = CodeStyleSettingsManager.getInstance(project = file.getProject()).getTemporarySettings()) != null) {
            CodeStyleSettings codeStyleSettings = tempSettings;
            if (codeStyleSettings == null) {
                CodeStyle.$$$reportNull$$$0(4);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings result = (CodeStyleSettings)FileCodeStyleProvider.EP_NAME.computeSafeIfAny(provider -> provider.getSettings(file));
        if (result != null) {
            CodeStyleSettings codeStyleSettings = result;
            if (codeStyleSettings == null) {
                CodeStyle.$$$reportNull$$$0(5);
            }
            return codeStyleSettings;
        }
        PsiFile settingsFile = CodeStyle.getSettingsPsi(file);
        if (settingsFile == null) {
            return CodeStyle.getSettings(project);
        }
        CodeStyleSettings cachedSettings = CodeStyleCachingService.getInstance(project).tryGetSettings(settingsFile);
        return cachedSettings != null ? cachedSettings : CodeStyle.getSettings(project);
    }

    @Nullable
    public static PsiFile getSettingsPsi(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(6);
        }
        if (CodeStyle.hasLocalVirtualFile(file)) {
            return file;
        }
        PsiFile originalFile = (PsiFile)file.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (originalFile != null) {
            return CodeStyle.getSettingsPsi(originalFile);
        }
        return null;
    }

    private static boolean hasLocalVirtualFile(@NotNull PsiFile file) {
        VirtualFile virtualFile2;
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(7);
        }
        return (virtualFile2 = file.getVirtualFile()) != null && virtualFile2.isInLocalFileSystem();
    }

    public static CodeStyleSettings getSettings(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(8);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(9);
        }
        return (file = PsiDocumentManager.getInstance(project).getPsiFile(document)) != null ? CodeStyle.getSettings(file) : CodeStyle.getSettings(project);
    }

    public static CodeStyleSettings getSettings(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(10);
        }
        if ((project = editor.getProject()) != null) {
            return CodeStyle.getSettings(project, editor.getDocument());
        }
        return CodeStyle.getDefaultSettings();
    }

    @Nullable
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull Editor editor) {
        PsiFile file;
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(11);
        }
        if ((project = editor.getProject()) != null && (file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null) {
            return CodeStyle.getLanguageSettings(file);
        }
        return null;
    }

    @NotNull
    public static <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull PsiFile file, Class<T> customSettingsClass) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(12);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        T t = rootSettings.getCustomSettings(customSettingsClass);
        if (t == null) {
            CodeStyle.$$$reportNull$$$0(13);
        }
        return t;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(14);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(file.getLanguage());
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(15);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file, @NotNull Language language) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(16);
        }
        if (language == null) {
            CodeStyle.$$$reportNull$$$0(17);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(18);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(19);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings.IndentOptions indentOptions = rootSettings.getIndentOptionsByFile(file);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(20);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptionsByFileType(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(21);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = file != null ? CodeStyle.getSettings(project).getIndentOptions(file.getFileType()) : CodeStyle.getSettings(project).getIndentOptions();
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(22);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(23);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(24);
        }
        if ((file = PsiDocumentManager.getInstance(project).getPsiFile(document)) != null) {
            return CodeStyle.getIndentOptions(file);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(project).getIndentOptions((FileType)null);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(25);
        }
        return indentOptions;
    }

    public static int getIndentSize(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(26);
        }
        return CodeStyle.getIndentOptions((PsiFile)file).INDENT_SIZE;
    }

    @TestOnly
    public static void setTemporarySettings(@Nullable Project project, @NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(27);
        }
        CodeStyleSettingsManager.getInstance(project).setTemporarySettings(settings);
    }

    @TestOnly
    public static void dropTemporarySettings(@Nullable Project project) {
        CodeStyleSettingsManager codeStyleSettingsManager = project == null || project.isDefault() ? (CodeStyleSettingsManager)ApplicationManager.getApplication().getServiceIfCreated(AppCodeStyleSettingsManager.class) : (CodeStyleSettingsManager)project.getServiceIfCreated(ProjectCodeStyleSettingsManager.class);
        if (codeStyleSettingsManager != null) {
            codeStyleSettingsManager.dropTemporarySettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void doWithTemporarySettings(@NotNull Project project, @NotNull CodeStyleSettings tempSettings, @NotNull Runnable runnable) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(28);
        }
        if (tempSettings == null) {
            CodeStyle.$$$reportNull$$$0(29);
        }
        if (runnable == null) {
            CodeStyle.$$$reportNull$$$0(30);
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance(project);
        CodeStyleSettings tempSettingsBefore = settingsManager.getTemporarySettings();
        try {
            settingsManager.setTemporarySettings(tempSettings);
            runnable.run();
        }
        finally {
            if (tempSettingsBefore != null) {
                settingsManager.setTemporarySettings(tempSettingsBefore);
            } else {
                settingsManager.dropTemporarySettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void doWithTemporarySettings(@NotNull Project project, @NotNull CodeStyleSettings baseSettings, @NotNull Consumer<? super CodeStyleSettings> tempSettingsConsumer) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(31);
        }
        if (baseSettings == null) {
            CodeStyle.$$$reportNull$$$0(32);
        }
        if (tempSettingsConsumer == null) {
            CodeStyle.$$$reportNull$$$0(33);
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance(project);
        CodeStyleSettings tempSettingsBefore = settingsManager.getTemporarySettings();
        try {
            CodeStyleSettings tempSettings = settingsManager.createTemporarySettings();
            tempSettings.copyFrom(baseSettings);
            tempSettingsConsumer.accept(tempSettings);
        }
        finally {
            if (tempSettingsBefore != null) {
                settingsManager.setTemporarySettings(tempSettingsBefore);
            } else {
                settingsManager.dropTemporarySettings();
            }
        }
    }

    public static boolean usesOwnSettings(@NotNull Project project) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(34);
        }
        return CodeStyleSettingsManager.getInstance((Project)project).USE_PER_PROJECT_SETTINGS;
    }

    public static void updateDocumentIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        PsiDocumentManager documentManager;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(35);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(36);
        }
        if (!project.isDisposed() && (documentManager = PsiDocumentManager.getInstance(project)) != null && (file = documentManager.getPsiFile(document)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(file).getIndentOptionsByFile(file, null, true, null);
            indentOptions.associateWithDocument(document);
        }
    }

    public static void setMainProjectSettings(@NotNull Project project, @NotNull CodeStyleSettings settings) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(37);
        }
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(38);
        }
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance(project);
        codeStyleSettingsManager.setMainProjectCodeStyle(settings);
        codeStyleSettingsManager.USE_PER_PROJECT_SETTINGS = true;
    }

    public static boolean isFormattingEnabled(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(39);
        }
        return !CodeStyle.getSettings(file).getExcludedFiles().contains(file);
    }

    public static void reformatWithFileContext(@NotNull PsiFile fileToReformat, @NotNull PsiFile contextFile) {
        if (fileToReformat == null) {
            CodeStyle.$$$reportNull$$$0(40);
        }
        if (contextFile == null) {
            CodeStyle.$$$reportNull$$$0(41);
        }
        Project project = contextFile.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
        CodeStyleSettings realFileSettings = CodeStyle.getSettings(contextFile);
        CodeStyle.doWithTemporarySettings(project, realFileSettings, () -> codeStyleManager.reformat(fileToReformat));
    }

    @TestOnly
    public static CodeStyleSettings createTestSettings(@Nullable CodeStyleSettings baseSettings) {
        return CodeStyleSettingsManager.createTestSettings(baseSettings);
    }

    public static String getLineIndent(@NotNull Editor editor, @Nullable Language language, int offset, boolean allowDocCommit) {
        String indent;
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(42);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider(language);
        String string = indent = lineIndentProvider != null ? lineIndentProvider.getLineIndent(project, editor, language, offset) : null;
        if (indent == LineIndentProvider.DO_NOT_ADJUST) {
            return allowDocCommit ? null : indent;
        }
        return indent != null ? indent : (allowDocCommit ? CodeStyle.getLineIndent(project, editor.getDocument(), offset) : null);
    }

    @Nullable
    private static String getLineIndent(@Nullable Project project, @NotNull Document document, int offset) {
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(43);
        }
        if (project == null) {
            return null;
        }
        PsiDocumentManager.getInstance(project).commitDocument(document);
        return CodeStyleManager.getInstance(project).getLineIndent(document, offset);
    }

    public static int getJoinedLinesSpacing(@NotNull Editor editor, @Nullable Language language, int offset, boolean allowDocCommit) {
        int space;
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(44);
        }
        if ((project = editor.getProject()) == null) {
            return 0;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider(language);
        int n = space = lineIndentProvider instanceof JoinedLinesSpacingCalculator ? ((JoinedLinesSpacingCalculator)((Object)lineIndentProvider)).getJoinedLinesSpacing(project, editor, language, offset) : -1;
        if (space < 0 && allowDocCommit) {
            Document document = editor.getDocument();
            PsiDocumentManager.getInstance(project).commitDocument(document);
            PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(document);
            if (file == null) {
                return 0;
            }
            return Math.max(0, CodeStyleManager.getInstance(project).getSpacing(file, offset));
        }
        return Math.max(0, space);
    }

    @TestOnly
    public static CodeStyleSettings createTestSettings() {
        return CodeStyleSettingsManager.createTestSettings(null);
    }

    @NotNull
    public static CodeStyleSettingsFacade getFacade(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(45);
        }
        return new DefaultCodeStyleSettingsFacade(CodeStyle.getSettings(file), file.getFileType());
    }

    @NotNull
    public static CodeStyleSettingsFacade getFacade(@NotNull Project project, @NotNull Document document, @NotNull FileType fileType) {
        PsiFile psiFile;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(46);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(47);
        }
        if (fileType == null) {
            CodeStyle.$$$reportNull$$$0(48);
        }
        if ((psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document)) != null) {
            return new DefaultCodeStyleSettingsFacade(CodeStyle.getSettings(psiFile), fileType);
        }
        return new DefaultCodeStyleSettingsFacade(CodeStyle.getSettings(project), fileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 1: 
            case 8: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 26: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 24: 
            case 36: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: 
            case 11: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettings";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettingsConsumer";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToReformat";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSettings";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageSettings";
                break;
            }
            case 20: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsPsi";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalVirtualFile";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsByFileType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSize";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doWithTemporarySettings";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "usesOwnSettings";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentIndentOptions";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setMainProjectSettings";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isFormattingEnabled";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reformatWithFileContext";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getJoinedLinesSpacing";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getFacade";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

