/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.behat.BehatBundle;
import com.jetbrains.php.behat.BehatUtil;
import com.jetbrains.php.behat.ContextInterfaceProvider;
import com.jetbrains.php.behat.steps.generation.BehatStepDefinitionsFactory;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.refactoring.PhpFileCreator;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public final class BehatStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    private static final Logger LOG = Logger.getInstance(BehatStepDefinitionCreator.class);
    private static final String PHP_FILE_EXTENSION = "." + PhpFileType.INSTANCE.getDefaultExtension();
    private static final PhpClassReferenceResolver myReferenceResolver = new PhpClassReferenceResolver(){

        protected void processReference(@NotNull String name, @NotNull String fqn, @NotNull PsiElement identifier, @NotNull PhpReference reference) {
            String resolvedFqn;
            Collection classes;
            if (name == null) {
                1.$$$reportNull$$$0(0);
            }
            if (fqn == null) {
                1.$$$reportNull$$$0(1);
            }
            if (identifier == null) {
                1.$$$reportNull$$$0(2);
            }
            if (reference == null) {
                1.$$$reportNull$$$0(3);
            }
            if ((classes = PhpIndex.getInstance((Project)identifier.getProject()).getClassesByName(name)).size() == 1 && StringUtil.isNotEmpty((String)(resolvedFqn = ((PhpClass)classes.iterator().next()).getFQN()))) {
                super.processReference(name, resolvedFqn, identifier, reference);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fqn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "identifier";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reference";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/behat/steps/BehatStepDefinitionCreator$1";
            objectArray[2] = "processReference";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        String fileName;
        PsiFile file;
        if (dir == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        if (name == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(1);
        }
        if ((file = dir.findFile(fileName = name + PHP_FILE_EXTENSION)) != null) {
            PhpClass clazz;
            String pathToDir = dir.getVirtualFile().getPresentableUrl();
            if (file instanceof PhpFile && (clazz = PhpPsiUtil.findClass((PhpFile)((PhpFile)file), aClass -> PhpLangUtil.equalsClassNames((CharSequence)aClass.getName(), (CharSequence)name))) != null) {
                LOG.info(BehatBundle.message("php.behat.step.definition.creator.file.already.exists", name, pathToDir));
                PsiFile psiFile = file;
                if (psiFile == null) {
                    BehatStepDefinitionCreator.$$$reportNull$$$0(2);
                }
                return psiFile;
            }
            throw new RuntimeException(BehatBundle.message("php.behat.step.definition.creator.can.not.create.container", name, pathToDir));
        }
        Project project = dir.getProject();
        ContextInterfaceProvider provider = ContextInterfaceProvider.chooseContextProvider(project);
        PhpClass clazz = (PhpClass)PhpPsiElementFactory.createPhpPsiFromText((Project)project, PhpClass.class, (String)provider.generateContent(project, name));
        PsiFile newFile = PhpFileCreator.createPhpFileWithContent((Project)project, (PsiDirectory)dir, (String)fileName, (PsiElement)clazz);
        WriteAction.run(() -> provider.tuneGeneratedContent(project, newFile));
        PhpCodeUtil.openRelatedFile((Project)project, (PsiElement)newFile);
        PsiFile psiFile = newFile;
        if (psiFile == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    @Nullable
    private static PhpClass findClass(@NotNull Project project, @NotNull PhpFile file) {
        Collection allClasses;
        if (project == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        if ((allClasses = PhpPsiUtil.findAllClasses((PhpFile)file)).isEmpty()) {
            return null;
        }
        if (allClasses.size() == 1) {
            return (PhpClass)allClasses.iterator().next();
        }
        return (PhpClass)ContainerUtil.find((Iterable)allClasses, i -> BehatUtil.isContextClass(ContextInterfaceProvider.chooseContextProvider(project).getContextInterface(project), i));
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file, boolean withTemplate) {
        if (step == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        if (file == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(7);
        }
        if (!(file instanceof PhpFile)) {
            return false;
        }
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        try {
            this.closeActiveTemplateBuilders(file);
            PhpClass clazz = BehatStepDefinitionCreator.findClass(project, (PhpFile)file);
            if (clazz == null) {
                throw new ExecutionException(BehatBundle.message("php.behat.step.definition.creator.can.not.find.class.in.the.file", file.getVirtualFile().getPath()));
            }
            ReferenceOpenHashSet methodNames = new ReferenceOpenHashSet((Collection)ContainerUtil.map((Collection)clazz.getMethods(), i -> StringUtil.toLowerCase((String)i.getName())));
            String snippet = BehatStepDefinitionsFactory.getInstance().makeSnippet(step, (Set<String>)methodNames);
            Method method = PhpPsiElementFactory.createMethod((Project)project, (String)snippet);
            myReferenceResolver.processElement((PsiElement)method, false);
            PsiElement inserted = PhpCodeEditUtil.insertClassMemberWithPhpDoc((PhpClass)clazz, (PsiElement)method, (PhpDocComment)method.getDocComment());
            inserted = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)inserted);
            PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)inserted);
            if (scope != null) {
                myReferenceResolver.importReferences(scope, inserted);
            }
            if (editor != null) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                documentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
            }
            PhpCodeUtil.openRelatedFile((Project)project, (PsiElement)inserted);
        }
        catch (ExecutionException e) {
            String message = BehatBundle.message("php.behat.step.definition.creator.can.not.generate.caused", e.getMessage());
            BehatUtil.showErrorNotification(project, "", message);
        }
        return true;
    }

    @NotNull
    public String getDefaultStepDefinitionFolderPath(@NotNull GherkinStep step) {
        PsiFile featureFile;
        PsiDirectory dir;
        if (step == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(8);
        }
        if ((dir = BehatStepDefinitionCreator.findStepDefinitionDirectory(featureFile = step.getContainingFile())) == null) {
            PsiDirectory featureParentDir = featureFile.getParent();
            assert (featureParentDir != null);
            String string = FileUtil.join((String[])new String[]{featureParentDir.getVirtualFile().getPath(), ContextInterfaceProvider.chooseDirName(step.getProject())});
            if (string == null) {
                BehatStepDefinitionCreator.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = dir.getVirtualFile().getPath();
        if (string == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static PsiDirectory findStepDefinitionDirectory(@NotNull PsiFile featureFile) {
        VirtualFile stepsDir;
        VirtualFile featureDir;
        if (featureFile == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(11);
        }
        PsiDirectory psiFeatureDir = featureFile.getContainingDirectory();
        assert (psiFeatureDir != null);
        Project project = featureFile.getProject();
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(featureDir);
        for (featureDir = psiFeatureDir.getVirtualFile(); featureDir != null && !Comparing.equal((Object)featureDir, (Object)contentRoot) && featureDir.findChild(ContextInterfaceProvider.chooseDirName(project)) == null; featureDir = featureDir.getParent()) {
        }
        if (featureDir != null && (stepsDir = featureDir.findChild(ContextInterfaceProvider.chooseDirName(project))) != null) {
            return featureFile.getManager().findDirectory(stepsDir);
        }
        return null;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(12);
        }
        String string = ContextInterfaceProvider.chooseDefaultStepName(step.getProject());
        if (string == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/steps/BehatStepDefinitionCreator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/steps/BehatStepDefinitionCreator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepDefinitionFolderPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepDefinitionFolderPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefinitionDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

