/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.behat.steps.BehatPatternPolicy;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class BehatRegexPatternPolicy
implements BehatPatternPolicy {
    private static final Pattern NAMED_GROUP_PREFIX = Pattern.compile("\\(\\?P<[^>]+>");
    public static final BehatRegexPatternPolicy INSTANCE = new BehatRegexPatternPolicy();

    private BehatRegexPatternPolicy() {
    }

    @Override
    public boolean isApplicable(@NotNull String regex) {
        if (regex == null) {
            BehatRegexPatternPolicy.$$$reportNull$$$0(0);
        }
        if (regex.length() < 2) {
            return false;
        }
        int lastIndex = BehatRegexPatternPolicy.getClosingIndex(regex, regex.charAt(0));
        if (lastIndex < 0) {
            return false;
        }
        for (int i = lastIndex + 1; i < regex.length(); ++i) {
            if (BehatRegexPatternPolicy.isRegExModifierChar(regex.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int getClosingIndex(@NotNull String regex, char start) {
        if (regex == null) {
            BehatRegexPatternPolicy.$$$reportNull$$$0(1);
        }
        if (start == '{') {
            return regex.lastIndexOf(125);
        }
        if (start == '/' || start == '~' || start == '\\' || start == '#' || start == '`') {
            return regex.lastIndexOf(start);
        }
        return -1;
    }

    private static boolean isRegExModifierChar(char ch) {
        return ch == 'i' || ch == 'm' || ch == 's' || ch == 'x' || ch == 'A' || ch == 'D' || ch == 'S' || ch == 'U' || ch == 'X' || ch == 'J' || ch == 'u';
    }

    @Override
    @NotNull
    public String process(@NotNull String regex) {
        if (regex == null) {
            BehatRegexPatternPolicy.$$$reportNull$$$0(2);
        }
        String pattern = BehatRegexPatternPolicy.trimRegExModifiers(regex);
        String string = NAMED_GROUP_PREFIX.matcher(StringUtil.newBombedCharSequence((CharSequence)pattern, (long)1000L)).replaceAll("(");
        if (string == null) {
            BehatRegexPatternPolicy.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String trimRegExModifiers(@NotNull String regex) {
        int lastIndex;
        if (regex == null) {
            BehatRegexPatternPolicy.$$$reportNull$$$0(4);
        }
        if ((lastIndex = BehatRegexPatternPolicy.getClosingIndex(regex, regex.charAt(0))) > 0 && lastIndex < regex.length()) {
            String string = regex.substring(1, lastIndex);
            if (string == null) {
                BehatRegexPatternPolicy.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = regex;
        if (string == null) {
            BehatRegexPatternPolicy.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/steps/BehatRegexPatternPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/steps/BehatRegexPatternPolicy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "trimRegExModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClosingIndex";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trimRegExModifiers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

