/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.behat.BehatContextSearcher;
import com.jetbrains.php.behat.steps.BehatStepDefinition;
import com.jetbrains.php.behat.steps.BehatStepDefinitionCreator;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class BehatExtension
extends AbstractCucumberExtension {
    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            BehatExtension.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            BehatExtension.$$$reportNull$$$0(1);
        }
        return this.isStepLikeFile(child, parent) && child.isWritable();
    }

    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            BehatExtension.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            BehatExtension.$$$reportNull$$$0(3);
        }
        return parent instanceof PsiDirectory && child instanceof PhpFile;
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        return new BDDFrameworkType((FileType)PhpFileType.INSTANCE);
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        return new BehatStepDefinitionCreator();
    }

    public Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            BehatExtension.$$$reportNull$$$0(4);
        }
        Project project = featureFile.getProject();
        return new BehatContextSearcher(project, (Condition<? super PsiFile>)((Condition)file -> ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file.getVirtualFile()))).findContextFiles();
    }

    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            BehatExtension.$$$reportNull$$$0(5);
        }
        ArrayList<AbstractStepDefinition> definitions = new ArrayList<AbstractStepDefinition>();
        if (featureFile != null) {
            Set<PsiFile> files = new BehatContextSearcher(featureFile.getProject()).findContextFiles();
            for (PsiFile file : files) {
                Collection<AbstractStepDefinition> definitionsInFile = this.getStepDefinitions(file);
                definitions.addAll(definitionsInFile);
            }
        }
        return definitions;
    }

    protected Collection<AbstractStepDefinition> getStepDefinitions(@NotNull PsiFile file) {
        if (file == null) {
            BehatExtension.$$$reportNull$$$0(6);
        }
        ArrayList<AbstractStepDefinition> newDefs = new ArrayList<AbstractStepDefinition>();
        if (!(file instanceof PhpFile)) {
            return newDefs;
        }
        Collection featureContext = PhpPsiUtil.findAllClasses((PhpFile)((PhpFile)file));
        for (PhpClass clazz : featureContext) {
            Method[] methods;
            for (Method method : methods = clazz.getOwnMethods()) {
                BehatStepDefinition definition = BehatExtension.processCall((Function)method);
                if (definition == null) continue;
                newDefs.add(definition);
            }
        }
        return newDefs;
    }

    @Nullable
    private static BehatStepDefinition processCall(@NotNull Function function) {
        PhpDocComment comment;
        List tags;
        if (function == null) {
            BehatExtension.$$$reportNull$$$0(7);
        }
        if ((tags = PhpPsiUtil.getChildren((PsiElement)(comment = function.getDocComment()), (Condition)PhpDocTag.INSTANCEOF)).isEmpty()) {
            return null;
        }
        GherkinKeywordProvider provider = JsonGherkinKeywordProvider.getKeywordProvider((PsiElement)((PsiElement)tags.get(0)));
        for (PhpDocTag tag : tags) {
            String name = tag.getName();
            if (!StringUtil.startsWith((CharSequence)name, (CharSequence)"@") || !provider.isStepKeyword(StringUtil.trimStart((String)name, (String)"@"))) continue;
            return new BehatStepDefinition((PsiElement)function);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/behat/BehatExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWritableStepLikeFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStepLikeFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStepDefinitionContainers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadStepsFor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getStepDefinitions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

