/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.behat.ContextInterfaceProvider;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BehatContextSearcher {
    private static final int MAX_TRAIT_INVESTIGATION_DEPTH = 10;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Condition<? super PsiFile> myFileFilter;
    @NotNull
    private final Set<PsiFile> myContextFiles;

    public BehatContextSearcher(@NotNull Project project) {
        if (project == null) {
            BehatContextSearcher.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public BehatContextSearcher(@NotNull Project project, @Nullable Condition<? super PsiFile> fileFilter) {
        if (project == null) {
            BehatContextSearcher.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFileFilter = fileFilter;
        this.myContextFiles = new HashSet<PsiFile>();
    }

    @NotNull
    public Set<PsiFile> findContextFiles() {
        HashSet<PhpClass> traits = new HashSet<PhpClass>();
        ContextInterfaceProvider provider = ContextInterfaceProvider.chooseContextProvider(this.myProject);
        PhpClass contextInterface = provider.getContextInterface(this.myProject);
        if (contextInterface != null) {
            this.findFilesByContextClass(contextInterface, traits);
        }
        for (PhpClass trait : traits) {
            if (!trait.isValid()) continue;
            this.addFile(trait);
        }
        Set<PsiFile> set = this.myContextFiles;
        if (set == null) {
            BehatContextSearcher.$$$reportNull$$$0(2);
        }
        return set;
    }

    private void findFilesByContextClass(@NotNull PhpClass clazz, @NotNull Set<PhpClass> traits) {
        if (clazz == null) {
            BehatContextSearcher.$$$reportNull$$$0(3);
        }
        if (traits == null) {
            BehatContextSearcher.$$$reportNull$$$0(4);
        }
        if (clazz.isValid()) {
            this.addFile(clazz);
            this.findFilesBySubclasses(clazz, traits);
        }
    }

    private void findFilesBySubclasses(@NotNull PhpClass clazz, @NotNull Set<PhpClass> traits) {
        if (clazz == null) {
            BehatContextSearcher.$$$reportNull$$$0(5);
        }
        if (traits == null) {
            BehatContextSearcher.$$$reportNull$$$0(6);
        }
        if (!clazz.isValid()) {
            return;
        }
        Collection subclasses = PhpClassHierarchyUtils.getAllSubclasses((PhpClass)clazz);
        for (PhpClass subclass : subclasses) {
            if (!subclass.isValid()) continue;
            Project project = clazz.getProject();
            Collection allSubClasses = PhpIndex.getInstance((Project)project).getAnyByFQN(subclass.getFQN());
            for (PhpClass aClass : allSubClasses) {
                this.addFile(aClass);
                BehatContextSearcher.collectTraits(aClass, traits, 0);
            }
            this.findFilesBySubclasses(subclass, traits);
        }
    }

    private static void collectTraits(@NotNull PhpClass clazz, @NotNull Set<? super PhpClass> allTraits, int depth) {
        PhpClass[] traits;
        if (clazz == null) {
            BehatContextSearcher.$$$reportNull$$$0(7);
        }
        if (allTraits == null) {
            BehatContextSearcher.$$$reportNull$$$0(8);
        }
        for (PhpClass trait : traits = clazz.getTraits()) {
            if (allTraits.contains(trait)) continue;
            allTraits.add((PhpClass)trait);
            if (depth >= 10 || !trait.isTrait()) continue;
            BehatContextSearcher.collectTraits(trait, allTraits, depth + 1);
        }
    }

    private void addFile(@NotNull PhpClass trait) {
        if (trait == null) {
            BehatContextSearcher.$$$reportNull$$$0(9);
        }
        PsiFile file = trait.getContainingFile();
        if (this.myFileFilter == null || this.myFileFilter.value((Object)file)) {
            this.myContextFiles.add(file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/BehatContextSearcher";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traits";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allTraits";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/BehatContextSearcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findContextFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFilesByContextClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFilesBySubclasses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectTraits";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

