/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.behat.BehatContextRoot;
import com.jetbrains.php.behat.ContextInterfaceProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BehatContextInterfaceProvider
implements ContextInterfaceProvider {
    public static final String FEATURE_CONTEXT = "FeatureContext";
    public static final String PENDING_EXCEPTION = "PendingException";

    @Override
    @Nullable
    public PhpClass getContextInterface(@NotNull Project project) {
        Collection oldContextInterfaces;
        if (project == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(0);
        }
        if (!(oldContextInterfaces = PhpIndex.getInstance((Project)project).getInterfacesByFQN(BehatContextRoot.CONTEXT_INTERFACE.getFqn())).isEmpty()) {
            return (PhpClass)oldContextInterfaces.iterator().next();
        }
        Collection newContextInterfaces = PhpIndex.getInstance((Project)project).getInterfacesByFQN(BehatContextRoot.CONTEXT_INTERFACE_NEW.getFqn());
        return newContextInterfaces.isEmpty() ? null : (PhpClass)newContextInterfaces.iterator().next();
    }

    @Override
    public boolean isApplicable(@NotNull Project project) {
        PhpIndex instance;
        if (project == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(1);
        }
        return !(instance = PhpIndex.getInstance((Project)project)).getInterfacesByFQN(BehatContextRoot.CONTEXT_INTERFACE.getFqn()).isEmpty() || !instance.getInterfacesByFQN(BehatContextRoot.CONTEXT_INTERFACE_NEW.getFqn()).isEmpty();
    }

    @NotNull
    private static Pair<String, Boolean> getContextRoot(@NotNull Project project) {
        if (project == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(2);
        }
        for (BehatContextRoot root : BehatContextRoot.values()) {
            Collection contextRoot = root.isInterface() ? PhpIndex.getInstance((Project)project).getInterfacesByFQN(root.getFqn()) : PhpIndex.getInstance((Project)project).getClassesByFQN(root.getFqn());
            if (contextRoot.isEmpty()) continue;
            Pair pair = Pair.create((Object)root.getFqn(), (Object)root.isInterface());
            if (pair == null) {
                BehatContextInterfaceProvider.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)BehatContextRoot.CONTEXT_CLASS.getFqn(), (Object)BehatContextRoot.CONTEXT_CLASS.isInterface());
        if (pair == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @Override
    @NotNull
    public String getDefaultStepFileName() {
        return FEATURE_CONTEXT;
    }

    @Override
    @NotNull
    public String getStepDefinitionDirName() {
        return "bootstrap";
    }

    @Override
    @NotNull
    public String getDummyStepException() {
        return PENDING_EXCEPTION;
    }

    @Override
    @NotNull
    public String generateContent(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(5);
        }
        if (name == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(6);
        }
        StringBuilder content = new StringBuilder();
        content.append("/** empty */\nclass ");
        content.append(name);
        Pair<String, Boolean> root = BehatContextInterfaceProvider.getContextRoot(project);
        content.append((Boolean)root.getSecond() != false ? " implements " : " extends ");
        String rootFqn = (String)root.getFirst();
        content.append(PhpLangUtil.toShortName((String)rootFqn));
        content.append(" {\n}");
        String string = content.toString();
        if (string == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public void tuneGeneratedContent(@NotNull Project project, @NotNull PsiFile newFile) {
        if (project == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(8);
        }
        if (newFile == null) {
            BehatContextInterfaceProvider.$$$reportNull$$$0(9);
        }
        if (newFile instanceof PhpFile) {
            PhpAliasImporter.insertUseStatement((String)((String)BehatContextInterfaceProvider.getContextRoot(project).getFirst()), (PhpPsiElement)((PhpFile)newFile));
            Collection classes = PhpPsiUtil.findAllClasses((PhpFile)((PhpFile)newFile));
            assert (classes.size() == 1);
            PhpDocComment comment = ((PhpClass)classes.iterator().next()).getDocComment();
            if (comment != null) {
                comment.delete();
            }
        }
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(newFile.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/BehatContextInterfaceProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/BehatContextInterfaceProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextInterface";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContextRoot";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tuneGeneratedContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

