/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.settings;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.drupal.settings.DrupalSettingsPanel;
import com.jetbrains.php.frameworks.PhpFrameworkConfigurable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrupalConfigurable
implements PhpFrameworkConfigurable {
    private final DrupalDataService myService;
    private JPanel myDrupalSettingsPlaceholder;
    private JBCheckBox myEnabledCheckBox;
    private JPanel myMainPanel;
    private final DrupalSettingsPanel mySettingsForm;

    public DrupalConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myService = DrupalDataService.getInstance(project);
        this.mySettingsForm = new DrupalSettingsPanel(project, true);
        this.myDrupalSettingsPlaceholder.add((Component)this.mySettingsForm, "Center");
        this.myEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrupalConfigurable.this.updateSettingsPanelEnabled();
            }
        });
        this.updateSettingsPanelEnabled();
    }

    private void updateSettingsPanelEnabled() {
        UIUtil.setEnabled((Component)this.mySettingsForm, (boolean)this.myEnabledCheckBox.isSelected(), (boolean)true);
    }

    @Nls
    public String getDisplayName() {
        return DrupalBundle.message("drupal.title", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.drupal";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myService.isEnabled() != this.myEnabledCheckBox.isSelected()) {
            return true;
        }
        return this.mySettingsForm.isModified(this.myService);
    }

    public void apply() throws ConfigurationException {
        DrupalDataService.State state = new DrupalDataService.State();
        state.setEnabled(this.myEnabledCheckBox.isSelected());
        this.mySettingsForm.apply(state);
        this.myService.setState(state);
    }

    public void reset() {
        this.myEnabledCheckBox.setSelected(this.myService.isEnabled());
        this.mySettingsForm.reset(this.myService);
        this.updateSettingsPanelEnabled();
    }

    @NotNull
    public String getId() {
        return "php.drupal.base.configurable";
    }

    public void setDrupalDir(@Nullable @NlsSafe String path) {
        this.mySettingsForm.setDrupalDir(path);
    }

    public void setDrupalVersion(@Nullable DrupalVersion version) {
        this.mySettingsForm.setDrupalVersion(version);
    }

    public boolean isBeingUsed() {
        return this.myEnabledCheckBox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDrupalSettingsPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myEnabledCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DrupalBundle", DrupalConfigurable.class).getString("checkbox.enable.drupal.integration"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

