/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.init;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.lang.PhpFileType;
import ini4idea.file.IniFileType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DrupalExtensionMappingChecker {
    private static final Logger LOG = Logger.getInstance(DrupalExtensionMappingChecker.class);
    private static final Collection<? extends FileNameMatcher> PHP_FILE_NAME_MATCHERS = ContainerUtil.immutableList((Object[])new ExtensionFileNameMatcher[]{new ExtensionFileNameMatcher(PhpFileType.INSTANCE.getDefaultExtension()), new ExtensionFileNameMatcher("install"), new ExtensionFileNameMatcher("module"), new ExtensionFileNameMatcher("profile"), new ExtensionFileNameMatcher("test"), new ExtensionFileNameMatcher("theme"), new ExtensionFileNameMatcher("engine")});
    private static final Collection<? extends FileNameMatcher> INI_FILE_NAME_MATCHERS = Collections.singletonList(new ExtensionFileNameMatcher("info"));

    private DrupalExtensionMappingChecker() {
    }

    public static void checkFileTypeAssociation(@Nullable Project project) {
        DrupalDataService dataService = DrupalDataService.getInstance(project);
        if (!dataService.isEnabled()) {
            return;
        }
        DrupalExtensionMappingChecker.doCheckFileTypeAssociation(project, PHP_FILE_NAME_MATCHERS, (FileType)PhpFileType.INSTANCE);
        DrupalVersion version = dataService.getVersion();
        if (version != null && version.getNumber() < DrupalVersion.EIGHT.getNumber()) {
            DrupalExtensionMappingChecker.doCheckFileTypeAssociation(project, INI_FILE_NAME_MATCHERS, (FileType)IniFileType.INSTANCE);
        }
    }

    private static void doCheckFileTypeAssociation(Project project, Collection<? extends FileNameMatcher> matchers, final FileType fileType) {
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        final Map<FileNameMatcher, FileType> fileNames = DrupalExtensionMappingChecker.getWrongMatchers(fileTypeManager, matchers, fileType);
        if (!fileNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean addComma = false;
            for (Map.Entry<FileNameMatcher, FileType> entry : fileNames.entrySet()) {
                if (addComma) {
                    sb.append(", ");
                }
                sb.append(entry.getKey().getPresentableString());
                addComma = true;
            }
            String fileMatchers = sb.toString();
            ApplicationManager.getApplication().invokeLater(() -> {
                Function<Notification, AnAction> fixAction = notification -> new DumbAwareAction(DrupalBundle.message("action.fix.asoociation.text", new Object[0]), (Notification)notification){
                    final /* synthetic */ Notification val$notification;
                    {
                        this.val$notification = notification;
                        super(arg0);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DrupalExtensionMappingChecker.fixAssociation(fileTypeManager, fileNames.keySet(), fileType);
                        this.val$notification.expire();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/drupal/init/DrupalExtensionMappingChecker$1", "actionPerformed"));
                    }
                };
                DrupalUtil.notifyGlobally(project, DrupalBundle.message("plugin.title", new Object[0]), DrupalBundle.message("file.type.registration.warning", fileMatchers, fileType.getName()), NotificationType.WARNING, fixAction);
            });
        }
    }

    @NotNull
    private static Map<FileNameMatcher, FileType> getWrongMatchers(FileTypeManager fileTypeManager, @NotNull Collection<? extends FileNameMatcher> matchers, FileType fileType) {
        if (matchers == null) {
            DrupalExtensionMappingChecker.$$$reportNull$$$0(0);
        }
        HashMap<FileNameMatcher, FileType> fileNames = new HashMap<FileNameMatcher, FileType>();
        for (FileNameMatcher fileNameMatcher : matchers) {
            FileType registered;
            if (fileNameMatcher instanceof ExtensionFileNameMatcher) {
                registered = fileTypeManager.getFileTypeByExtension(((ExtensionFileNameMatcher)fileNameMatcher).getExtension());
            } else if (fileNameMatcher instanceof ExactFileNameMatcher) {
                registered = fileTypeManager.getFileTypeByFileName(((ExactFileNameMatcher)fileNameMatcher).getFileName());
            } else {
                LOG.error("Unexpected FileNameMatcher class " + fileNameMatcher.getClass() + " for " + fileNameMatcher.getPresentableString());
                break;
            }
            if (registered == fileType) continue;
            fileNames.put(fileNameMatcher, registered);
        }
        HashMap<FileNameMatcher, FileType> hashMap = fileNames;
        if (hashMap == null) {
            DrupalExtensionMappingChecker.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static void fixAssociation(FileTypeManager fileTypeManager, @NotNull Collection<FileNameMatcher> fileNameMatchers, FileType fileType) {
        Map<FileNameMatcher, FileType> refreshedFileNames;
        if (fileNameMatchers == null) {
            DrupalExtensionMappingChecker.$$$reportNull$$$0(2);
        }
        if (!(refreshedFileNames = DrupalExtensionMappingChecker.getWrongMatchers(fileTypeManager, fileNameMatchers, fileType)).isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> DrupalExtensionMappingChecker.doFixAssociation(fileTypeManager, refreshedFileNames, fileType));
        }
    }

    private static void doFixAssociation(FileTypeManager fileTypeManager, @NotNull Map<FileNameMatcher, FileType> fileNames, FileType fileType) {
        if (fileNames == null) {
            DrupalExtensionMappingChecker.$$$reportNull$$$0(3);
        }
        for (Map.Entry<FileNameMatcher, FileType> entry : fileNames.entrySet()) {
            fileTypeManager.removeAssociation(entry.getValue(), entry.getKey());
            fileTypeManager.associate(fileType, entry.getKey());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/drupal/init/DrupalExtensionMappingChecker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameMatchers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/drupal/init/DrupalExtensionMappingChecker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrongMatchers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWrongMatchers";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixAssociation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFixAssociation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

