/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.hooks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.hooks.DrupalHookIndexDescription;
import com.jetbrains.php.drupal.hooks.DrupalHookInvocationMethod;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DrupalHooksIndex
extends FileBasedIndexExtension<DrupalHookIndexDescription, Void> {
    @NonNls
    public static final ID<DrupalHookIndexDescription, Void> KEY = ID.create((String)"drupal.hook.name");
    private final KeyDescriptor<DrupalHookIndexDescription> myKeyDescriptor = new MyKeyDescriptor();

    @NotNull
    public ID<DrupalHookIndexDescription, Void> getName() {
        ID<DrupalHookIndexDescription, Void> iD = KEY;
        if (iD == null) {
            DrupalHooksIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<DrupalHookIndexDescription, Void, FileContent> getIndexer() {
        return new DataIndexer<DrupalHookIndexDescription, Void, FileContent>(){

            @NotNull
            public Map<DrupalHookIndexDescription, Void> map(@NotNull FileContent inputData) {
                DrupalDataService dataService;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(dataService = DrupalDataService.getInstance(inputData.getProject())).isEnabled() || !dataService.isVersionValid()) {
                    Map<DrupalHookIndexDescription, Void> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                final HashMap<DrupalHookIndexDescription, Void> map = new HashMap<DrupalHookIndexDescription, Void>();
                inputData.getPsiFile().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof FunctionReference) {
                            this.visitFunctionReference((FunctionReference)element);
                        }
                        super.visitElement(element);
                    }

                    public void visitFunctionReference(FunctionReference functionReference) {
                        DrupalHookInvocationMethod method = DrupalVersion.findOldestMethod(functionReference, false);
                        if (method == null) {
                            return;
                        }
                        String[] hookNames = method.getHookNamesFromInvocation(functionReference);
                        if (hookNames != null) {
                            for (String hook : hookNames) {
                                map.put(new DrupalHookIndexDescription(hook, method), null);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/drupal/hooks/DrupalHooksIndex$1$1", "visitElement"));
                    }
                });
                HashMap<DrupalHookIndexDescription, Void> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/drupal/hooks/DrupalHooksIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/drupal/hooks/DrupalHooksIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public KeyDescriptor<DrupalHookIndexDescription> getKeyDescriptor() {
        KeyDescriptor<DrupalHookIndexDescription> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            DrupalHooksIndex.$$$reportNull$$$0(1);
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            DrupalHooksIndex.$$$reportNull$$$0(2);
        }
        return voidDataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            DrupalHooksIndex.$$$reportNull$$$0(3);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 3;
    }

    public static void reindexIfNeeded(DrupalDataService.State newState, DrupalDataService.State oldState) {
        if (newState.isEnabled() && !oldState.isEnabled()) {
            FileBasedIndex.getInstance().scheduleRebuild(KEY, new Throwable());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/drupal/hooks/DrupalHooksIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyKeyDescriptor
    implements KeyDescriptor<DrupalHookIndexDescription> {
        private MyKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, DrupalHookIndexDescription value) throws IOException {
            if (out == null) {
                MyKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getMinVersion().getNumber());
            IOUtil.writeUTF((DataOutput)out, (String)value.getName());
        }

        public DrupalHookIndexDescription read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyKeyDescriptor.$$$reportNull$$$0(1);
            }
            int minVersion = DataInputOutputUtil.readINT((DataInput)in);
            DrupalVersion version = DrupalVersion.getFromNumber(minVersion);
            assert (version != null) : minVersion;
            String hookName = IOUtil.readUTF((DataInput)in);
            return new DrupalHookIndexDescription(hookName, version);
        }

        public int getHashCode(DrupalHookIndexDescription value) {
            return value.hashCode();
        }

        public boolean isEqual(DrupalHookIndexDescription val1, DrupalHookIndexDescription val2) {
            return val1.equals(val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/drupal/hooks/DrupalHooksIndex$MyKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

